/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.concept;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.LocalizedString;

public class Concept
implements IConcept,
Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = -6912836203678095834L;
    public static String NAME_PROPERTY = "name";
    public static String DESCRIPTION_PROPERTY = "description";
    public static String SECURITY_PROPERTY = "security";
    Map<String, Object> properties = new HashMap<String, Object>();
    String id;
    IConcept parentConcept;
    List<IConcept> children = null;

    @Override
    public IConcept getParent() {
        return this.parentConcept;
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>();
        if (this.getParent() != null && this.getParent().getUniqueId() != null) {
            uid.addAll(this.getParent().getUniqueId());
        }
        uid.add(this.getId());
        return uid;
    }

    @Override
    public IConcept getChildByUniqueId(List<String> uid) {
        return this.getChildByUniqueId(uid, 0);
    }

    protected IConcept getChildByUniqueId(List<String> uid, int index) {
        List<IConcept> children = this.getChildren();
        for (IConcept concept : children) {
            List<String> cuid = concept.getUniqueId();
            if (!cuid.get(cuid.size() - 1).equals(uid.get(index))) continue;
            if (index == uid.size() - 1) {
                return concept;
            }
            return ((Concept)concept).getChildByUniqueId(uid, index + 1);
        }
        return null;
    }

    @Override
    public Map<String, Object> getChildProperties() {
        return this.properties;
    }

    public void setChildProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Object getChildProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IConcept getInheritedConcept() {
        return null;
    }

    @Override
    public IConcept getParentConcept() {
        return this.parentConcept;
    }

    @Override
    public void setParentConcept(IConcept parentConcept) {
        this.parentConcept = parentConcept;
    }

    @Override
    public IConcept getSecurityParentConcept() {
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        Object securityProperty;
        HashMap<String, Object> all = new HashMap<String, Object>();
        if (this.getInheritedConcept() != null) {
            all.putAll(this.getInheritedConcept().getProperties());
        }
        if (this.parentConcept != null) {
            all.putAll(this.parentConcept.getProperties());
        }
        if (this.getSecurityParentConcept() != null && (securityProperty = this.getSecurityParentConcept().getProperty(SECURITY_PROPERTY)) != null) {
            all.put(SECURITY_PROPERTY, securityProperty);
        }
        all.putAll(this.properties);
        return all;
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public void setProperty(String name, Object property) {
        this.properties.put(name, property);
    }

    @Override
    public void removeChildProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public LocalizedString getName() {
        return (LocalizedString)this.getProperty(NAME_PROPERTY);
    }

    @Override
    public String getName(String locale) {
        LocalizedString locName = this.getName();
        if (locName == null) {
            return this.getId();
        }
        String name = locName.getLocalizedString(locale);
        if (name == null || name.trim().length() == 0) {
            return this.getId();
        }
        return name;
    }

    @Override
    public void setName(LocalizedString name) {
        this.setProperty(NAME_PROPERTY, name);
    }

    @Override
    public String getDescription(String locale) {
        LocalizedString locDesc = this.getDescription();
        if (locDesc == null) {
            return this.getId();
        }
        String name = locDesc.getLocalizedString(locale);
        if (name == null || name.trim().length() == 0) {
            return this.getId();
        }
        return name;
    }

    @Override
    public LocalizedString getDescription() {
        return (LocalizedString)this.getProperty(DESCRIPTION_PROPERTY);
    }

    @Override
    public void setDescription(LocalizedString description) {
        this.setProperty(DESCRIPTION_PROPERTY, description);
    }

    public int compareTo(Object o) {
        Concept c = (Concept)o;
        return this.getId().compareTo(c.getId());
    }

    @Override
    public Object clone() {
        return this.clone(new Concept());
    }

    protected Object clone(Concept clone) {
        clone.setId(this.getId());
        clone.setChildProperties(this.getChildProperties());
        clone.setParentConcept(this.getParentConcept());
        return clone;
    }

    @Override
    public List<IConcept> getChildren() {
        return this.children;
    }

    public void addChild(IConcept child) {
        if (this.children == null) {
            this.children = new ArrayList<IConcept>();
        }
        this.children.add(child);
    }
}

