/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.RelationshipType;

public class LogicalRelationship
extends Concept {
    private static final long serialVersionUID = -2673951365033614344L;
    public static final String COMPLEX = "complex";
    public static final String COMPLEX_JOIN = "complex_join";
    public static final String RELATIONSHIP_TYPE = "relationship_type";
    public static final String JOIN_ORDER_KEY = "join_order_key";
    private String relationshipDescription = null;
    private LogicalModel logicalModel;
    private LogicalTable fromTable;
    private LogicalTable toTable;
    private LogicalColumn fromColumn;
    private LogicalColumn toColumn;
    private static final String CLASS_ID = "LogicalRelationship";

    public LogicalRelationship() {
        this.setComplex(false);
        this.setRelationshipType(RelationshipType.UNDEFINED);
    }

    public LogicalRelationship(LogicalModel logicalModel, LogicalTable fromTable, LogicalTable toTable, LogicalColumn fromColumn, LogicalColumn toColumn) {
        this();
        this.logicalModel = logicalModel;
        this.fromTable = fromTable;
        this.toTable = toTable;
        this.fromColumn = fromColumn;
        this.toColumn = toColumn;
    }

    public void setLogicalModel(LogicalModel logicalModel) {
        this.logicalModel = logicalModel;
    }

    public LogicalModel getLogicalModel() {
        return this.logicalModel;
    }

    public String getRelationshipDescription() {
        return this.relationshipDescription;
    }

    public void setRelationshipDescription(String description) {
        this.relationshipDescription = description;
    }

    @Override
    public IConcept getParent() {
        return this.logicalModel;
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>(this.logicalModel.getUniqueId());
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    public Boolean isComplex() {
        return (Boolean)this.getProperty(COMPLEX);
    }

    public void setComplex(Boolean complex) {
        this.setProperty(COMPLEX, complex);
    }

    public String getComplexJoin() {
        return (String)this.getProperty(COMPLEX_JOIN);
    }

    public void setComplexJoin(String complexJoin) {
        this.setProperty(COMPLEX_JOIN, complexJoin);
    }

    public RelationshipType getRelationshipType() {
        return (RelationshipType)((Object)this.getProperty(RELATIONSHIP_TYPE));
    }

    public void setRelationshipType(RelationshipType relationshipType) {
        this.setProperty(RELATIONSHIP_TYPE, (Object)relationshipType);
    }

    public String getJoinOrderKey() {
        return (String)this.getProperty(JOIN_ORDER_KEY);
    }

    public void setJoinOrderKey(String joinOrderKey) {
        this.setProperty(JOIN_ORDER_KEY, joinOrderKey);
    }

    public LogicalTable getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(LogicalTable fromTable) {
        this.fromTable = fromTable;
    }

    public LogicalTable getToTable() {
        return this.toTable;
    }

    public void setToTable(LogicalTable toTable) {
        this.toTable = toTable;
    }

    public LogicalColumn getFromColumn() {
        return this.fromColumn;
    }

    public void setFromColumn(LogicalColumn fromColumn) {
        this.fromColumn = fromColumn;
    }

    public LogicalColumn getToColumn() {
        return this.toColumn;
    }

    public void setToColumn(LogicalColumn toColumn) {
        this.toColumn = toColumn;
    }

    public boolean isUsingTable(LogicalTable table) {
        if (table == null) {
            return false;
        }
        return table.getId().equals(this.toTable.getId()) || table.getId().equals(this.fromTable.getId());
    }
}

