/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.metadata.model.concept.types.LocalizedString;

public class LogicalModel
extends Concept {
    private static final long serialVersionUID = 4063396040423259880L;
    public static final String ROW_LEVEL_SECURITY = "row_level_security";
    public static final String PROPERTY_OLAP_DIMS = "olap_dimensions";
    public static final String PROPERTY_OLAP_CUBES = "olap_cubes";
    public static final String PROPERTY_TARGET_TABLE_STAGED = "target_table_staged";
    private Domain domain;
    private IPhysicalModel physicalModel;
    private List<LogicalTable> logicalTables = new ArrayList<LogicalTable>();
    private List<LogicalRelationship> logicalRelationships = new ArrayList<LogicalRelationship>();
    private List<Category> categories = new ArrayList<Category>();
    private static final String CLASS_ID = "LogicalModel";

    public LogicalModel() {
        this.setName(new LocalizedString());
        this.setDescription(new LocalizedString());
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>();
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    @Override
    public IConcept getParent() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.logicalTables);
        children.addAll(this.logicalRelationships);
        children.addAll(this.categories);
        return children;
    }

    public void setPhysicalModel(IPhysicalModel physicalModel) {
        this.physicalModel = physicalModel;
    }

    public IPhysicalModel getPhysicalModel() {
        return this.physicalModel;
    }

    public List<LogicalTable> getLogicalTables() {
        return this.logicalTables;
    }

    public void addLogicalTable(LogicalTable table) {
        this.logicalTables.add(table);
    }

    public List<LogicalRelationship> getLogicalRelationships() {
        return this.logicalRelationships;
    }

    public void addLogicalRelationship(LogicalRelationship rel) {
        this.logicalRelationships.add(rel);
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public RowLevelSecurity getRowLevelSecurity() {
        return (RowLevelSecurity)this.getProperty(ROW_LEVEL_SECURITY);
    }

    public void setRowLevelSecurity(RowLevelSecurity rls) {
        this.setProperty(ROW_LEVEL_SECURITY, rls);
    }

    public Category findCategory(String categoryId) {
        for (Category category : this.getCategories()) {
            if (!categoryId.equals(category.getId())) continue;
            return category;
        }
        return null;
    }

    public LogicalTable findLogicalTable(String tableId) {
        for (LogicalTable table : this.getLogicalTables()) {
            if (!tableId.equals(table.getId())) continue;
            return table;
        }
        return null;
    }

    public LogicalColumn findLogicalColumn(String columnId) {
        for (LogicalTable table : this.getLogicalTables()) {
            for (LogicalColumn column : table.getLogicalColumns()) {
                if (!columnId.equals(column.getId())) continue;
                return column;
            }
        }
        return null;
    }

    public LogicalColumn findLogicalColumnInCategories(String columnId) {
        for (Category cat : this.getCategories()) {
            for (LogicalColumn column : cat.getLogicalColumns()) {
                if (!columnId.equals(column.getId())) continue;
                return column;
            }
        }
        return null;
    }

    public LogicalRelationship findRelationshipUsing(LogicalTable one, LogicalTable two) {
        for (LogicalRelationship relationship : this.getLogicalRelationships()) {
            if (!relationship.isUsingTable(one) || !relationship.isUsingTable(two)) continue;
            return relationship;
        }
        return null;
    }

    @Override
    public Object clone() {
        LogicalModel clone = new LogicalModel();
        this.clone(clone);
        clone.logicalRelationships = this.logicalRelationships;
        clone.physicalModel = this.physicalModel;
        clone.logicalTables = new ArrayList<LogicalTable>();
        for (LogicalTable table : this.logicalTables) {
            clone.addLogicalTable((LogicalTable)table.clone());
        }
        clone.categories = new ArrayList<Category>();
        for (Category category : this.categories) {
            clone.addCategory((Category)category.clone());
        }
        return clone;
    }
}

