/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.LocalizedString;

public class Category
extends Concept {
    private static final long serialVersionUID = -2367402604729602739L;
    private LogicalModel logicalModel;
    private List<LogicalColumn> logicalColumns = new ArrayList<LogicalColumn>();
    private static final String CLASS_ID = "Category";

    public Category() {
        this.setName(new LocalizedString());
        this.setDescription(new LocalizedString());
    }

    public Category(LogicalModel logicalModel) {
        this.logicalModel = logicalModel;
    }

    @Override
    public IConcept getParent() {
        return this.logicalModel;
    }

    @Override
    public List<String> getUniqueId() {
        ArrayList<String> uid = new ArrayList<String>(this.logicalModel.getUniqueId());
        uid.add(CLASS_ID.concat("-") + this.getId());
        return uid;
    }

    public void setLogicalModel(LogicalModel logicalModel) {
        this.logicalModel = logicalModel;
    }

    public LogicalModel getLogicalModel() {
        return this.logicalModel;
    }

    @Override
    public IConcept getSecurityParentConcept() {
        return this.getLogicalModel();
    }

    public List<LogicalColumn> getLogicalColumns() {
        return this.logicalColumns;
    }

    public void setLogicalColumns(List<LogicalColumn> columns) {
        this.logicalColumns = columns;
    }

    public void addLogicalColumn(LogicalColumn column) {
        this.logicalColumns.add(column);
    }

    public LogicalColumn findLogicalColumn(String columnId) {
        for (LogicalColumn col : this.getLogicalColumns()) {
            if (!columnId.equals(col.getId())) continue;
            return col;
        }
        return null;
    }

    @Override
    public Object clone() {
        Category clone = new Category();
        this.clone(clone);
        clone.setLogicalModel(this.logicalModel);
        clone.setLogicalColumns(new ArrayList<LogicalColumn>());
        for (LogicalColumn col : this.getLogicalColumns()) {
            clone.addLogicalColumn(col);
        }
        return clone;
    }
}

