/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.automodel;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.util.Util;

public class PhysicalTableImporter {
    public static SqlPhysicalTable importTableDefinition(Database database, String schemaName, String tableName, String locale) throws KettleException {
        String upper;
        List<IPhysicalColumn> fields = null;
        String id = tableName;
        String tablename = tableName;
        id = Util.toId(tableName);
        id = Util.getPhysicalTableIdPrefix() + id;
        id = id.toUpperCase();
        SqlPhysicalTable physicalTable = new SqlPhysicalTable();
        physicalTable.setId(id);
        physicalTable.setTargetSchema(schemaName);
        fields = physicalTable.getPhysicalColumns();
        physicalTable.setTargetTable(tableName);
        String niceName = PhysicalTableImporter.beautifyName(tablename);
        physicalTable.setName(new LocalizedString(locale, niceName));
        DatabaseMeta dbMeta = database.getDatabaseMeta();
        String schemaTableCombination = dbMeta.getSchemaTableCombination(dbMeta.quoteField(schemaName), dbMeta.quoteField(tableName));
        RowMetaInterface row = database.getTableFields(schemaTableCombination);
        if (row != null && row.size() > 0) {
            for (int i = 0; i < row.size(); ++i) {
                ValueMetaInterface v = row.getValueMeta(i);
                IPhysicalColumn physicalColumn = PhysicalTableImporter.importPhysicalColumnDefinition(v, physicalTable, locale);
                fields.add(physicalColumn);
            }
        }
        if ((upper = tablename.toUpperCase()).startsWith("D_") || upper.startsWith("DIM") || upper.endsWith("DIM")) {
            physicalTable.setTableType(TableType.DIMENSION);
        }
        if (upper.startsWith("F_") || upper.startsWith("FACT") || upper.endsWith("FACT")) {
            physicalTable.setTableType(TableType.FACT);
        }
        return physicalTable;
    }

    public static final String beautifyName(String name) {
        return StringUtils.capitalize((String)name.replaceAll("[\"`']", "").replace("_", " "));
    }

    private static IPhysicalColumn importPhysicalColumnDefinition(ValueMetaInterface v, SqlPhysicalTable physicalTable, String locale) {
        String id = Util.getPhysicalColumnIdPrefix() + v.getName();
        id = id.toUpperCase();
        String dbname = v.getName();
        FieldType fieldType = FieldType.guessFieldType(v.getName());
        SqlPhysicalColumn physicalColumn = new SqlPhysicalColumn(physicalTable);
        physicalColumn.setId(v.getName());
        physicalColumn.setTargetColumn(dbname);
        physicalColumn.setFieldType(fieldType);
        physicalColumn.setAggregationType(AggregationType.NONE);
        String niceName = PhysicalTableImporter.beautifyName(v.getName());
        physicalColumn.setName(new LocalizedString(locale, niceName));
        DataType dataType = PhysicalTableImporter.getDataType(v);
        physicalColumn.setDataType(dataType);
        return physicalColumn;
    }

    private static DataType getDataType(ValueMetaInterface v) {
        switch (v.getType()) {
            case 1: 
            case 5: 
            case 6: {
                return DataType.NUMERIC;
            }
            case 8: {
                return DataType.BINARY;
            }
            case 4: {
                return DataType.BOOLEAN;
            }
            case 3: {
                return DataType.DATE;
            }
            case 2: {
                return DataType.STRING;
            }
        }
        return DataType.UNKNOWN;
    }
}

