/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.automodel;

import java.util.ArrayList;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.automodel.SchemaTable;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.metadata.util.Util;
import org.pentaho.pms.core.exception.PentahoMetadataException;

public class AutoModeler {
    private DatabaseMeta databaseMeta;
    private SchemaTable[] tableNames;
    private String modelName;
    private String locale;

    public AutoModeler(String locale, String modelName, DatabaseMeta databaseMeta, SchemaTable[] tableNames) {
        this.locale = locale;
        this.modelName = modelName;
        this.databaseMeta = databaseMeta;
        this.tableNames = tableNames;
    }

    public Domain generateDomain() throws PentahoMetadataException {
        Domain domain = new Domain();
        domain.setId(this.modelName);
        ArrayList<LocaleType> locales = new ArrayList<LocaleType>();
        locales.add(new LocaleType("en_US", "English (US)"));
        domain.setLocales(locales);
        SqlPhysicalModel physicalModel = new SqlPhysicalModel();
        physicalModel.setId(this.databaseMeta.getName());
        physicalModel.setDatasource(ThinModelConverter.convertFromLegacy(this.databaseMeta));
        Database database = new Database(this.databaseMeta);
        try {
            domain.addPhysicalModel(physicalModel);
            String bmID = Util.getLogicalModelIdPrefix() + "_" + this.modelName.replaceAll(" ", "_").toUpperCase();
            LogicalModel logicalModel = new LogicalModel();
            logicalModel.setId(bmID);
            domain.addLogicalModel(logicalModel);
            database.connect();
            DBCache.getInstance().clear(this.databaseMeta.getName());
            for (int i = 0; i < this.tableNames.length; ++i) {
                SchemaTable schemaTable = this.tableNames[i];
                SqlPhysicalTable physicalTable = PhysicalTableImporter.importTableDefinition(database, schemaTable.getSchemaName(), schemaTable.getTableName(), this.locale);
                physicalModel.addPhysicalTable(physicalTable);
                LogicalTable businessTable = this.createBusinessTable(physicalTable, this.locale);
                logicalModel.addLogicalTable(businessTable);
            }
        }
        catch (Exception e) {
            throw new PentahoMetadataException(e);
        }
        finally {
            database.disconnect();
        }
        return domain;
    }

    private LogicalColumn findBusinessColumn(LogicalTable logicalTable, String columnName) {
        for (LogicalColumn logicalColumn : logicalTable.getLogicalColumns()) {
            if (!columnName.equals(((SqlPhysicalColumn)logicalColumn.getPhysicalColumn()).getTargetColumn())) continue;
            return logicalColumn;
        }
        return null;
    }

    private LogicalTable createBusinessTable(SqlPhysicalTable physicalTable, String locale) {
        LogicalTable businessTable = new LogicalTable(null, physicalTable);
        String tableName = PhysicalTableImporter.beautifyName(physicalTable.getTargetTable());
        businessTable.setName(new LocalizedString(locale, tableName));
        businessTable.setId(Util.proposeSqlBasedLogicalTableId(locale, businessTable, physicalTable));
        for (IPhysicalColumn physicalColumn : physicalTable.getPhysicalColumns()) {
            LogicalColumn businessColumn = new LogicalColumn();
            businessColumn.setPhysicalColumn(physicalColumn);
            businessColumn.setLogicalTable(businessTable);
            businessColumn.setId(Util.proposeSqlBasedLogicalColumnId(locale, businessTable, (SqlPhysicalColumn)physicalColumn));
            businessTable.addLogicalColumn(businessColumn);
        }
        return businessTable;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public SchemaTable[] getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(SchemaTable[] tableNames) {
        this.tableNames = tableNames;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

