/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import pt.webdetails.cgg.Chart;
import pt.webdetails.cgg.SVGChart;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.BaseScript;

public class SvgScript
extends BaseScript {
    private static final Log logger = LogFactory.getLog(SvgScript.class);

    public SvgScript(String source) {
        super(source);
    }

    @Override
    public Chart execute(Map<String, Object> params) throws ScriptExecuteException {
        if (Context.getCurrentContext() == null) {
            throw new ScriptExecuteException();
        }
        Context.getCurrentContext().getFactory().enterContext();
        try {
            this.addSVGDocumentToScope();
            this.executeScript(params);
            NativeJavaObject nativeDoc = (NativeJavaObject)ScriptableObject.getProperty((Scriptable)this.getScope(), (String)"_document");
            Document unwrappedDoc = (Document)nativeDoc.unwrap();
            SVGChart sVGChart = new SVGChart(unwrappedDoc);
            return sVGChart;
        }
        catch (Exception e) {
            throw new ScriptExecuteException(e);
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
    }

    private void addSVGDocumentToScope() {
        SVGDOMImplementation impl = (SVGDOMImplementation)SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGOMDocument document = (SVGOMDocument)impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
        new GVTBuilder().build(ctx, (Document)document);
        CSSEngine eng = impl.createCSSEngine((AbstractStylableDocument)document, (CSSContext)ctx);
        document.setCSSEngine(eng);
        BaseScope scope = this.getScope();
        Object wrappedDocument = Context.javaToJS((Object)document, (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"_document", (Object)wrappedDocument);
    }
}

