/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;

public class DefaultScriptResourceLoader
implements ScriptResourceLoader {
    private URL context;

    public DefaultScriptResourceLoader() {
    }

    public DefaultScriptResourceLoader(URL context) {
        this.context = context;
    }

    public URL getContext() {
        return this.context;
    }

    public void setContext(URL context) {
        this.context = context;
    }

    @Override
    public String getContextResourceURI(String script) throws IOException, ScriptResourceNotFoundException {
        if (this.context == null) {
            throw new ScriptResourceNotFoundException(script);
        }
        try {
            URL url = new URL(this.context, script);
            return url.toURI().toASCIIString();
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public InputStream getContextResource(String script) throws IOException, ScriptResourceNotFoundException {
        if (this.context == null) {
            throw new ScriptResourceNotFoundException(script);
        }
        try {
            URL url = new URL(this.context, script);
            return new BufferedInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Reader getContextLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        return new InputStreamReader(this.getContextResource(script));
    }

    @Override
    public Reader getSystemLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        throw new ScriptResourceNotFoundException(script);
    }
}

