/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.datasources;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.swing.table.TableModel;
import pt.webdetails.cgg.datasources.Exporter;

public class JsonExporter
implements Exporter {
    @Override
    public String export(TableModel tableModel) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.beginObject();
        writer.name("metadata");
        writer.beginArray();
        int columnCount = tableModel.getColumnCount();
        int rowCount = tableModel.getRowCount();
        for (int i = 0; i < columnCount; ++i) {
            writer.beginObject();
            writer.name("colIndex").value((long)i);
            writer.name("colName").value(tableModel.getColumnName(i));
            writer.name("colType").value(this.getColType(tableModel.getColumnClass(i)));
            writer.endObject();
        }
        writer.endArray();
        writer.name("resultset");
        writer.beginArray();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            writer.beginArray();
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                Object valueAt = tableModel.getValueAt(rowIdx, colIdx);
                if (valueAt == null) {
                    writer.nullValue();
                    continue;
                }
                writer.value(String.valueOf(valueAt));
            }
            writer.endArray();
        }
        writer.endArray();
        writer.endObject();
        writer.flush();
        return stringWriter.toString();
    }

    protected String getColType(Class<?> columnClass) {
        if (columnClass.equals(String.class)) {
            return "String";
        }
        if (columnClass.equals(Integer.class) || columnClass.equals(Short.class) || columnClass.equals(Byte.class)) {
            return "Integer";
        }
        if (Number.class.isAssignableFrom(columnClass)) {
            return "Numeric";
        }
        if (Date.class.isAssignableFrom(columnClass)) {
            return "Date";
        }
        if (columnClass.equals(Object.class)) {
            return "String";
        }
        throw new IllegalArgumentException("Cannot handle class: " + columnClass.toString(), null);
    }
}

