/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.w3c.dom.Document;
import pt.webdetails.cgg.Chart;

public class SVGChart
implements Chart {
    private Document svg;

    public SVGChart(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        this.svg = doc;
    }

    @Override
    public Document getRawObject() {
        return this.svg;
    }

    @Override
    public void renderAsPng(OutputStream out) throws IOException {
        PNGTranscoder t = new PNGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svg);
        TranscoderOutput output = new TranscoderOutput(out);
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (TranscoderException ex) {
            throw new IOException("Failed to transcode image", ex);
        }
    }

    @Override
    public void renderAsSVG(OutputStream out) throws IOException {
        SVGTranscoder t = new SVGTranscoder();
        TranscoderInput input = new TranscoderInput(this.svg);
        TranscoderOutput output = new TranscoderOutput((Writer)new OutputStreamWriter(out));
        try {
            t.transcode(input, output);
            out.flush();
        }
        catch (TranscoderException ex) {
            throw new IOException("Failed to transcode image", ex);
        }
    }
}

