/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.util;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.ContextLookup;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.Term;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

public class FormulaUtil {
    private static final char QUOTE_CHAR = '\"';

    private FormulaUtil() {
    }

    public static String quoteReference(String reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        char[] referenceChars = reference.toCharArray();
        if (!FormulaUtil.isQuotingNeeded(referenceChars)) {
            return '[' + reference + ']';
        }
        return '[' + FormulaUtil.quoteString(reference) + ']';
    }

    private static boolean isQuotingNeeded(char[] referenceChars) {
        if (referenceChars == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < referenceChars.length; ++i) {
            char c = referenceChars[i];
            if (Character.isJavaIdentifierPart(c)) continue;
            return true;
        }
        return false;
    }

    public static String quoteString(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(text.length());
        char[] chars = text.toCharArray();
        b.append('\"');
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                b.append('\"');
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    public static String[] getReferences(String formula) throws ParseException {
        if (formula == null) {
            throw new NullPointerException();
        }
        String formulaExpression = FormulaUtil.extractFormula(formula);
        if (formulaExpression == null) {
            throw new ParseException("Formula is invalid");
        }
        return FormulaUtil.getReferences(new Formula(formulaExpression));
    }

    public static String[] getReferences(Formula formula) {
        if (formula == null) {
            throw new NullPointerException();
        }
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        LValue lValue = formula.getRootReference();
        FormulaUtil.collectReferences(lValue, map);
        return map.keySet().toArray(new String[map.size()]);
    }

    private static void collectReferences(LValue lval, LinkedHashMap<String, Boolean> map) {
        if (lval instanceof Term) {
            Term t = (Term)lval;
            LValue[] childValues = t.getChildValues();
            for (int i = 0; i < childValues.length; ++i) {
                LValue childValue = childValues[i];
                FormulaUtil.collectReferences(childValue, map);
            }
        } else if (lval instanceof ContextLookup) {
            ContextLookup cl = (ContextLookup)lval;
            map.put(cl.getName(), Boolean.TRUE);
        }
    }

    public static String extractFormula(String formula) {
        String[] strings = FormulaUtil.extractFormulaContext(formula);
        return strings[1];
    }

    public static String extractStaticTextFromFormula(String formula) {
        if (formula == null) {
            return null;
        }
        String formulaFragment = FormulaUtil.extractFormula(formula);
        return FormulaUtil.extractStaticTextFromFormulaFragment(formulaFragment);
    }

    public static String extractStaticTextFromFormulaFragment(String formula) {
        if (formula == null) {
            return null;
        }
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return null;
                }
                return String.valueOf(o);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidFormulaFragment(String formula) {
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String createCellUITextFromFormula(String formula) {
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return "=NA()";
                }
                return String.valueOf(o);
            }
            String cellText = lValue.toString();
            return cellText.startsWith("=") ? cellText : "=" + cellText;
        }
        catch (Exception e) {
            return formula;
        }
    }

    public static String createEditorTextFromFormula(String formula, FormulaContext formulaContext) {
        ArgumentNullException.validate((String)"fomulaContext", (Object)formulaContext);
        try {
            FormulaParser parser = new FormulaParser();
            LValue lValue = parser.parse(formula);
            lValue.initialize(formulaContext);
            if (lValue.isConstant() && lValue instanceof StaticValue) {
                StaticValue staticValue = (StaticValue)lValue;
                Object o = staticValue.getValue();
                if (o == null) {
                    return "=NA()";
                }
                if (o instanceof Number) {
                    return String.valueOf(o);
                }
                return '\'' + String.valueOf(o);
            }
            String cellText = lValue.toString();
            return cellText.startsWith("=") ? cellText : "=" + cellText;
        }
        catch (Exception e) {
            return "'" + formula;
        }
    }

    public static String createFormulaFromUIText(String formula) {
        if (formula.startsWith("=")) {
            return formula.substring(1);
        }
        try {
            BigDecimal bd = new BigDecimal(formula.trim());
            return formula.trim();
        }
        catch (NumberFormatException numberFormatException) {
            if (formula.startsWith("'")) {
                return FormulaUtil.quoteString(formula.substring(1));
            }
            return FormulaUtil.quoteString(formula);
        }
    }

    public static String[] extractFormulaContext(String formula) {
        String formulaExpression;
        String formulaNamespace;
        if (formula == null) {
            formulaNamespace = null;
            formulaExpression = null;
        } else {
            Pattern pattern;
            Matcher matcher;
            if (formula.endsWith(";")) {
                DebugLog.log((Object)"A formula with a trailing semicolon is not valid. Auto-correcting the formula.");
                formula = formula.substring(0, formula.length() - 1);
            }
            if ((matcher = (pattern = Pattern.compile("^((\\w+):|=)(.*)")).matcher(formula)).matches()) {
                formulaNamespace = matcher.group(2);
                if (formulaNamespace == null) {
                    formulaNamespace = "report";
                }
                formulaExpression = matcher.group(3);
            } else {
                formulaNamespace = null;
                formulaExpression = null;
            }
        }
        return new String[]{formulaNamespace, formulaExpression};
    }
}

