/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.util.Date;
import java.util.GregorianCalendar;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.DateTimeType;
import org.pentaho.reporting.libraries.formula.util.DateUtil;

public class PrevWeekdayFunction
implements Function {
    private static final long serialVersionUID = -456924288664083206L;

    @Override
    public String getCanonicalName() {
        return "PREVWEEKDAY";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() > 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        int type = 1;
        if (parameters.getParameterCount() == 1) {
            Number n = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
            if (n == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            type = n.intValue();
            if (type < 1 || type > 2) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        Date prevweekday = PrevWeekdayFunction.prevweekday(type, localizationContext);
        Date date = DateUtil.normalizeDate(prevweekday, (Type)DateTimeType.DATE_TYPE);
        return new TypeValuePair(DateTimeType.DATE_TYPE, date);
    }

    private static Date prevweekday(int type, LocalizationContext context) {
        GregorianCalendar gc = new GregorianCalendar(context.getTimeZone(), context.getLocale());
        gc.set(14, 0);
        int dayOfWeek = gc.get(7);
        if (type == 1) {
            if (dayOfWeek == 1) {
                gc.add(5, -2);
            } else if (dayOfWeek == 2) {
                gc.add(5, -3);
            } else {
                gc.add(5, -1);
            }
        } else if (dayOfWeek == 7) {
            gc.add(5, -2);
        } else if (dayOfWeek == 1) {
            gc.add(5, -3);
        } else {
            gc.add(5, -1);
        }
        return gc.getTime();
    }
}

