/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.framework;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PluginUtils {
    private static final Log logger = LogFactory.getLog(PluginUtils.class);

    public static <T> T getPluginBean(String prefix, Class<T> interfaceClass) throws PluginBeanException {
        if (interfaceClass == null) {
            throw new IllegalArgumentException();
        }
        String key = prefix + interfaceClass.getSimpleName();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (pluginManager.isBeanRegistered(key)) {
            Object beanObject = pluginManager.getBean(key);
            try {
                return (T)beanObject;
            }
            catch (ClassCastException ex) {
                throw new PluginBeanException(MessageFormat.format("The class for bean {0} must implement {1}", key, interfaceClass.getName()));
            }
        }
        logger.error((Object)MessageFormat.format("Bean {0} is not registered.", key));
        return null;
    }
}

