/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.services;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.cache.TableCacheKey;
import pt.webdetails.cda.cache.monitor.CacheElementInfo;
import pt.webdetails.cda.cache.monitor.ExtraCacheInfo;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.services.BaseService;
import pt.webdetails.cda.utils.framework.JsonCallHandler;

public class CacheMonitor
extends BaseService {
    public String listCachedQueries(String cdaSettingsId, String dataAccessId) {
        return null;
    }

    public JSONObject listQueriesInCache(String cdaSettingsId, String dataAccessId) throws JSONException, IOException {
        JSONArray results = new JSONArray();
        IQueryCache cdaCache = AbstractDataAccess.getCdaCache();
        for (TableCacheKey key : cdaCache.getKeys()) {
            CacheElementInfo cacheInfo;
            ExtraCacheInfo info = cdaCache.getCacheEntryInfo(key);
            if (info == null || !StringUtils.equals((String)cdaSettingsId, (String)info.getCdaSettingsId()) || dataAccessId != null && !StringUtils.equals((String)dataAccessId, (String)info.getDataAccessId()) || (cacheInfo = cdaCache.getElementInfo(key)) == null) continue;
            results.put((Object)cacheInfo.toJson());
        }
        JSONObject result = new JSONObject();
        result.put("cdaSettingsId", (Object)cdaSettingsId);
        result.put("dataAccessId", (Object)dataAccessId);
        result.put("items", (Object)results);
        JSONObject response = new JSONObject();
        response.put("status", (Object)JsonCallHandler.ResponseStatus.OK);
        response.put("result", (Object)result);
        return response;
    }

    public JSONObject getCacheQueryTable(String encodedCacheKey) throws JSONException {
        try {
            TableCacheKey lookupCacheKey;
            if (encodedCacheKey == null) {
                throw new IllegalArgumentException("No cache key received.");
            }
            JSONObject result = new JSONObject();
            IQueryCache cdaCache = AbstractDataAccess.getCdaCache();
            ExtraCacheInfo info = cdaCache.getCacheEntryInfo(lookupCacheKey = TableCacheKey.getTableCacheKeyFromString((String)encodedCacheKey));
            if (info == null) {
                return JsonCallHandler.getErrorJson("Cache element no longer in cache.");
            }
            result.put("result", (Object)info.getTableSnapshot());
            result.put("status", (Object)JsonCallHandler.ResponseStatus.OK);
            return result;
        }
        catch (Exception e) {
            return JsonCallHandler.getErrorJson(e.getLocalizedMessage());
        }
    }

    public JSONObject getCachedQueriesOverview(String cdaSettingsIdFilter) throws JSONException {
        HashMap<String, HashMap<String, Integer>> cdaMap = new HashMap<String, HashMap<String, Integer>>();
        IQueryCache cdaCache = AbstractDataAccess.getCdaCache();
        JSONArray results = new JSONArray();
        for (TableCacheKey key : cdaCache.getKeys()) {
            ExtraCacheInfo info = cdaCache.getCacheEntryInfo(key);
            if (info == null) continue;
            String cdaSettingsId = info.getCdaSettingsId();
            String dataAccessId = info.getDataAccessId();
            if (cdaSettingsIdFilter != null && !cdaSettingsIdFilter.equals(cdaSettingsId)) continue;
            HashMap<String, Integer> dataAccessIdMap = cdaMap.get(cdaSettingsId);
            if (dataAccessIdMap == null) {
                dataAccessIdMap = new HashMap();
                dataAccessIdMap.put(dataAccessId, 1);
                cdaMap.put(cdaSettingsId, dataAccessIdMap);
                continue;
            }
            Integer count = dataAccessIdMap.get(dataAccessId);
            if (count == null) {
                dataAccessIdMap.put(dataAccessId, 1);
                continue;
            }
            count = count + 1;
            dataAccessIdMap.put(dataAccessId, count);
        }
        for (String cdaSettingsId : cdaMap.keySet()) {
            CacheMonitor.getOverviewForCdaSettingsId(cdaMap, results, cdaSettingsId);
        }
        JSONObject result = new JSONObject();
        result.put("status", (Object)JsonCallHandler.ResponseStatus.OK);
        result.put("result", (Object)results);
        return result;
    }

    private static void getOverviewForCdaSettingsId(HashMap<String, HashMap<String, Integer>> cdaMap, JSONArray results, String cdaSettingsId) throws JSONException {
        for (String dataAccessId : cdaMap.get(cdaSettingsId).keySet()) {
            Integer count = cdaMap.get(cdaSettingsId).get(dataAccessId);
            JSONObject queryInfo = new JSONObject();
            queryInfo.put("cdaSettingsId", (Object)cdaSettingsId);
            queryInfo.put("dataAccessId", (Object)dataAccessId);
            queryInfo.put("count", count.intValue());
            results.put((Object)queryInfo);
        }
    }

    public JSONObject removeQueryFromCache(String serializedCacheKey) throws UnsupportedEncodingException, IOException, ClassNotFoundException, JSONException {
        TableCacheKey key = TableCacheKey.getTableCacheKeyFromString((String)serializedCacheKey);
        IQueryCache cdaCache = AbstractDataAccess.getCdaCache();
        boolean success = cdaCache.remove(key);
        JSONObject result = new JSONObject();
        if (success) {
            result.put("status", (Object)JsonCallHandler.ResponseStatus.OK);
            result.put("result", true);
            return result;
        }
        return this.getErrorJson("Cache element no longer in cache.");
    }

    public JSONObject removeAll(String cdaSettingsId, String dataAccessId) throws JSONException {
        IQueryCache cdaCache = AbstractDataAccess.getCdaCache();
        int result = cdaCache.removeAll(cdaSettingsId, dataAccessId);
        return this.getOkJson(result);
    }

    public JSONObject shutdown() throws JSONException {
        AbstractDataAccess.shutdownCache();
        return this.getOkJson("Cache shutdown.");
    }

    protected String getJsonString(JSONObject json) throws JSONException {
        return json.toString(2);
    }

    protected JSONObject getOkJson(Object obj) throws JSONException {
        return JsonCallHandler.getOKJson(obj);
    }

    protected JSONObject getErrorJson(String msg) throws JSONException {
        return JsonCallHandler.getErrorJson(msg);
    }

    private static class ErrorMsgs {
        public static final String CACHE_ITEM_NOT_FOUND = "Cache element no longer in cache.";

        private ErrorMsgs() {
        }
    }

    private static class ResultFields
    extends JsonCallHandler.JsonResultFields {
        public static final String CDA_SETTINGS_ID = "cdaSettingsId";
        public static final String DATA_ACCESS_ID = "dataAccessId";
        public static final String COUNT = "count";
        public static final String ITEMS = "items";

        private ResultFields() {
        }
    }
}

