/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.platform.plugin.PentahoReportEnvironment;
import org.pentaho.reporting.platform.plugin.connection.PentahoJndiDatasourceConnectionProvider;
import org.pentaho.reporting.platform.plugin.connection.PentahoMondrianDataSourceProvider;
import org.pentaho.reporting.platform.plugin.connection.PentahoPmdConnectionProvider;
import pt.webdetails.cda.connections.kettle.TransFromFileConnectionInfo;
import pt.webdetails.cda.connections.mondrian.MondrianConnection;
import pt.webdetails.cda.connections.mondrian.MondrianJndiConnectionInfo;
import pt.webdetails.cda.connections.sql.SqlJndiConnectionInfo;
import pt.webdetails.cda.dataaccess.CdaPentahoKettleTransFromFileProducer;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.utils.PathRelativizer;

public class PentahoDataAccessUtils
implements IDataAccessUtils {
    private static final Log logger = LogFactory.getLog(PentahoDataAccessUtils.class);

    public ReportEnvironmentDataRow createEnvironmentDataRow(Configuration configuration) {
        return new ReportEnvironmentDataRow((ReportEnvironment)new PentahoReportEnvironment(configuration));
    }

    public void setConnectionProvider(PmdDataFactory returnDataFactory) {
        returnDataFactory.setConnectionProvider((IPmdConnectionProvider)new PentahoPmdConnectionProvider());
    }

    public void setMdxDataFactoryBaseConnectionProperties(MondrianConnection connection, AbstractNamedMDXDataFactory mdxDataFactory) {
        IMondrianCatalogService catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", null);
        List catalogs = catalogService.listCatalogs(PentahoSessionHolder.getSession(), false);
        MondrianCatalog catalog = null;
        for (MondrianCatalog cat : catalogs) {
            String definition = cat.getDefinition();
            String definitionFileName = IOUtils.getInstance().getFileName(definition);
            if (!definitionFileName.equals(IOUtils.getInstance().getFileName(connection.getConnectionInfo().getCatalog()))) continue;
            catalog = cat;
            break;
        }
        if (catalog != null) {
            Properties props = new Properties();
            try {
                props.load(new StringReader(catalog.getDataSourceInfo().replace(';', '\n')));
                try {
                    Method m = AbstractNamedMDXDataFactory.class.getMethod("setBaseConnectionProperties", Properties.class);
                    m.invoke((Object)mdxDataFactory, props);
                }
                catch (Exception ex) {}
            }
            catch (IOException ex) {
                logger.warn((Object)("Failed to transform DataSourceInfo string '" + catalog.getDataSourceInfo() + "' into properties"));
            }
        }
    }

    public KettleTransformationProducer createKettleTransformationProducer(TransFromFileConnectionInfo connectionInfo, String query, CdaSettings cdaSettings) {
        String ktrPath = connectionInfo.getTransformationFile();
        String relPath = ktrPath.charAt(0) == '/' ? PathRelativizer.relativizePath((String)cdaSettings.getId(), (String)ktrPath) : ktrPath;
        return new CdaPentahoKettleTransFromFileProducer("", relPath, query, null, null, connectionInfo.getDefinedArgumentNames(), connectionInfo.getDefinedVariableNames());
    }

    public ConnectionProvider getJndiConnectionProvider(SqlJndiConnectionInfo connectionInfo) {
        PentahoJndiDatasourceConnectionProvider provider = new PentahoJndiDatasourceConnectionProvider();
        provider.setJndiName(connectionInfo.getJndi());
        provider.setUsername(connectionInfo.getUser());
        provider.setPassword(connectionInfo.getPass());
        return provider;
    }

    public DataSourceProvider getMondrianJndiDatasourceProvider(MondrianJndiConnectionInfo connectionInfo) {
        return new PentahoMondrianDataSourceProvider(connectionInfo.getJndi());
    }
}

