/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;

public class CdaQueryComponent {
    private static final Log log = LogFactory.getLog(CdaQueryComponent.class);
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_START_PAGE = 0;
    IPentahoResultSet resultSet = null;
    String file = null;
    Map<String, Object> inputs = new HashMap<String, Object>();

    public void setFile(String file) {
        this.file = file;
    }

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public boolean validate() throws Exception {
        if (this.file == null) {
            log.error((Object)"File not set");
            return false;
        }
        return true;
    }

    private int inputsGetInteger(String name, int defaultVal) {
        Object obj = this.inputs.get(name);
        if (obj == null) {
            obj = this.inputs.get(name.toUpperCase());
        }
        if (obj == null) {
            return defaultVal;
        }
        return new Integer(obj.toString());
    }

    private long inputsGetLong(String name, long defaultVal) {
        Object obj = this.inputs.get(name);
        if (obj == null) {
            obj = this.inputs.get(name.toUpperCase());
        }
        if (obj == null) {
            return defaultVal;
        }
        return new Long(obj.toString());
    }

    private String inputsGetString(String name, String defaultVal) {
        Object obj = this.inputs.get(name);
        if (obj == null) {
            obj = this.inputs.get(name.toUpperCase());
        }
        if (obj == null) {
            return defaultVal;
        }
        return obj.toString();
    }

    public boolean execute() throws Exception {
        QueryOptions queryOptions = new QueryOptions();
        CdaSettings cdaSettings = CdaEngine.getInstance().getSettingsManager().parseSettingsFile(this.file);
        String CDA_PARAMS = "cdaParameterString";
        String CDA_PARAM_SEPARATOR = ";";
        long pageSize = this.inputsGetLong("pageSize", 0L);
        long pageStart = this.inputsGetLong("pageStart", 0L);
        boolean paginate = "true".equals(this.inputsGetString("paginateQuery", "false"));
        if (pageSize > 0L || pageStart > 0L || paginate) {
            if (pageSize > Integer.MAX_VALUE || pageStart > Integer.MAX_VALUE) {
                throw new ArithmeticException("Paging values too large");
            }
            queryOptions.setPaginate(true);
            queryOptions.setPageSize(pageSize > 0L ? (int)pageSize : (paginate ? 20 : 0));
            queryOptions.setPageStart(pageStart > 0L ? (int)pageStart : (paginate ? 0 : 0));
        }
        queryOptions.setOutputType(this.inputsGetString("outputType", "resultset"));
        queryOptions.setDataAccessId(this.inputsGetString("dataAccessId", "<blank>"));
        queryOptions.setOutputIndexId(this.inputsGetInteger("outputIndexId", 1));
        String cdaParamString = this.inputsGetString("cdaParameterString", null);
        if (cdaParamString != null && cdaParamString.trim().length() > 0) {
            ArrayList<String> cdaParams = new ArrayList<String>();
            CSVTokenizer tokenizer = new CSVTokenizer(cdaParamString, ";");
            while (tokenizer.hasMoreTokens()) {
                cdaParams.add(tokenizer.nextToken());
            }
            for (String nameValue : cdaParams) {
                int i = 0;
                CSVTokenizer nameValSeparator = new CSVTokenizer(nameValue, "=");
                String name = null;
                String value = null;
                while (nameValSeparator.hasMoreTokens()) {
                    if (i++ == 0) {
                        name = nameValSeparator.nextToken();
                        continue;
                    }
                    value = nameValSeparator.nextToken();
                    break;
                }
                if (name == null) continue;
                queryOptions.addParameter(name, (Object)value);
            }
        }
        for (String param : this.inputs.keySet()) {
            if (param.startsWith("param")) {
                queryOptions.addParameter(param.substring(5), (Object)this.inputsGetString(param, ""));
                continue;
            }
            if (!param.startsWith("setting")) continue;
            queryOptions.addSetting(param.substring(7), this.inputsGetString(param, ""));
        }
        if (queryOptions.getOutputType().equals("resultset")) {
            TableModel tableModel = cdaSettings.getDataAccess(queryOptions.getDataAccessId()).doQuery(queryOptions);
            this.resultSet = this.convertTableToResultSet(tableModel);
        }
        return true;
    }

    private IPentahoResultSet convertTableToResultSet(TableModel tableModel) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            columnNames.add(tableModel.getColumnName(i));
        }
        MemoryMetaData metadata = new MemoryMetaData(columnNames);
        MemoryResultSet resultSet = new MemoryResultSet();
        resultSet.setMetaData((IPentahoMetaData)metadata);
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object[] row = new Object[tableModel.getColumnCount()];
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                row[j] = tableModel.getValueAt(i, j);
            }
            resultSet.addRow(row);
        }
        return resultSet;
    }

    public IPentahoResultSet getResultSet() {
        return this.resultSet;
    }
}

