/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.SolutionFileMetaAdapter;
import org.pentaho.platform.engine.core.solution.FileInfo;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class CdaFileMetaProvider
extends SolutionFileMetaAdapter {
    private static Log logger = LogFactory.getLog(CdaFileMetaProvider.class);

    public IFileInfo getFileInfo(ISolutionFile solutionFile, InputStream in) {
        try {
            SAXReader saxReader = new SAXReader();
            Document doc = saxReader.read(in);
            if (doc == null) {
                return null;
            }
            String result = "data";
            String author = XmlDom4JHelper.getNodeText((String)"/cda/author", (Node)doc, (String)"");
            String description = XmlDom4JHelper.getNodeText((String)"/cda/description", (Node)doc, (String)"");
            String icon = XmlDom4JHelper.getNodeText((String)"/cda/icon", (Node)doc, (String)"");
            String title = XmlDom4JHelper.getNodeText((String)"/cda/title", (Node)doc, (String)"");
            FileInfo info = new FileInfo();
            info.setAuthor(author);
            info.setDescription(description);
            info.setDisplayType(result);
            info.setIcon(icon);
            info.setTitle(title);
            return info;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error((Object)((Object)((Object)this)).getClass().toString(), (Throwable)e);
            }
            return null;
        }
    }
}

