/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.Progressable;

public class Hadoop23Shims
extends HadoopShimsSecure {
    @Override
    public String getTaskAttemptLogUrl(JobConf conf, String taskTrackerHttpAddress, String taskAttemptId) throws MalformedURLException {
        if (this.isMR2((Configuration)conf)) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
            return null;
        }
        String taskLogURL = null;
        try {
            Class<?> taskLogClass = Class.forName("TaskLogServlet");
            Method taskLogMethod = taskLogClass.getDeclaredMethod("getTaskLogUrl", String.class, String.class, String.class);
            URL taskTrackerHttpURL = new URL(taskTrackerHttpAddress);
            taskLogURL = (String)taskLogMethod.invoke(null, taskTrackerHttpURL.getHost(), Integer.toString(taskTrackerHttpURL.getPort()), taskAttemptId);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Could not execute getTaskLogUrl " + e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new MalformedURLException("Could not execute getTaskLogUrl " + e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new MalformedURLException("Could not execute getTaskLogUrl " + e.getCause());
        }
        catch (SecurityException e) {
            throw new MalformedURLException("Could not execute getTaskLogUrl " + e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new MalformedURLException("Method getTaskLogUrl not found " + e.getCause());
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)"Can't fetch tasklog: TaskLogServlet is not supported in MR2 mode.");
        }
        return taskLogURL;
    }

    @Override
    public HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus clusterStatus) throws Exception {
        switch (clusterStatus.getJobTrackerStatus()) {
            case INITIALIZING: {
                return HadoopShims.JobTrackerState.INITIALIZING;
            }
            case RUNNING: {
                return HadoopShims.JobTrackerState.RUNNING;
            }
        }
        String errorMsg = "Unrecognized JobTracker state: " + clusterStatus.getJobTrackerStatus();
        throw new Exception(errorMsg);
    }

    @Override
    public TaskAttemptContext newTaskAttemptContext(Configuration conf, final Progressable progressable) {
        return new TaskAttemptContextImpl(conf, new TaskAttemptID()){

            public void progress() {
                progressable.progress();
            }
        };
    }

    @Override
    public JobContext newJobContext(Job job) {
        return new JobContextImpl(job.getConfiguration(), job.getJobID());
    }

    @Override
    public boolean isLocalMode(Configuration conf) {
        if (this.isMR2(conf)) {
            return "local".equals(conf.get("mapreduce.framework.name"));
        }
        return "local".equals(conf.get("mapred.job.tracker"));
    }

    @Override
    public String getJobLauncherRpcAddress(Configuration conf) {
        if (this.isMR2(conf)) {
            return conf.get("yarn.resourcemanager.address");
        }
        return conf.get("mapred.job.tracker");
    }

    @Override
    public void setJobLauncherRpcAddress(Configuration conf, String val) {
        if (val.equals("local")) {
            if (this.isMR2(conf)) {
                conf.set("mapreduce.framework.name", val);
                conf.set("mapreduce.jobtracker.address", val);
            } else {
                conf.set("mapred.job.tracker", val);
            }
        } else if (this.isMR2(conf)) {
            conf.set("yarn.resourcemanager.address", val);
        } else {
            conf.set("mapred.job.tracker", val);
        }
    }

    @Override
    public String getJobLauncherHttpAddress(Configuration conf) {
        if (this.isMR2(conf)) {
            return conf.get("yarn.resourcemanager.webapp.address");
        }
        return conf.get("mapred.job.tracker.http.address");
    }

    private boolean isMR2(Configuration conf) {
        return "yarn".equals(conf.get("mapreduce.framework.name"));
    }
}

