/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.operation.AddResourceOperation;
import org.apache.hive.service.cli.operation.AsyncExecStmtOperation;
import org.apache.hive.service.cli.operation.DeleteResourceOperation;
import org.apache.hive.service.cli.operation.DfsOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.operation.SetOperation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class ExecuteStatementOperation
extends Operation {
    protected String statement = null;
    protected Map<String, String> confOverlay = new HashMap<String, String>();

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, OperationType.EXECUTE_STATEMENT);
        this.statement = statement;
        this.confOverlay = confOverlay;
    }

    public String getStatement() {
        return this.statement;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        void var5_13;
        String[] tokens = statement.trim().split("\\s+");
        String command = tokens[0].toLowerCase();
        HiveConf hiveConf = parentSession.getHiveConf();
        boolean allowExternalExec = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHZ_EXTERNAL_EXEC);
        if ("set".equals(command)) {
            SetOperation setOperation = new SetOperation(parentSession, statement, confOverlay);
            return var5_13;
        } else if ("dfs".equals(command)) {
            if (!allowExternalExec) throw new HiveSQLException("Insufficient privileges to execute dfs", "42000");
            DfsOperation dfsOperation = new DfsOperation(parentSession, statement, confOverlay);
            return var5_13;
        } else if ("add".equals(command)) {
            if (!allowExternalExec) throw new HiveSQLException("Insufficient privileges to execute add", "42000");
            AddResourceOperation addResourceOperation = new AddResourceOperation(parentSession, statement, confOverlay);
            return var5_13;
        } else if ("delete".equals(command)) {
            if (!allowExternalExec) throw new HiveSQLException("Insufficient privileges to execute delete", "42000");
            DeleteResourceOperation deleteResourceOperation = new DeleteResourceOperation(parentSession, statement, confOverlay);
            return var5_13;
        } else {
            boolean isAsyncOP;
            SQLOperation sQLOperation = new SQLOperation(parentSession, statement, confOverlay);
            boolean bl = isAsyncOP = !parentSession.getHiveConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_BLOCKING_QUERY);
            if (confOverlay != null && confOverlay.containsKey(HiveConf.ConfVars.HIVE_SERVER2_BLOCKING_QUERY.toString())) {
                isAsyncOP = confOverlay.get(HiveConf.ConfVars.HIVE_SERVER2_BLOCKING_QUERY.toString()).equalsIgnoreCase("false");
            }
            if (!isAsyncOP) return var5_13;
            AsyncExecStmtOperation asyncExecStmtOperation = AsyncExecStmtOperation.wrapExecStmtOperation(sQLOperation);
        }
        return var5_13;
    }
}

