/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.TOperationState;

public enum OperationState {
    INITIALIZED(TOperationState.INITIALIZED_STATE, false),
    RUNNING(TOperationState.RUNNING_STATE, false),
    FINISHED(TOperationState.FINISHED_STATE, true),
    CANCELED(TOperationState.CANCELED_STATE, true),
    CLOSED(TOperationState.CLOSED_STATE, true),
    ERROR(TOperationState.ERROR_STATE, true),
    UNKNOWN(TOperationState.UKNOWN_STATE, false);

    private final TOperationState tOperationState;
    private final boolean terminal;

    private OperationState(TOperationState tOperationState, boolean terminal) {
        this.tOperationState = tOperationState;
        this.terminal = terminal;
    }

    public static OperationState getOperationState(TOperationState tOperationState) {
        return OperationState.values()[tOperationState.getValue()];
    }

    public static void validateTransition(OperationState oldState, OperationState newState) throws HiveSQLException {
        switch (oldState) {
            case INITIALIZED: {
                switch (newState) {
                    case RUNNING: 
                    case CLOSED: {
                        return;
                    }
                }
                break;
            }
            case RUNNING: {
                switch (newState) {
                    case CLOSED: 
                    case FINISHED: 
                    case CANCELED: 
                    case ERROR: {
                        return;
                    }
                }
                break;
            }
            case FINISHED: 
            case CANCELED: 
            case ERROR: {
                if (!CLOSED.equals((Object)newState)) break;
                return;
            }
        }
        throw new HiveSQLException("Illegal Operation state transition from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
    }

    public void validateTransition(OperationState newState) throws HiveSQLException {
        OperationState.validateTransition(this, newState);
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public TOperationState toTOperationState() {
        return this.tOperationState;
    }
}

