/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslServerTransport;

public class TUGIContainingProcessor
implements TProcessor {
    private final TProcessor wrapped;
    private final HadoopShims shim;
    private final boolean isFsCacheDisabled;

    public TUGIContainingProcessor(TProcessor wrapped, Configuration conf) {
        this.wrapped = wrapped;
        this.isFsCacheDisabled = conf.getBoolean(String.format("fs.%s.impl.disable.cache", FileSystem.getDefaultUri((Configuration)conf).getScheme()), false);
        this.shim = ShimLoader.getHadoopShims();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(final TProtocol in, final TProtocol out) throws TException {
        boolean bl;
        block8: {
            UserGroupInformation clientUgi = null;
            try {
                clientUgi = this.shim.createRemoteUser(((TSaslServerTransport)in.getTransport()).getSaslServer().getAuthorizationID(), new ArrayList());
                bl = (Boolean)this.shim.doAs(clientUgi, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        try {
                            return TUGIContainingProcessor.this.wrapped.process(in, out);
                        }
                        catch (TException te) {
                            throw new RuntimeException(te);
                        }
                    }
                });
                if (clientUgi == null || this.isFsCacheDisabled) break block8;
            }
            catch (RuntimeException rte) {
                try {
                    if (rte.getCause() instanceof TException) {
                        throw (TException)rte.getCause();
                    }
                    throw rte;
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                catch (Throwable throwable) {
                    if (clientUgi != null && !this.isFsCacheDisabled) {
                        this.shim.closeAllForUGI(clientUgi);
                    }
                    throw throwable;
                }
            }
            this.shim.closeAllForUGI(clientUgi);
        }
        return bl;
    }
}

