/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.util;

import java.lang.reflect.Method;
import org.pentaho.ui.database.event.ILaunch;
import org.pentaho.ui.database.event.IMessages;

public class Launch
implements ILaunch {
    @Override
    public ILaunch.Status openUrl(String url, IMessages messages) {
        ILaunch.Status r = ILaunch.Status.Success;
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception(messages.getString("Launch.ERROR_0001_BROWSER_NOT_FOUND"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            r = ILaunch.Status.Failed;
        }
        return r;
    }
}

