/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.database.service.IDatabaseConnectionService;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.database.event.FragmentHandler;
import org.pentaho.ui.util.Launch;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;

public class DatabaseConnectionDialog {
    public static final String DIALOG_DEFINITION_FILE = "org/pentaho/ui/database/resources/databasedialog.xul";
    private Map<String, String> extendedClasses = new HashMap<String, String>();
    private IDatabaseConnectionService connectionService;
    private DatabaseTypeHelper databaseTypeHelper;

    public DatabaseConnectionDialog(IDatabaseConnectionService connectionService, DatabaseTypeHelper databaseTypeHelper) {
        this.connectionService = connectionService;
        this.databaseTypeHelper = databaseTypeHelper;
    }

    public void registerClass(String key, String className) {
        this.extendedClasses.put(key, className);
    }

    public XulDomContainer getSwtInstance(Shell shell) throws XulException {
        Messages messages = new Messages();
        XulDomContainer container = null;
        SwtXulLoader loader = new SwtXulLoader();
        Set<String> keyIterable = this.extendedClasses.keySet();
        for (Object t : keyIterable) {
            loader.register((String)t, this.extendedClasses.get(t));
        }
        loader.setOuterContext((Object)shell);
        container = loader.loadXul(DIALOG_DEFINITION_FILE, (Object)messages.getBundle());
        DataHandler dataHandler = new DataHandler();
        FragmentHandler fragmentHandler = new FragmentHandler();
        dataHandler.setDatabaseTypeHelper(this.databaseTypeHelper);
        dataHandler.setMessages(messages);
        dataHandler.setLaunch(new Launch());
        dataHandler.setFragmentHandler(fragmentHandler);
        fragmentHandler.setDatabaseTypeHelper(this.databaseTypeHelper);
        container.addEventHandler((XulEventHandler)fragmentHandler);
        container.addEventHandler((XulEventHandler)dataHandler);
        SwtXulRunner runner = new SwtXulRunner();
        runner.addContainer(container);
        runner.initialize();
        return container;
    }
}

