/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.MySQLDumpImportJob;
import com.cloudera.sqoop.mapreduce.MySQLExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.manager.MySQLManager;

public class DirectMySQLManager
extends com.cloudera.sqoop.manager.MySQLManager {
    public static final Log LOG = LogFactory.getLog((String)DirectMySQLManager.class.getName());

    public DirectMySQLManager(SqoopOptions options) {
        super(options);
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        if (context.getOptions().getColumns() != null) {
            LOG.warn((Object)"Direct-mode import from MySQL does not support column");
            LOG.warn((Object)"selection. Falling back to JDBC-based import.");
            MySQLManager.markWarningPrinted();
            super.importTable(context);
            return;
        }
        String tableName = context.getTableName();
        String jarFile = context.getJarFile();
        SqoopOptions options = context.getOptions();
        MySQLDumpImportJob importer = null;
        try {
            importer = new MySQLDumpImportJob(options, context);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Could not load required classes", cnfe);
        }
        String splitCol = this.getSplitColumn(options, tableName);
        if (null == splitCol && options.getNumMappers() > 1) {
            throw new ImportException("No primary key could be found for table " + tableName + ". Please specify one with --split-by or perform " + "a sequential import with '-m 1'.");
        }
        LOG.info((Object)"Beginning mysqldump fast path import");
        if (options.getFileLayout() != SqoopOptions.FileLayout.TextFile) {
            LOG.warn((Object)("File import layout " + (Object)((Object)options.getFileLayout()) + " is not supported by"));
            LOG.warn((Object)"MySQL direct import; import will proceed as text files.");
        }
        importer.runImport(tableName, jarFile, splitCol, options.getConf());
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        MySQLExportJob exportJob = new MySQLExportJob(context);
        exportJob.runExport();
    }

    @Override
    public boolean supportsStagingForExport() {
        return false;
    }
}

