/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ReversedScannerCallable
extends ScannerCallable {
    protected final byte[] locateStartRow;

    public ReversedScannerCallable(HConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, byte[] locateStartRow) {
        super(connection, tableName, scan, scanMetrics);
        this.locateStartRow = locateStartRow;
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            if (this.locateStartRow == null) {
                this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
                if (this.location == null) {
                    throw new IOException("Failed to find location, tableName=" + this.tableName + ", row=" + Bytes.toStringBinary((byte[])this.row) + ", reload=" + reload);
                }
            } else {
                List<HRegionLocation> locatedRegions = this.locateRegionsInRange(this.locateStartRow, this.row, reload);
                if (locatedRegions.isEmpty()) {
                    throw new DoNotRetryIOException("Does hbase:meta exist hole? Couldn't get regions for the range from " + Bytes.toStringBinary((byte[])this.locateStartRow) + " to " + Bytes.toStringBinary((byte[])this.row));
                }
                this.location = locatedRegions.get(locatedRegions.size() - 1);
            }
            this.setStub(this.getConnection().getClient(this.getLocation().getServerName()));
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    private List<HRegionLocation> locateRegionsInRange(byte[] startKey, byte[] endKey, boolean reload) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            if (!(regionLocation = this.connection.getRegionLocation(this.tableName, currentKey, reload)).getRegionInfo().containsRow(currentKey)) {
                throw new DoNotRetryIOException("Does hbase:meta exist hole? Locating row " + Bytes.toStringBinary((byte[])currentKey) + " returns incorrect region " + regionLocation.getRegionInfo());
            }
            regionList.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
        return regionList;
    }
}

