/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKTableReadOnly {
    private ZKTableReadOnly() {
    }

    public static boolean isDisabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static boolean isEnabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        return ZKTableReadOnly.getTableState(zkw, tableName) == ZooKeeperProtos.Table.State.ENABLED;
    }

    public static boolean isDisablingOrDisabledTable(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLING, state) || ZKTableReadOnly.isTableState(ZooKeeperProtos.Table.State.DISABLED, state);
    }

    public static Set<TableName> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        HashSet<TableName> disabledTables = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
            if (state != ZooKeeperProtos.Table.State.DISABLED) continue;
            disabledTables.add(tableName);
        }
        return disabledTables;
    }

    public static Set<TableName> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        HashSet<TableName> disabledTables = new HashSet<TableName>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.tableZNode);
        for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.Table.State state = ZKTableReadOnly.getTableState(zkw, tableName);
            if (state != ZooKeeperProtos.Table.State.DISABLED && state != ZooKeeperProtos.Table.State.DISABLING) continue;
            disabledTables.add(tableName);
        }
        return disabledTables;
    }

    static boolean isTableState(ZooKeeperProtos.Table.State expectedState, ZooKeeperProtos.Table.State currentState) {
        return currentState != null && currentState.equals((Object)expectedState);
    }

    static ZooKeeperProtos.Table.State getTableState(ZooKeeperWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZKUtil.joinZNode(zkw.tableZNode, tableName.getNameAsString());
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix(data);
            ZooKeeperProtos.Table.Builder builder = ZooKeeperProtos.Table.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.Table t = ((ZooKeeperProtos.Table.Builder)builder.mergeFrom(data, magicLen, data.length - magicLen)).build();
            return t.getState();
        }
        catch (InvalidProtocolBufferException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }
}

