/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;

@InterfaceAudience.Private
public class ConnectionUtils {
    private static final Random RANDOM = new Random();

    public static long getPauseTime(long pause, int tries) {
        int ntries = tries;
        if (ntries >= HConstants.RETRY_BACKOFF.length) {
            ntries = HConstants.RETRY_BACKOFF.length - 1;
        }
        long normalPause = pause * (long)HConstants.RETRY_BACKOFF[ntries];
        long jitter = (long)((float)normalPause * RANDOM.nextFloat() * 0.01f);
        return normalPause + jitter;
    }

    public static long addJitter(long pause, float jitter) {
        float lag = (float)pause * (RANDOM.nextFloat() - 0.5f) * jitter;
        long newPause = pause + (long)lag;
        if (newPause <= 0L) {
            return 1L;
        }
        return newPause;
    }

    public static NonceGenerator injectNonceGeneratorForTesting(HConnection conn, NonceGenerator cnm) {
        return ConnectionManager.injectNonceGeneratorForTesting(conn, cnm);
    }

    public static void setServerSideHConnectionRetriesConfig(Configuration c, String sn, Log log) {
        int hcRetries = c.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        int serversideMultiplier = c.getInt("hbase.client.serverside.retries.multiplier", 10);
        int retries = hcRetries * serversideMultiplier;
        c.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, retries);
        log.debug((Object)(sn + " HConnection server-to-server retries=" + retries));
    }
}

