/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ClusterStatusListener;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionKey;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaCache;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.PerClientRandomNonceGenerator;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.ZooKeeperRegistry;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.exceptions.RegionOpeningException;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
class ConnectionManager {
    static final Log LOG = LogFactory.getLog(ConnectionManager.class);
    public static final String RETRIES_BY_SERVER_KEY = "hbase.client.retries.by.server";
    private static final String CLIENT_NONCES_ENABLED_KEY = "hbase.client.nonces.enabled";
    private static final String CACHE_META_LOCATION_ENABLED = "hbase.cache.meta.location.enabled";
    private static final boolean DEFAULT_CACHE_META_LOCATION_ENABLED = true;
    static final Map<HConnectionKey, HConnectionImplementation> CONNECTION_INSTANCES;
    public static final int MAX_CACHED_CONNECTION_INSTANCES;
    private static volatile NonceGenerator nonceGenerator;
    private static Object nonceGeneratorCreateLock;

    private ConnectionManager() {
    }

    @VisibleForTesting
    static NonceGenerator injectNonceGeneratorForTesting(HConnection conn, NonceGenerator cnm) {
        HConnectionImplementation connImpl = (HConnectionImplementation)conn;
        NonceGenerator ng = connImpl.getNonceGenerator();
        LOG.warn((Object)("Nonce generator is being replaced by test code for " + cnm.getClass().getName()));
        connImpl.nonceGenerator = cnm;
        return ng;
    }

    @Deprecated
    public static HConnection getConnection(Configuration conf) throws IOException {
        return ConnectionManager.getConnectionInternal(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClusterConnection getConnectionInternal(Configuration conf) throws IOException {
        HConnectionKey connectionKey = new HConnectionKey(conf);
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection == null) {
                connection = (HConnectionImplementation)ConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            } else if (connection.isClosed()) {
                ConnectionManager.deleteConnection(connectionKey, true);
                connection = (HConnectionImplementation)ConnectionManager.createConnection(conf, true);
                CONNECTION_INSTANCES.put(connectionKey, connection);
            }
            connection.incCount();
            return connection;
        }
    }

    public static HConnection createConnection(Configuration conf) throws IOException {
        return ConnectionManager.createConnectionInternal(conf);
    }

    static ClusterConnection createConnectionInternal(Configuration conf) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return ConnectionManager.createConnection(conf, false, null, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return ConnectionManager.createConnection(conf, false, pool, provider.getCurrent());
    }

    public static HConnection createConnection(Configuration conf, User user) throws IOException {
        return ConnectionManager.createConnection(conf, false, null, user);
    }

    public static HConnection createConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        return ConnectionManager.createConnection(conf, false, pool, user);
    }

    @Deprecated
    static HConnection createConnection(Configuration conf, boolean managed) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)conf);
        return ConnectionManager.createConnection(conf, managed, null, provider.getCurrent());
    }

    @Deprecated
    static ClusterConnection createConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        String className = conf.get("hbase.client.connection.impl", HConnectionImplementation.class.getName());
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Configuration.class, Boolean.TYPE, ExecutorService.class, User.class);
            constructor.setAccessible(true);
            return (ClusterConnection)constructor.newInstance(conf, managed, pool, user);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public static void deleteConnection(Configuration conf) {
        ConnectionManager.deleteConnection(new HConnectionKey(conf), false);
    }

    @Deprecated
    public static void deleteStaleConnection(HConnection connection) {
        ConnectionManager.deleteConnection(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void deleteAllConnections(boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HashSet<HConnectionKey> connectionKeys = new HashSet<HConnectionKey>();
            connectionKeys.addAll(CONNECTION_INSTANCES.keySet());
            for (HConnectionKey connectionKey : connectionKeys) {
                ConnectionManager.deleteConnection(connectionKey, staleConnection);
            }
            CONNECTION_INSTANCES.clear();
        }
    }

    @Deprecated
    public static void deleteAllConnections() {
        ConnectionManager.deleteAllConnections(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnection connection, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            for (Map.Entry<HConnectionKey, HConnectionImplementation> e : CONNECTION_INSTANCES.entrySet()) {
                if (e.getValue() != connection) continue;
                ConnectionManager.deleteConnection(e.getKey(), staleConnection);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static void deleteConnection(HConnectionKey connectionKey, boolean staleConnection) {
        Map<HConnectionKey, HConnectionImplementation> map = CONNECTION_INSTANCES;
        synchronized (map) {
            HConnectionImplementation connection = CONNECTION_INSTANCES.get(connectionKey);
            if (connection != null) {
                connection.decCount();
                if (connection.isZeroReference() || staleConnection) {
                    CONNECTION_INSTANCES.remove(connectionKey);
                    connection.internalClose();
                }
            } else {
                LOG.error((Object)("Connection not found in the list, can't delete it (connection key=" + connectionKey + "). May be the key was modified?"), (Throwable)new Exception());
            }
        }
    }

    static int getCachedRegionCount(Configuration conf, final TableName tableName) throws IOException {
        return ConnectionManager.execute(new HConnectable<Integer>(conf){

            @Override
            public Integer connect(HConnection connection) {
                return ((HConnectionImplementation)connection).getNumberOfCachedRegionLocations(tableName);
            }
        });
    }

    static boolean isRegionCached(Configuration conf, final TableName tableName, final byte[] row) throws IOException {
        return ConnectionManager.execute(new HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) {
                return ((HConnectionImplementation)connection).metaCache.isRegionCached(tableName, row);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static <T> T execute(HConnectable<T> connectable) throws IOException {
        if (connectable == null || connectable.conf == null) {
            return null;
        }
        Configuration conf = connectable.conf;
        HConnection connection = ConnectionManager.getConnection(conf);
        boolean connectSucceeded = false;
        try {
            T returnValue = connectable.connect(connection);
            connectSucceeded = true;
            T t = returnValue;
            return t;
        }
        finally {
            block8: {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                    if (!connectSucceeded) break block8;
                    throw new IOException("The connection to " + connection + " could not be deleted.", e);
                }
            }
        }
    }

    public static Throwable findException(Object exception) {
        if (exception == null || !(exception instanceof Throwable)) {
            return null;
        }
        Throwable cur = (Throwable)exception;
        while (cur != null) {
            if (cur instanceof RegionMovedException || cur instanceof RegionOpeningException || cur instanceof RegionTooBusyException) {
                return cur;
            }
            if (cur instanceof RemoteException) {
                RemoteException re = (RemoteException)cur;
                if ((cur = re.unwrapRemoteException(new Class[]{RegionOpeningException.class, RegionMovedException.class, RegionTooBusyException.class})) == null) {
                    cur = re.unwrapRemoteException();
                }
                if (cur != re) continue;
                return null;
            }
            cur = cur.getCause();
        }
        return null;
    }

    static {
        nonceGenerator = null;
        nonceGeneratorCreateLock = new Object();
        MAX_CACHED_CONNECTION_INSTANCES = HBaseConfiguration.create().getInt("hbase.zookeeper.property.maxClientCnxns", 300) + 1;
        CONNECTION_INSTANCES = new LinkedHashMap<HConnectionKey, HConnectionImplementation>((int)((float)MAX_CACHED_CONNECTION_INSTANCES / 0.75f) + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HConnectionKey, HConnectionImplementation> eldest) {
                return this.size() > MAX_CACHED_CONNECTION_INSTANCES;
            }
        };
    }

    static class ServerErrorTracker {
        private final ConcurrentMap<ServerName, ServerErrors> errorsByServer = new ConcurrentHashMap<ServerName, ServerErrors>();
        private final long canRetryUntil;
        private final int maxRetries;
        private final long startTrackingTime;

        public ServerErrorTracker(long timeout, int maxRetries) {
            this.maxRetries = maxRetries;
            this.canRetryUntil = EnvironmentEdgeManager.currentTimeMillis() + timeout;
            this.startTrackingTime = new Date().getTime();
        }

        boolean canRetryMore(int numRetry) {
            return numRetry < this.maxRetries || this.maxRetries > 1 && EnvironmentEdgeManager.currentTimeMillis() < this.canRetryUntil;
        }

        long calculateBackoffTime(ServerName server, long basePause) {
            ServerErrors errorStats = (ServerErrors)this.errorsByServer.get(server);
            long result = errorStats != null ? ConnectionUtils.getPauseTime(basePause, errorStats.retries.get()) : 0L;
            return result;
        }

        void reportServerError(ServerName server) {
            ServerErrors errors = (ServerErrors)this.errorsByServer.get(server);
            if (errors != null) {
                errors.addError();
            } else {
                errors = this.errorsByServer.putIfAbsent(server, new ServerErrors());
                if (errors != null) {
                    errors.addError();
                }
            }
        }

        long getStartTrackingTime() {
            return this.startTrackingTime;
        }

        private static class ServerErrors {
            public final AtomicInteger retries = new AtomicInteger(0);

            private ServerErrors() {
            }

            public void addError() {
                this.retries.incrementAndGet();
            }
        }
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Access to the conncurrent hash map is under a lock so should be fine.")
    static class HConnectionImplementation
    implements ClusterConnection,
    Closeable {
        static final Log LOG = LogFactory.getLog(HConnectionImplementation.class);
        private final long pause;
        private final int numTries;
        final int rpcTimeout;
        private NonceGenerator nonceGenerator = null;
        private final int prefetchRegionLimit;
        private final AsyncProcess asyncProcess;
        private volatile boolean closed;
        private volatile boolean aborted;
        ClusterStatusListener clusterStatusListener;
        private final Object metaRegionLock = new Object();
        private final Object userRegionLock = new Object();
        private final Object masterAndZKLock = new Object();
        private long keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
        private final DelayedClosing delayedClosing = DelayedClosing.createAndStart(this);
        private volatile ExecutorService batchPool = null;
        private volatile boolean cleanupPool = false;
        private final Configuration conf;
        private RpcClient rpcClient;
        private MetaCache metaCache = new MetaCache();
        private boolean cacheMetaLocationEnabled;
        private int refCount;
        private boolean managed;
        private User user;
        Registry registry;
        protected String clusterId = null;
        private final ConcurrentHashMap<String, Object> stubs = new ConcurrentHashMap();
        private final ConcurrentHashMap<String, String> connectionLock = new ConcurrentHashMap();
        private ZooKeeperKeepAliveConnection keepAliveZookeeper;
        private int keepAliveZookeeperUserCount;
        private boolean canCloseZKW = true;
        private static final long keepAlive = 300000L;
        final MasterServiceState masterServiceState = new MasterServiceState(this);

        HConnectionImplementation(Configuration conf, boolean managed) throws IOException {
            this(conf, managed, null, null);
        }

        HConnectionImplementation(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            this(conf);
            this.user = user;
            this.batchPool = pool;
            this.managed = managed;
            this.registry = this.setupRegistry();
            this.retrieveClusterId();
            this.rpcClient = new RpcClient(this.conf, this.clusterId);
            boolean shouldListen = conf.getBoolean("hbase.status.published", false);
            Class listenerClass = conf.getClass("hbase.status.listener.class", ClusterStatusListener.DEFAULT_STATUS_LISTENER_CLASS, ClusterStatusListener.Listener.class);
            if (shouldListen) {
                if (listenerClass == null) {
                    LOG.warn((Object)"hbase.status.published is true, but hbase.status.listener.class is not set - not listening status");
                } else {
                    this.clusterStatusListener = new ClusterStatusListener(new ClusterStatusListener.DeadServerHandler(){

                        @Override
                        public void newDead(ServerName sn) {
                            HConnectionImplementation.this.clearCaches(sn);
                            HConnectionImplementation.this.rpcClient.cancelConnections(sn.getHostname(), sn.getPort(), new SocketException(sn.getServerName() + " is dead: closing its connection."));
                        }
                    }, conf, listenerClass);
                }
            }
            this.cacheMetaLocationEnabled = conf.getBoolean(ConnectionManager.CACHE_META_LOCATION_ENABLED, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HConnectionImplementation(Configuration conf) {
            this.conf = conf;
            this.closed = false;
            this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
            this.numTries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
            this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_TIMEOUT);
            if (conf.getBoolean(ConnectionManager.CLIENT_NONCES_ENABLED_KEY, true)) {
                Object object = nonceGeneratorCreateLock;
                synchronized (object) {
                    if (nonceGenerator == null) {
                        nonceGenerator = new PerClientRandomNonceGenerator();
                    }
                    this.nonceGenerator = nonceGenerator;
                }
            } else {
                this.nonceGenerator = new NoNonceGenerator();
            }
            this.asyncProcess = this.createAsyncProcess(this.conf);
            this.prefetchRegionLimit = conf.getInt(HConstants.HBASE_CLIENT_PREFETCH_LIMIT, HConstants.DEFAULT_HBASE_CLIENT_PREFETCH_LIMIT);
        }

        @Override
        public HTableInterface getTable(String tableName) throws IOException {
            return this.getTable(TableName.valueOf((String)tableName));
        }

        @Override
        public HTableInterface getTable(byte[] tableName) throws IOException {
            return this.getTable(TableName.valueOf((byte[])tableName));
        }

        @Override
        public HTableInterface getTable(TableName tableName) throws IOException {
            return this.getTable(tableName, this.getBatchPool());
        }

        @Override
        public HTableInterface getTable(String tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf((String)tableName), pool);
        }

        @Override
        public HTableInterface getTable(byte[] tableName, ExecutorService pool) throws IOException {
            return this.getTable(TableName.valueOf((byte[])tableName), pool);
        }

        @Override
        public HTableInterface getTable(TableName tableName, ExecutorService pool) throws IOException {
            if (this.managed) {
                throw new IOException("The connection has to be unmanaged.");
            }
            return new HTable(tableName, this, pool);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExecutorService getBatchPool() {
            if (this.batchPool == null) {
                HConnectionImplementation hConnectionImplementation = this;
                synchronized (hConnectionImplementation) {
                    if (this.batchPool == null) {
                        int maxThreads = this.conf.getInt("hbase.hconnection.threads.max", 256);
                        int coreThreads = this.conf.getInt("hbase.hconnection.threads.core", 256);
                        if (maxThreads == 0) {
                            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
                        }
                        if (coreThreads == 0) {
                            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
                        }
                        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
                        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
                        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(this.toString() + "-shared-")));
                        tpe.allowCoreThreadTimeOut(true);
                        this.batchPool = tpe;
                    }
                    this.cleanupPool = true;
                }
            }
            return this.batchPool;
        }

        protected ExecutorService getCurrentBatchPool() {
            return this.batchPool;
        }

        private void shutdownBatchPool() {
            if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
                this.batchPool.shutdown();
                try {
                    if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.batchPool.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    this.batchPool.shutdownNow();
                }
            }
        }

        private Registry setupRegistry() throws IOException {
            String registryClass = this.conf.get("hbase.client.registry.impl", ZooKeeperRegistry.class.getName());
            Registry registry = null;
            try {
                registry = (Registry)Class.forName(registryClass).newInstance();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            registry.init(this);
            return registry;
        }

        @VisibleForTesting
        RpcClient setRpcClient(RpcClient rpcClient) {
            RpcClient oldRpcClient = this.rpcClient;
            this.rpcClient = rpcClient;
            return oldRpcClient;
        }

        @VisibleForTesting
        RpcClient getRpcClient() {
            return this.rpcClient;
        }

        public String toString() {
            return "hconnection-0x" + Integer.toHexString(this.hashCode());
        }

        void retrieveClusterId() {
            if (this.clusterId != null) {
                return;
            }
            this.clusterId = this.registry.getClusterId();
            if (this.clusterId == null) {
                this.clusterId = "default-cluster";
                LOG.debug((Object)("clusterid came back null, using default " + this.clusterId));
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }

        private void checkIfBaseNodeAvailable(ZooKeeperWatcher zkw) throws MasterNotRunningException {
            try {
                if (ZKUtil.checkExists(zkw, zkw.baseZNode) == -1) {
                    String errorMsg = "The node " + zkw.baseZNode + " is not in ZooKeeper. " + "It should have been written by the master. " + "Check the value configured in 'zookeeper.znode.parent'. " + "There could be a mismatch with the one configured in the master.";
                    LOG.error((Object)errorMsg);
                    throw new MasterNotRunningException(errorMsg);
                }
            }
            catch (KeeperException e) {
                String errorMsg = "Can't get connection to ZooKeeper: " + e.getMessage();
                LOG.error((Object)errorMsg);
                throw new MasterNotRunningException(errorMsg, (Exception)((Object)e));
            }
        }

        @Override
        public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
            MasterKeepAliveConnection m = this.getKeepAliveMasterService();
            m.close();
            return true;
        }

        @Override
        public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(tableName, row) : this.locateRegion(tableName, row);
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] tableName, byte[] row, boolean reload) throws IOException {
            return this.getRegionLocation(TableName.valueOf((byte[])tableName), row, reload);
        }

        @Override
        public boolean isTableEnabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.isTableEnabled(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableDisabled(TableName tableName) throws IOException {
            return this.registry.isTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.isTableDisabled(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals((Object)info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            regionCount.incrementAndGet();
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, this, visitor, tableName);
            return available.get() && regionCount.get() > 0;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName) throws IOException {
            return this.isTableAvailable(TableName.valueOf((byte[])tableName));
        }

        @Override
        public boolean isTableAvailable(final TableName tableName, final byte[][] splitKeys) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            final AtomicInteger regionCount = new AtomicInteger(0);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    HRegionInfo info = MetaScanner.getHRegionInfo(row);
                    if (info != null && !info.isSplitParent()) {
                        if (tableName.equals((Object)info.getTable())) {
                            ServerName server = HRegionInfo.getServerName(row);
                            if (server == null) {
                                available.set(false);
                                return false;
                            }
                            if (!Bytes.equals((byte[])info.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) {
                                for (byte[] splitKey : splitKeys) {
                                    if (!Bytes.equals((byte[])info.getStartKey(), (byte[])splitKey)) continue;
                                    regionCount.incrementAndGet();
                                    break;
                                }
                            } else {
                                regionCount.incrementAndGet();
                            }
                        } else if (tableName.compareTo(info.getTable()) < 0) {
                            return false;
                        }
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, this, visitor, tableName);
            return available.get() && regionCount.get() == splitKeys.length + 1;
        }

        @Override
        public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
            return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
        }

        @Override
        public HRegionLocation locateRegion(byte[] regionName) throws IOException {
            RegionLocations locations = this.locateRegion(HRegionInfo.getTable(regionName), HRegionInfo.getStartKey(regionName), false, true);
            return locations == null ? null : locations.getRegionLocation();
        }

        @Override
        public boolean isDeadServer(ServerName sn) {
            if (this.clusterStatusListener == null) {
                return false;
            }
            return this.clusterStatusListener.isDeadServer(sn);
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
            return this.locateRegions(tableName, false, true);
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName) throws IOException {
            return this.locateRegions(TableName.valueOf((byte[])tableName));
        }

        @Override
        public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
            NavigableMap<HRegionInfo, ServerName> regions = MetaScanner.allTableRegions(this.conf, this, tableName, offlined);
            ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>();
            for (HRegionInfo regionInfo : regions.keySet()) {
                RegionLocations list = this.locateRegion(tableName, regionInfo.getStartKey(), useCache, true);
                if (list == null) continue;
                for (HRegionLocation loc : list.getRegionLocations()) {
                    if (loc == null) continue;
                    locations.add(loc);
                }
            }
            return locations;
        }

        @Override
        public List<HRegionLocation> locateRegions(byte[] tableName, boolean useCache, boolean offlined) throws IOException {
            return this.locateRegions(TableName.valueOf((byte[])tableName), useCache, offlined);
        }

        @Override
        public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
            RegionLocations locations = this.locateRegion(tableName, row, true, true);
            return locations == null ? null : locations.getRegionLocation();
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(TableName.valueOf((byte[])tableName), row);
        }

        @Override
        public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
            return this.relocateRegion(tableName, row, 0);
        }

        @Override
        public HRegionLocation relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
            if (this.isTableDisabled(tableName)) {
                throw new TableNotEnabledException(tableName.getNameAsString() + " is disabled.");
            }
            RegionLocations locations = this.locateRegion(tableName, row, false, true, replicaId);
            return locations == null ? null : locations.getRegionLocation(replicaId);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.relocateRegion(TableName.valueOf((byte[])tableName), row);
        }

        @Override
        public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
            return this.locateRegion(tableName, row, useCache, retry, 0);
        }

        @Override
        public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
            if (this.closed) {
                throw new IOException(this.toString() + " closed");
            }
            if (tableName == null || tableName.getName().length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                return this.locateMeta(tableName, useCache, replicaId);
            }
            return this.locateRegionInMeta(TableName.META_TABLE_NAME, tableName, row, useCache, this.userRegionLock, retry, replicaId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionLocations locateMeta(TableName tableName, boolean useCache, int replicaId) throws IOException {
            if (!this.cacheMetaLocationEnabled) {
                return this.registry.getMetaRegionLocation();
            }
            byte[] metaCacheKey = HConstants.EMPTY_START_ROW;
            RegionLocations locations = null;
            if (useCache) {
                locations = this.getCachedLocation(tableName, metaCacheKey);
                if (locations != null) {
                    return locations;
                }
            } else {
                this.metaCache.clearCache(tableName, metaCacheKey, replicaId);
            }
            Object object = this.metaRegionLock;
            synchronized (object) {
                locations = this.getCachedLocation(tableName, metaCacheKey);
                if (locations != null) {
                    return locations;
                }
                locations = this.registry.getMetaRegionLocation();
                if (locations != null) {
                    this.cacheLocation(tableName, locations);
                }
            }
            return locations;
        }

        private void prefetchRegionCache(final TableName tableName, byte[] row) {
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        RegionLocations locations = MetaReader.getRegionLocations(result);
                        if (locations == null) {
                            return true;
                        }
                        HRegionInfo regionInfo = locations.getRegionLocation().getRegionInfo();
                        if (!regionInfo.getTable().equals((Object)tableName)) {
                            return false;
                        }
                        if (regionInfo.isOffline()) {
                            return true;
                        }
                        ServerName serverName = locations.getRegionLocation().getServerName();
                        if (serverName == null) {
                            return true;
                        }
                        HConnectionImplementation.this.cacheLocation(tableName, locations);
                        return true;
                    }
                    catch (RuntimeException e) {
                        throw new IOException(e);
                    }
                }
            };
            try {
                MetaScanner.metaScan(this.conf, this, visitor, tableName, row, this.prefetchRegionLimit, TableName.META_TABLE_NAME);
            }
            catch (IOException e) {
                if (ExceptionUtil.isInterrupt((Throwable)e)) {
                    Thread.currentThread().interrupt();
                }
                LOG.warn((Object)"Encountered problems when prefetch hbase:meta table: ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RegionLocations locateRegionInMeta(TableName parentTable, TableName tableName, byte[] row, boolean useCache, Object regionLockObject, boolean retry, int replicaId) throws IOException {
            RegionLocations locations;
            if (useCache && (locations = this.getCachedLocation(tableName, row)) != null && locations.getRegionLocation(replicaId) != null) {
                return locations;
            }
            int localNumRetries = retry ? this.numTries : 1;
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
            int tries = 0;
            while (true) {
                block29: {
                    if (tries >= localNumRetries) {
                        throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary((byte[])row) + " after " + this.numTries + " tries.");
                    }
                    HRegionLocation metaLocation = null;
                    try {
                        Result regionInfoRow;
                        RegionLocations metaLocations = this.locateRegion(parentTable, metaKey, tries == 0, false);
                        HRegionLocation hRegionLocation = metaLocation = metaLocations == null ? null : metaLocations.getDefaultRegionLocation();
                        if (metaLocation == null) break block29;
                        ClientProtos.ClientService.BlockingInterface service = this.getClient(metaLocation.getServerName());
                        if (useCache) {
                            if (TableName.META_TABLE_NAME.equals((Object)parentTable) && this.getRegionCachePrefetch(tableName)) {
                                Object object = regionLockObject;
                                synchronized (object) {
                                    locations = this.getCachedLocation(tableName, row);
                                    if (locations != null && locations.getRegionLocation(replicaId) != null) {
                                        return locations;
                                    }
                                    this.prefetchRegionCache(tableName, row);
                                }
                            }
                            if ((locations = this.getCachedLocation(tableName, row)) != null && locations.getRegionLocation(replicaId) != null) {
                                return locations;
                            }
                        } else {
                            this.metaCache.clearCache(tableName, row, replicaId);
                        }
                        if ((regionInfoRow = ProtobufUtil.getRowOrBefore(service, metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY)) == null) {
                            throw new TableNotFoundException(tableName);
                        }
                        locations = MetaReader.getRegionLocations(regionInfoRow);
                        if (locations == null || locations.getRegionLocation(replicaId) == null) {
                            throw new IOException("HRegionInfo was null in " + parentTable + ", row=" + regionInfoRow);
                        }
                        HRegionInfo regionInfo = locations.getRegionLocation(replicaId).getRegionInfo();
                        if (regionInfo == null) {
                            throw new IOException("HRegionInfo was null or empty in " + parentTable + ", row=" + regionInfoRow);
                        }
                        if (!regionInfo.getTable().equals((Object)tableName)) {
                            throw new TableNotFoundException("Table '" + tableName + "' was not found, got: " + regionInfo.getTable() + ".");
                        }
                        if (regionInfo.isSplit()) {
                            throw new RegionOfflineException("the only available region for the required row is a split parent, the daughters should be online soon: " + regionInfo.getRegionNameAsString());
                        }
                        if (regionInfo.isOffline()) {
                            throw new RegionOfflineException("the region is offline, could be caused by a disable table call: " + regionInfo.getRegionNameAsString());
                        }
                        ServerName serverName = locations.getRegionLocation(replicaId).getServerName();
                        if (serverName == null) {
                            throw new NoServerForRegionException("No server address listed in " + parentTable + " for region " + regionInfo.getRegionNameAsString() + " containing row " + Bytes.toStringBinary((byte[])row));
                        }
                        if (this.isDeadServer(serverName)) {
                            throw new RegionServerStoppedException("hbase:meta says the region " + regionInfo.getRegionNameAsString() + " is managed by the server " + serverName + ", but it is dead.");
                        }
                        this.cacheLocation(tableName, locations);
                        return locations;
                    }
                    catch (TableNotFoundException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                        if (e instanceof RemoteException) {
                            e = ((RemoteException)((Object)e)).unwrapRemoteException();
                        }
                        if (tries < this.numTries - 1) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("locateRegionInMeta parentTable=" + parentTable + ", metaLocation=" + (metaLocation == null ? "null" : "{" + metaLocation + "}") + ", attempt=" + tries + " of " + this.numTries + " failed; retrying after sleep of " + ConnectionUtils.getPauseTime(this.pause, tries) + " because: " + e.getMessage()));
                            }
                        } else {
                            throw e;
                        }
                        if (!(e instanceof RegionOfflineException) && !(e instanceof NoServerForRegionException)) {
                            this.relocateRegion(parentTable, metaKey, replicaId);
                        }
                        try {
                            Thread.sleep(ConnectionUtils.getPauseTime(this.pause, tries));
                        }
                        catch (InterruptedException e2) {
                            throw new InterruptedIOException("Giving up trying to location region in meta: thread is interrupted.");
                        }
                    }
                }
                ++tries;
            }
        }

        private void cacheLocation(TableName tableName, RegionLocations location) {
            this.metaCache.cacheLocation(tableName, location);
        }

        RegionLocations getCachedLocation(TableName tableName, byte[] row) {
            return this.metaCache.getCachedLocation(tableName, row);
        }

        public void clearRegionCache(TableName tableName, byte[] row) {
            this.metaCache.clearCache(tableName, row);
        }

        @Override
        public void clearCaches(ServerName serverName) {
            this.metaCache.clearCache(serverName);
        }

        @Override
        public void clearRegionCache() {
            this.metaCache.clearCache();
        }

        @Override
        public void clearRegionCache(TableName tableName) {
            this.metaCache.clearCache(tableName);
        }

        @Override
        public void clearRegionCache(byte[] tableName) {
            this.clearRegionCache(TableName.valueOf((byte[])tableName));
        }

        private void cacheLocation(TableName tableName, ServerName source, HRegionLocation location) {
            this.metaCache.cacheLocation(tableName, source, location);
        }

        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
            return this.getAdmin(serverName, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName, boolean master) throws IOException {
            if (this.isDeadServer(serverName)) {
                throw new RegionServerStoppedException(serverName + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(AdminProtos.AdminService.BlockingInterface.class.getName(), serverName.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            AdminProtos.AdminService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (AdminProtos.AdminService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(serverName, this.user, this.rpcTimeout);
                    stub = AdminProtos.AdminService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            if (this.isDeadServer(sn)) {
                throw new RegionServerStoppedException(sn + " is dead.");
            }
            String key = HConnectionImplementation.getStubKey(ClientProtos.ClientService.BlockingInterface.class.getName(), sn.getHostAndPort());
            this.connectionLock.putIfAbsent(key, key);
            ClientProtos.ClientService.BlockingInterface stub = null;
            String string = this.connectionLock.get(key);
            synchronized (string) {
                stub = (ClientProtos.ClientService.BlockingInterface)this.stubs.get(key);
                if (stub == null) {
                    BlockingRpcChannel channel = this.rpcClient.createBlockingRpcChannel(sn, this.user, this.rpcTimeout);
                    stub = ClientProtos.ClientService.newBlockingStub((BlockingRpcChannel)channel);
                    this.stubs.put(key, stub);
                }
            }
            return stub;
        }

        static String getStubKey(String serviceName, String rsHostnamePort) {
            return serviceName + "@" + rsHostnamePort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ZooKeeperKeepAliveConnection getKeepAliveZooKeeperWatcher() throws IOException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper == null) {
                    if (this.closed) {
                        throw new IOException(this.toString() + " closed");
                    }
                    this.keepAliveZookeeper = new ZooKeeperKeepAliveConnection(this.conf, this.toString(), this);
                }
                ++this.keepAliveZookeeperUserCount;
                this.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                return this.keepAliveZookeeper;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseZooKeeperWatcher(ZooKeeperWatcher zkw) {
            if (zkw == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --this.keepAliveZookeeperUserCount;
                if (this.keepAliveZookeeperUserCount <= 0) {
                    this.keepZooKeeperWatcherAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeZooKeeperWatcher() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (this.keepAliveZookeeper != null) {
                    LOG.info((Object)("Closing zookeeper sessionid=0x" + Long.toHexString(this.keepAliveZookeeper.getRecoverableZooKeeper().getSessionId())));
                    this.keepAliveZookeeper.internalClose();
                    this.keepAliveZookeeper = null;
                }
                this.keepAliveZookeeperUserCount = 0;
            }
        }

        @Override
        public MasterProtos.MasterService.BlockingInterface getMaster() throws MasterNotRunningException {
            return this.getKeepAliveMasterService();
        }

        private void resetMasterServiceState(MasterServiceState mss) {
            ++mss.userCount;
            mss.keepAliveUntil = Long.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MasterKeepAliveConnection getKeepAliveMasterService() throws MasterNotRunningException {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                if (!this.isKeepAliveMasterConnectedAndRunning(this.masterServiceState)) {
                    MasterServiceStubMaker stubMaker = new MasterServiceStubMaker();
                    this.masterServiceState.stub = stubMaker.makeStub();
                }
                this.resetMasterServiceState(this.masterServiceState);
            }
            final MasterProtos.MasterService.BlockingInterface stub = this.masterServiceState.stub;
            return new MasterKeepAliveConnection(){
                MasterServiceState mss;
                {
                    this.mss = HConnectionImplementation.this.masterServiceState;
                }

                public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest request) throws ServiceException {
                    return stub.addColumn(controller, request);
                }

                public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest request) throws ServiceException {
                    return stub.deleteColumn(controller, request);
                }

                public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest request) throws ServiceException {
                    return stub.modifyColumn(controller, request);
                }

                public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest request) throws ServiceException {
                    return stub.moveRegion(controller, request);
                }

                public MasterProtos.DispatchMergingRegionsResponse dispatchMergingRegions(RpcController controller, MasterProtos.DispatchMergingRegionsRequest request) throws ServiceException {
                    return stub.dispatchMergingRegions(controller, request);
                }

                public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest request) throws ServiceException {
                    return stub.assignRegion(controller, request);
                }

                public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest request) throws ServiceException {
                    return stub.unassignRegion(controller, request);
                }

                public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
                    return stub.offlineRegion(controller, request);
                }

                public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
                    return stub.deleteTable(controller, request);
                }

                public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
                    return stub.enableTable(controller, request);
                }

                public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
                    return stub.disableTable(controller, request);
                }

                public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest request) throws ServiceException {
                    return stub.modifyTable(controller, request);
                }

                public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest request) throws ServiceException {
                    return stub.createTable(controller, request);
                }

                public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
                    return stub.shutdown(controller, request);
                }

                public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
                    return stub.stopMaster(controller, request);
                }

                public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
                    return stub.balance(controller, request);
                }

                public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController controller, MasterProtos.SetBalancerRunningRequest request) throws ServiceException {
                    return stub.setBalancerRunning(controller, request);
                }

                public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController controller, MasterProtos.RunCatalogScanRequest request) throws ServiceException {
                    return stub.runCatalogScan(controller, request);
                }

                public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController controller, MasterProtos.EnableCatalogJanitorRequest request) throws ServiceException {
                    return stub.enableCatalogJanitor(controller, request);
                }

                public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController controller, MasterProtos.IsCatalogJanitorEnabledRequest request) throws ServiceException {
                    return stub.isCatalogJanitorEnabled(controller, request);
                }

                public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
                    return stub.execMasterService(controller, request);
                }

                public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
                    return stub.snapshot(controller, request);
                }

                public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
                    return stub.getCompletedSnapshots(controller, request);
                }

                public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
                    return stub.deleteSnapshot(controller, request);
                }

                public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
                    return stub.isSnapshotDone(controller, request);
                }

                public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
                    return stub.restoreSnapshot(controller, request);
                }

                public MasterProtos.IsRestoreSnapshotDoneResponse isRestoreSnapshotDone(RpcController controller, MasterProtos.IsRestoreSnapshotDoneRequest request) throws ServiceException {
                    return stub.isRestoreSnapshotDone(controller, request);
                }

                public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController controller, MasterProtos.IsMasterRunningRequest request) throws ServiceException {
                    return stub.isMasterRunning(controller, request);
                }

                public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
                    return stub.modifyNamespace(controller, request);
                }

                public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
                    return stub.createNamespace(controller, request);
                }

                public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
                    return stub.deleteNamespace(controller, request);
                }

                public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
                    return stub.getNamespaceDescriptor(controller, request);
                }

                public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController controller, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
                    return stub.listNamespaceDescriptors(controller, request);
                }

                public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController controller, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
                    return stub.listTableDescriptorsByNamespace(controller, request);
                }

                public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController controller, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
                    return stub.listTableNamesByNamespace(controller, request);
                }

                @Override
                public void close() {
                    HConnectionImplementation.release(this.mss);
                }

                public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest request) throws ServiceException {
                    return stub.getSchemaAlterStatus(controller, request);
                }

                public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController controller, MasterProtos.GetTableDescriptorsRequest request) throws ServiceException {
                    return stub.getTableDescriptors(controller, request);
                }

                public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest request) throws ServiceException {
                    return stub.getTableNames(controller, request);
                }

                public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest request) throws ServiceException {
                    return stub.getClusterStatus(controller, request);
                }
            };
        }

        private static void release(MasterServiceState mss) {
            if (mss != null && mss.connection != null) {
                ((HConnectionImplementation)mss.connection).releaseMaster(mss);
            }
        }

        private boolean isKeepAliveMasterConnectedAndRunning(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return false;
            }
            try {
                return mss.isMasterRunning();
            }
            catch (UndeclaredThrowableException e) {
                LOG.info((Object)"Master connection is not running anymore", e.getUndeclaredThrowable());
                return false;
            }
            catch (ServiceException se) {
                LOG.warn((Object)"Checking master connection", (Throwable)se);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseMaster(MasterServiceState mss) {
            if (mss.getStub() == null) {
                return;
            }
            Object object = this.masterAndZKLock;
            synchronized (object) {
                --mss.userCount;
                if (mss.userCount <= 0) {
                    mss.keepAliveUntil = System.currentTimeMillis() + 300000L;
                }
            }
        }

        private void closeMasterService(MasterServiceState mss) {
            if (mss.getStub() != null) {
                LOG.info((Object)("Closing master protocol: " + mss));
                mss.clearStub();
            }
            mss.userCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeMaster() {
            Object object = this.masterAndZKLock;
            synchronized (object) {
                this.closeMasterService(this.masterServiceState);
            }
        }

        void updateCachedLocation(HRegionInfo hri, ServerName source, ServerName serverName, long seqNum) {
            HRegionLocation newHrl = new HRegionLocation(hri, serverName, seqNum);
            this.cacheLocation(hri.getTable(), source, newHrl);
        }

        @Override
        public void deleteCachedRegionLocation(HRegionLocation location) {
            this.metaCache.clearCache(location);
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, ServerName source) {
            this.updateCachedLocations(tableName, null, rowkey, exception, source);
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            assert (source != null);
            this.updateCachedLocations(tableName, source.getRegionInfo().getRegionName(), rowkey, exception, source.getServerName());
        }

        @Override
        public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
            if (rowkey == null || tableName == null) {
                LOG.warn((Object)("Coding error, see method javadoc. row=" + (rowkey == null ? "null" : (Object)rowkey) + ", tableName=" + (tableName == null ? "null" : tableName)));
                return;
            }
            if (source == null) {
                return;
            }
            if (regionName == null) {
                this.metaCache.clearCache(tableName, rowkey, source);
                return;
            }
            RegionLocations oldLocations = this.getCachedLocation(tableName, rowkey);
            HRegionLocation oldLocation = null;
            if (oldLocations != null) {
                oldLocation = oldLocations.getRegionLocationByRegionName(regionName);
            }
            if (oldLocation == null || !source.equals(oldLocation.getServerName())) {
                return;
            }
            HRegionInfo regionInfo = oldLocation.getRegionInfo();
            Throwable cause = ConnectionManager.findException(exception);
            if (cause != null) {
                if (cause instanceof RegionTooBusyException || cause instanceof RegionOpeningException) {
                    return;
                }
                if (cause instanceof RegionMovedException) {
                    RegionMovedException rme = (RegionMovedException)cause;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Region " + regionInfo.getRegionNameAsString() + " moved to " + rme.getHostname() + ":" + rme.getPort() + " according to " + source.getHostAndPort()));
                    }
                    this.updateCachedLocation(regionInfo, source, rme.getServerName(), rme.getLocationSeqNum());
                    return;
                }
            }
            this.metaCache.clearCache(regionInfo);
        }

        @Override
        public void updateCachedLocations(byte[] tableName, byte[] rowkey, Object exception, HRegionLocation source) {
            this.updateCachedLocations(TableName.valueOf((byte[])tableName), rowkey, exception, source);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            if (results.length != list.size()) {
                throw new IllegalArgumentException("argument results must be the same size as argument list");
            }
            this.processBatchCallback(list, tableName, pool, results, null);
        }

        @Override
        @Deprecated
        public void processBatch(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results) throws IOException, InterruptedException {
            this.processBatch(list, TableName.valueOf((byte[])tableName), pool, results);
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, TableName tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            AsyncProcess.AsyncRequestFuture ars = this.asyncProcess.submitAll(pool, tableName, list, callback, results);
            ars.waitUntilDone();
            if (ars.hasError()) {
                throw ars.getErrors();
            }
        }

        @Override
        @Deprecated
        public <R> void processBatchCallback(List<? extends Row> list, byte[] tableName, ExecutorService pool, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
            this.processBatchCallback(list, TableName.valueOf((byte[])tableName), pool, results, callback);
        }

        protected AsyncProcess createAsyncProcess(Configuration conf) {
            return new AsyncProcess(this, conf, this.batchPool, RpcRetryingCallerFactory.instantiate(conf), false);
        }

        @Override
        public AsyncProcess getAsyncProcess() {
            return this.asyncProcess;
        }

        @VisibleForTesting
        int getNumberOfCachedRegionLocations(TableName tableName) {
            return this.metaCache.getNumberOfCachedRegionLocations(tableName);
        }

        @Override
        public void setRegionCachePrefetch(TableName tableName, boolean enable) {
            this.metaCache.setRegionCachePrefetch(tableName, enable);
        }

        @Override
        public void setRegionCachePrefetch(byte[] tableName, boolean enable) {
            this.setRegionCachePrefetch(TableName.valueOf((byte[])tableName), enable);
        }

        @Override
        public boolean getRegionCachePrefetch(TableName tableName) {
            return this.metaCache.getRegionCachePrefetch(tableName);
        }

        @Override
        public boolean getRegionCachePrefetch(byte[] tableName) {
            return this.getRegionCachePrefetch(TableName.valueOf((byte[])tableName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String msg, Throwable t) {
            if (t instanceof KeeperException.SessionExpiredException && this.keepAliveZookeeper != null) {
                Object object = this.masterAndZKLock;
                synchronized (object) {
                    if (this.keepAliveZookeeper != null) {
                        LOG.warn((Object)"This client just lost it's session with ZooKeeper, closing it. It will be recreated next time someone needs it", t);
                        this.closeZooKeeperWatcher();
                    }
                }
            } else {
                if (t != null) {
                    LOG.fatal((Object)msg, t);
                } else {
                    LOG.fatal((Object)msg);
                }
                this.aborted = true;
                this.close();
                this.closed = true;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public boolean isAborted() {
            return this.aborted;
        }

        @Override
        public int getCurrentNrHRS() throws IOException {
            return this.registry.getCurrentNrHRS();
        }

        void incCount() {
            ++this.refCount;
        }

        void decCount() {
            if (this.refCount > 0) {
                --this.refCount;
            }
        }

        boolean isZeroReference() {
            return this.refCount == 0;
        }

        void internalClose() {
            if (this.closed) {
                return;
            }
            this.delayedClosing.stop("Closing connection");
            this.closeMaster();
            this.shutdownBatchPool();
            this.closed = true;
            this.closeZooKeeperWatcher();
            this.stubs.clear();
            if (this.clusterStatusListener != null) {
                this.clusterStatusListener.close();
            }
        }

        @Override
        public void close() {
            if (this.managed) {
                if (this.aborted) {
                    ConnectionManager.deleteStaleConnection(this);
                } else {
                    ConnectionManager.deleteConnection(this, false);
                }
            } else {
                this.internalClose();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.refCount = 1;
            this.close();
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest((List<TableName>)null);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public String[] getTableNames() throws IOException {
            TableName[] tableNames = this.listTableNames();
            String[] result = new String[tableNames.length];
            for (int i = 0; i < tableNames.length; ++i) {
                result[i] = tableNames[i].getNameAsString();
            }
            return result;
        }

        @Override
        public TableName[] listTableNames() throws IOException {
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                TableName[] tableNameArray = ProtobufUtil.getTableNameArray(master.getTableNames(null, MasterProtos.GetTableNamesRequest.newBuilder().build()).getTableNamesList());
                return tableNameArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
            if (tableNames == null || tableNames.isEmpty()) {
                return new HTableDescriptor[0];
            }
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                HTableDescriptor[] hTableDescriptorArray = ProtobufUtil.getHTableDescriptorArray(master.getTableDescriptors(null, req));
                return hTableDescriptorArray;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
        }

        @Override
        public HTableDescriptor[] getHTableDescriptors(List<String> names) throws IOException {
            ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
            for (String name : names) {
                tableNames.add(TableName.valueOf((String)name));
            }
            return this.getHTableDescriptorsByTableName(tableNames);
        }

        @Override
        public NonceGenerator getNonceGenerator() {
            return this.nonceGenerator;
        }

        @Override
        public HTableDescriptor getHTableDescriptor(TableName tableName) throws IOException {
            MasterProtos.GetTableDescriptorsResponse htds;
            if (tableName == null) {
                return null;
            }
            if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            MasterKeepAliveConnection master = this.getKeepAliveMasterService();
            try {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                htds = master.getTableDescriptors(null, req);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
            finally {
                master.close();
            }
            if (!htds.getTableSchemaList().isEmpty()) {
                return HTableDescriptor.convert((HBaseProtos.TableSchema)htds.getTableSchemaList().get(0));
            }
            throw new TableNotFoundException(tableName.getNameAsString());
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            return this.getHTableDescriptor(TableName.valueOf((byte[])tableName));
        }

        private static class DelayedClosing
        extends Chore
        implements Stoppable {
            private HConnectionImplementation hci;
            Stoppable stoppable;

            private DelayedClosing(HConnectionImplementation hci, Stoppable stoppable) {
                super("ZooKeeperWatcher and Master delayed closing for connection " + hci, 60000, stoppable);
                this.hci = hci;
                this.stoppable = stoppable;
            }

            static DelayedClosing createAndStart(HConnectionImplementation hci) {
                Stoppable stoppable = new Stoppable(){
                    private volatile boolean isStopped = false;

                    @Override
                    public void stop(String why) {
                        this.isStopped = true;
                    }

                    @Override
                    public boolean isStopped() {
                        return this.isStopped;
                    }
                };
                return new DelayedClosing(hci, stoppable);
            }

            protected void closeMasterProtocol(MasterServiceState protocolState) {
                if (System.currentTimeMillis() > protocolState.keepAliveUntil) {
                    this.hci.closeMasterService(protocolState);
                    protocolState.keepAliveUntil = Long.MAX_VALUE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void chore() {
                Object object = this.hci.masterAndZKLock;
                synchronized (object) {
                    if (this.hci.canCloseZKW && System.currentTimeMillis() > this.hci.keepZooKeeperWatcherAliveUntil) {
                        this.hci.closeZooKeeperWatcher();
                        this.hci.keepZooKeeperWatcherAliveUntil = Long.MAX_VALUE;
                    }
                    this.closeMasterProtocol(this.hci.masterServiceState);
                    this.closeMasterProtocol(this.hci.masterServiceState);
                }
            }

            @Override
            public void stop(String why) {
                this.stoppable.stop(why);
            }

            @Override
            public boolean isStopped() {
                return this.stoppable.isStopped();
            }
        }

        class MasterServiceStubMaker
        extends StubMaker {
            private MasterProtos.MasterService.BlockingInterface stub;

            MasterServiceStubMaker() {
            }

            @Override
            protected String getServiceName() {
                return MasterProtos.MasterService.getDescriptor().getName();
            }

            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            MasterProtos.MasterService.BlockingInterface makeStub() throws MasterNotRunningException {
                return (MasterProtos.MasterService.BlockingInterface)super.makeStub();
            }

            @Override
            protected Object makeStub(BlockingRpcChannel channel) {
                this.stub = MasterProtos.MasterService.newBlockingStub((BlockingRpcChannel)channel);
                return this.stub;
            }

            @Override
            protected void isMasterRunning() throws ServiceException {
                this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
            }
        }

        abstract class StubMaker {
            StubMaker() {
            }

            protected abstract String getServiceName();

            protected abstract Object makeStub(BlockingRpcChannel var1);

            protected abstract void isMasterRunning() throws ServiceException;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object makeStubNoRetries() throws IOException, KeeperException, ServiceException {
                ZooKeeperKeepAliveConnection zkw;
                try {
                    zkw = HConnectionImplementation.this.getKeepAliveZooKeeperWatcher();
                }
                catch (IOException e) {
                    ExceptionUtil.rethrowIfInterrupt((Throwable)e);
                    throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
                }
                try {
                    HConnectionImplementation.this.checkIfBaseNodeAvailable(zkw);
                    ServerName sn = MasterAddressTracker.getMasterAddress(zkw);
                    if (sn == null) {
                        String msg = "ZooKeeper available but no active master location found";
                        LOG.info((Object)msg);
                        throw new MasterNotRunningException(msg);
                    }
                    if (HConnectionImplementation.this.isDeadServer(sn)) {
                        throw new MasterNotRunningException(sn + " is dead.");
                    }
                    String key = HConnectionImplementation.getStubKey(this.getServiceName(), sn.getHostAndPort());
                    HConnectionImplementation.this.connectionLock.putIfAbsent(key, key);
                    Object stub = null;
                    String string = (String)HConnectionImplementation.this.connectionLock.get(key);
                    synchronized (string) {
                        stub = HConnectionImplementation.this.stubs.get(key);
                        if (stub == null) {
                            BlockingRpcChannel channel = HConnectionImplementation.this.rpcClient.createBlockingRpcChannel(sn, HConnectionImplementation.this.user, HConnectionImplementation.this.rpcTimeout);
                            stub = this.makeStub(channel);
                            this.isMasterRunning();
                            HConnectionImplementation.this.stubs.put(key, stub);
                        }
                    }
                    string = stub;
                    return string;
                }
                finally {
                    zkw.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"})
            Object makeStub() throws MasterNotRunningException {
                Object object = HConnectionImplementation.this.masterAndZKLock;
                synchronized (object) {
                    Throwable exceptionCaught = null;
                    Object stub = null;
                    int tries = 0;
                    while (!HConnectionImplementation.this.closed && stub == null) {
                        ++tries;
                        try {
                            stub = this.makeStubNoRetries();
                        }
                        catch (IOException e) {
                            exceptionCaught = e;
                        }
                        catch (KeeperException e) {
                            exceptionCaught = e;
                        }
                        catch (ServiceException e) {
                            exceptionCaught = e;
                        }
                        if (exceptionCaught == null) continue;
                        if (tries < HConnectionImplementation.this.numTries && !ExceptionUtil.isInterrupt((Throwable)exceptionCaught)) {
                            long pauseTime = ConnectionUtils.getPauseTime(HConnectionImplementation.this.pause, tries - 1);
                            LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; retrying after sleep of " + pauseTime + ", exception=" + exceptionCaught));
                            try {
                                Thread.sleep(pauseTime);
                                continue;
                            }
                            catch (InterruptedException e) {
                                throw new MasterNotRunningException("Thread was interrupted while trying to connect to master.", e);
                            }
                        }
                        LOG.info((Object)("getMaster attempt " + tries + " of " + HConnectionImplementation.this.numTries + " failed; no more retrying."), exceptionCaught);
                        throw new MasterNotRunningException((Exception)exceptionCaught);
                    }
                    if (stub == null) {
                        throw new MasterNotRunningException("Connection was closed while trying to get master");
                    }
                    return stub;
                }
            }
        }

        static class MasterServiceState {
            HConnection connection;
            MasterProtos.MasterService.BlockingInterface stub;
            int userCount;
            long keepAliveUntil = Long.MAX_VALUE;

            MasterServiceState(HConnection connection) {
                this.connection = connection;
            }

            public String toString() {
                return "MasterService";
            }

            Object getStub() {
                return this.stub;
            }

            void clearStub() {
                this.stub = null;
            }

            boolean isMasterRunning() throws ServiceException {
                MasterProtos.IsMasterRunningResponse response = this.stub.isMasterRunning(null, RequestConverter.buildIsMasterRunningRequest());
                return response != null ? response.getIsMasterRunning() : false;
            }
        }
    }

    static class NoNonceGenerator
    implements NonceGenerator {
        NoNonceGenerator() {
        }

        @Override
        public long getNonceGroup() {
            return 0L;
        }

        @Override
        public long newNonce() {
            return 0L;
        }
    }
}

