/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;

@InterfaceAudience.Private
public class MetaReader {
    private static final Log LOG = LogFactory.getLog(MetaReader.class);
    static final byte[] META_REGION_PREFIX;
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN;

    public static List<Result> fullScan(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, v, null);
        return v.getResults();
    }

    public static List<Result> fullScanOfMeta(CatalogTracker catalogTracker) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaReader.fullScan(catalogTracker, v, null);
        return v.getResults();
    }

    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor) throws IOException {
        MetaReader.fullScan(catalogTracker, visitor, null);
    }

    private static HTable getHTable(CatalogTracker catalogTracker, TableName tableName) throws IOException {
        HConnection c = catalogTracker.getConnection();
        if (c == null) {
            throw new NullPointerException("No connection");
        }
        return new HTable(catalogTracker.getConnection().getConfiguration(), tableName);
    }

    static HTable getCatalogHTable(CatalogTracker catalogTracker) throws IOException {
        return MetaReader.getMetaHTable(catalogTracker);
    }

    static HTable getMetaHTable(CatalogTracker ct) throws IOException {
        return MetaReader.getHTable(ct, TableName.META_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Result get(HTable t, Get g) throws IOException {
        try {
            Result result = t.get(g);
            return result;
        }
        finally {
            t.close();
        }
    }

    @Deprecated
    public static Pair<HRegionInfo, ServerName> getRegion(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        HRegionLocation location = MetaReader.getRegionLocation(catalogTracker, regionName);
        return location == null ? null : new Pair((Object)location.getRegionInfo(), (Object)location.getServerName());
    }

    public static HRegionLocation getRegionLocation(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        byte[] row = regionName;
        HRegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaReader.parseRegionInfoFromRegionName(regionName);
            row = MetaReader.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception parseEx) {
            // empty catch block
        }
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaReader.get(MetaReader.getCatalogHTable(catalogTracker), get);
        RegionLocations locations = MetaReader.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(CatalogTracker catalogTracker, HRegionInfo regionInfo) throws IOException {
        byte[] row = MetaReader.getMetaKeyForRegion(regionInfo);
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaReader.get(MetaReader.getCatalogHTable(catalogTracker), get);
        return MetaReader.getRegionLocation(r, regionInfo, regionInfo.getReplicaId());
    }

    protected static byte[] getMetaKeyForRegion(HRegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    protected static HRegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields = HRegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString((byte[])fields[2]));
        int replicaId = fields.length > 3 ? Integer.parseInt(Bytes.toString((byte[])fields[3]), 16) : 0;
        return new HRegionInfo(TableName.valueOf((byte[])fields[0]), fields[1], fields[1], false, regionId, replicaId);
    }

    public static Result getRegionResult(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Get get = new Get(regionName);
        get.addFamily(HConstants.CATALOG_FAMILY);
        return MetaReader.get(MetaReader.getCatalogHTable(catalogTracker), get);
    }

    public static Pair<HRegionInfo, HRegionInfo> getRegionsFromMergeQualifier(CatalogTracker catalogTracker, byte[] regionName) throws IOException {
        Result result = MetaReader.getRegionResult(catalogTracker, regionName);
        HRegionInfo mergeA = MetaReader.getHRegionInfo(result, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaReader.getHRegionInfo(result, HConstants.MERGEB_QUALIFIER);
        if (mergeA == null && mergeB == null) {
            return null;
        }
        return new Pair((Object)mergeA, (Object)mergeB);
    }

    public static boolean tableExists(CatalogTracker catalogTracker, final TableName tableName) throws IOException {
        if (tableName.equals((Object)HTableDescriptor.META_TABLEDESC.getTableName())) {
            return true;
        }
        CollectingVisitor<HRegionInfo> visitor = new CollectingVisitor<HRegionInfo>(){
            private HRegionInfo current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                RegionLocations locations = MetaReader.getRegionLocations(r);
                if (locations == null || locations.getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                this.current = locations.getRegionLocation().getRegionInfo();
                if (this.current == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                if (!MetaReader.isInsideTable(this.current, tableName)) {
                    return false;
                }
                super.visit(r);
                return false;
            }

            @Override
            void add(Result r) {
                this.results.add(this.current);
            }
        };
        MetaReader.fullScan(catalogTracker, visitor, MetaReader.getTableStartRowForMeta(tableName));
        return visitor.getResults().size() >= 1;
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, TableName tableName) throws IOException {
        return MetaReader.getTableRegions(catalogTracker, tableName, false);
    }

    public static List<HRegionInfo> getTableRegions(CatalogTracker catalogTracker, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result = null;
        try {
            result = MetaReader.getTableRegionsAndLocations(catalogTracker, tableName, excludeOfflinedSplitParents);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
        return MetaReader.getListOfHRegionInfos(result);
    }

    static List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add((HRegionInfo)pair.getFirst());
        }
        return result;
    }

    static boolean isInsideTable(HRegionInfo current, TableName tableName) {
        return tableName.equals((Object)current.getTable());
    }

    static byte[] getTableStartRowForMeta(TableName tableName) {
        byte[] startRow = new byte[tableName.getName().length + 2];
        System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
        startRow[startRow.length - 2] = 44;
        startRow[startRow.length - 1] = 44;
        return startRow;
    }

    public static Scan getScanForTableName(TableName tableName) {
        String strName = tableName.getNameAsString();
        byte[] startKey = Bytes.toBytes((String)(strName + ",,"));
        byte[] stopKey = Bytes.toBytes((String)(strName + " ,,"));
        Scan scan = new Scan(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, TableName tableName) throws IOException, InterruptedException {
        return MetaReader.getTableRegionsAndLocations(catalogTracker, tableName, true);
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(CatalogTracker catalogTracker, final TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException, InterruptedException {
        if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
            ServerName serverName = catalogTracker.getMetaLocation();
            ArrayList<Pair<HRegionInfo, ServerName>> list = new ArrayList<Pair<HRegionInfo, ServerName>>();
            list.add(new Pair((Object)HRegionInfo.FIRST_META_REGIONINFO, (Object)serverName));
            return list;
        }
        CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaReader.getRegionLocations(r);
                if (this.current == null || this.current.getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                HRegionInfo hri = this.current.getRegionLocation().getRegionInfo();
                if (!MetaReader.isInsideTable(hri, tableName)) {
                    return false;
                }
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair((Object)loc.getRegionInfo(), (Object)loc.getServerName()));
                }
            }
        };
        MetaReader.fullScan(catalogTracker, visitor, MetaReader.getTableStartRowForMeta(tableName));
        return visitor.getResults();
    }

    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(CatalogTracker catalogTracker, final ServerName serverName) throws IOException {
        final TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                RegionLocations locations = MetaReader.getRegionLocations(r);
                if (locations == null) {
                    return;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null || loc.getServerName() == null || !loc.getServerName().equals(serverName)) continue;
                    hris.put(loc.getRegionInfo(), r);
                }
            }
        };
        MetaReader.fullScan(catalogTracker, v);
        return hris;
    }

    public static void fullScanMetaAndPrint(CatalogTracker catalogTracker) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info((Object)("fullScanMetaAndPrint.Current Meta Row: " + r));
                RegionLocations locations = MetaReader.getRegionLocations(r);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    LOG.info((Object)("fullScanMetaAndPrint.HRI Print= " + loc.getRegionInfo()));
                }
                return true;
            }
        };
        MetaReader.fullScan(catalogTracker, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fullScan(CatalogTracker catalogTracker, Visitor visitor, byte[] startrow) throws IOException {
        Scan scan = new Scan();
        if (startrow != null) {
            scan.setStartRow(startrow);
        }
        if (startrow == null) {
            int caching = catalogTracker.getConnection().getConfiguration().getInt(HConstants.HBASE_META_SCANNER_CACHING, 100);
            scan.setCaching(caching);
        }
        scan.addFamily(HConstants.CATALOG_FAMILY);
        HTable metaTable = MetaReader.getMetaHTable(catalogTracker);
        ResultScanner scanner = null;
        try {
            Result data;
            scanner = metaTable.getScanner(scan);
            while ((data = scanner.next()) != null && (data.isEmpty() || visitor.visit(data))) {
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            metaTable.close();
        }
    }

    protected static byte[] getFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    protected static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    @VisibleForTesting
    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes((String)("server_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes((String)("serverstartcode_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes((String)("seqnumDuringOpen_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString((byte[])serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    private static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = MetaReader.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(MetaReader.getFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        byte[] startcodeColumn = MetaReader.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(MetaReader.getFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        return ServerName.valueOf(hostAndPort, Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(MetaReader.getFamily(), MetaReader.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
    }

    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        HRegionInfo regionInfo = MetaReader.getHRegionInfo(r, MetaReader.getRegionInfoColumn());
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(MetaReader.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(MetaReader.getFamily());
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = MetaReader.getServerColumn(replicaId);
        NavigableMap serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator i$ = serverMap.entrySet().iterator();
        while (i$.hasNext() && (replicaId = MetaReader.parseReplicaIdFromServerColumn((byte[])(entry = i$.next()).getKey())) >= 0) {
            locations.add(MetaReader.getRegionLocation(r, regionInfo, replicaId));
        }
        return new RegionLocations(locations);
    }

    private static HRegionLocation getRegionLocation(Result r, HRegionInfo regionInfo, int replicaId) {
        ServerName serverName = MetaReader.getServerName(r, replicaId);
        long seqNum = MetaReader.getSeqNumDuringOpen(r, replicaId);
        HRegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        return MetaReader.getHRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    private static HRegionInfo getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(MetaReader.getFamily(), qualifier);
        if (cell == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) throws IOException {
        HRegionInfo splitA = MetaReader.getHRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        HRegionInfo splitB = MetaReader.getHRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType((Object)splitA, (Object)splitB);
    }

    public static PairOfSameType<HRegionInfo> getMergeRegions(Result data) throws IOException {
        HRegionInfo mergeA = MetaReader.getHRegionInfo(data, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaReader.getHRegionInfo(data, HConstants.MERGEB_QUALIFIER);
        return new PairOfSameType((Object)mergeA, (Object)mergeB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRegionCount(Configuration c, String tableName) throws IOException {
        HTable t = new HTable(c, tableName);
        try {
            int n = t.getRegionLocations().size();
            return n;
        }
        finally {
            t.close();
        }
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
        SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }
}

