/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TimeRange {
    private long minStamp = 0L;
    private long maxStamp = Long.MAX_VALUE;
    private boolean allTime = false;

    public TimeRange() {
        this.allTime = true;
    }

    public TimeRange(long minStamp) {
        this.minStamp = minStamp;
    }

    public TimeRange(byte[] minStamp) {
        this.minStamp = Bytes.toLong(minStamp);
    }

    public TimeRange(long minStamp, long maxStamp) throws IOException {
        if (minStamp < 0L || maxStamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. minStamp:" + minStamp + ", maxStamp" + maxStamp);
        }
        if (maxStamp < minStamp) {
            throw new IOException("maxStamp is smaller than minStamp");
        }
        this.minStamp = minStamp;
        this.maxStamp = maxStamp;
    }

    public TimeRange(byte[] minStamp, byte[] maxStamp) throws IOException {
        this(Bytes.toLong(minStamp), Bytes.toLong(maxStamp));
    }

    public long getMin() {
        return this.minStamp;
    }

    public long getMax() {
        return this.maxStamp;
    }

    public boolean isAllTime() {
        return this.allTime;
    }

    public boolean withinTimeRange(byte[] bytes, int offset) {
        if (this.allTime) {
            return true;
        }
        return this.withinTimeRange(Bytes.toLong(bytes, offset));
    }

    public boolean withinTimeRange(long timestamp) {
        if (this.allTime) {
            return true;
        }
        return this.minStamp <= timestamp && timestamp < this.maxStamp;
    }

    public boolean withinOrAfterTimeRange(long timestamp) {
        if (this.allTime) {
            return true;
        }
        return timestamp >= this.minStamp;
    }

    public int compare(long timestamp) {
        if (timestamp < this.minStamp) {
            return -1;
        }
        if (timestamp >= this.maxStamp) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("maxStamp=");
        sb.append(this.maxStamp);
        sb.append(", minStamp=");
        sb.append(this.minStamp);
        return sb.toString();
    }
}

