/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Tag {
    public static final int TYPE_LENGTH_SIZE = 1;
    public static final int TAG_LENGTH_SIZE = 2;
    public static final int INFRASTRUCTURE_SIZE = 3;
    private final byte type;
    private final byte[] bytes;
    private int offset = 0;
    private short length = 0;

    public Tag(byte tagType, String tag) {
        this(tagType, Bytes.toBytes(tag));
    }

    public Tag(byte tagType, byte[] tag) {
        short tagLength = (short)((tag.length & 0xFFFF) + 1);
        this.length = (short)(2 + tagLength);
        this.bytes = new byte[this.length];
        int pos = Bytes.putShort(this.bytes, 0, tagLength);
        pos = Bytes.putByte(this.bytes, pos, tagType);
        Bytes.putBytes(this.bytes, pos, tag, 0, tag.length);
        this.type = tagType;
    }

    public Tag(byte[] bytes, int offset) {
        this(bytes, offset, Tag.getLength(bytes, offset));
    }

    private static short getLength(byte[] bytes, int offset) {
        return (short)(2 + Bytes.toShort(bytes, offset));
    }

    public Tag(byte[] bytes, int offset, short length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.type = bytes[offset + 2];
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public byte getType() {
        return this.type;
    }

    public int getTagLength() {
        return this.length - 3;
    }

    public int getTagOffset() {
        return this.offset + 3;
    }

    public byte[] getValue() {
        int tagLength = this.getTagLength();
        byte[] tag = new byte[tagLength];
        Bytes.putBytes(tag, 0, this.bytes, this.getTagOffset(), tagLength);
        return tag;
    }

    public static List<Tag> asList(byte[] b, int offset, int length) {
        short tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.toShort(b, pos);
            tags.add(new Tag(b, pos, (short)(tagLen + 2)));
        }
        return tags;
    }

    public static Tag getTag(byte[] b, int offset, int length, byte type) {
        short tagLen;
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.toShort(b, pos);
            if (b[pos + 2] != type) continue;
            return new Tag(b, pos, (short)(tagLen + 2));
        }
        return null;
    }

    short getLength() {
        return this.length;
    }

    int getOffset() {
        return this.offset;
    }
}

