/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource.bonecp;

import com.jolbox.bonecp.BoneCPDataSource;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastoreDriverNotFoundException;
import org.datanucleus.util.ClassUtils;

public class BoneCPDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(OMFContext omfCtx) {
        int value;
        int size;
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        StoreManager storeMgr = omfCtx.getStoreManager();
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        String dbPassword = storeMgr.getConnectionPassword();
        ClassLoaderResolver clr = omfCtx.getClassLoaderResolver(null);
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                clr.classForName(dbDriver);
            }
            catch (RuntimeException e) {
                throw new DatastoreDriverNotFoundException(dbDriver);
            }
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.jolbox.bonecp.BoneCPDataSource", (String)"bonecp.jar");
        BoneCPDataSource ds = new BoneCPDataSource();
        if (conf.hasProperty("datanucleus.connectionPool.maxStatements") && (size = conf.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
            ds.setStatementsCacheSize(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            ds.setMaxConnectionsPerPartition(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
            ds.setMinConnectionsPerPartition(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.maxIdle") && (value = conf.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
            ds.setIdleMaxAge((long)value);
        }
        ds.setJdbcUrl(dbURL);
        ds.setUsername(dbUser);
        ds.setPassword(dbPassword);
        return ds;
    }
}

