/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Type;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Visitor;

public class UnaryExpression
extends Expression {
    public final Expression expression;

    UnaryExpression(ExpressionType nodeType, Type type, Expression expression) {
        super(nodeType, type);
        this.expression = expression;
    }

    public Expression accept(Visitor visitor) {
        Expression expression = this.expression.accept(visitor);
        return visitor.visit(this, expression);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)obj;
            return this.nodeType == unaryExpression.nodeType && this.type.equals(unaryExpression.type) && this.expression.equals(unaryExpression.expression);
        }
        return false;
    }

    public int hashCode() {
        return this.nodeType.hashCode() ^ this.expression.hashCode();
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        switch (this.nodeType) {
            case Convert: {
                if (!writer.requireParentheses(this, lprec, rprec)) {
                    writer.append("(").append(this.type).append(") ");
                    this.expression.accept(writer, this.nodeType.rprec, rprec);
                }
                return;
            }
        }
        if (this.nodeType.postfix) {
            this.expression.accept(writer, lprec, this.nodeType.rprec);
            writer.append(this.nodeType.op);
        } else {
            writer.append(this.nodeType.op);
            this.expression.accept(writer, this.nodeType.lprec, rprec);
        }
    }
}

