/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.GotoExpressionKind;
import net.hydromatic.linq4j.expressions.LabelTarget;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class GotoStatement
extends Statement {
    public final GotoExpressionKind kind;
    public final LabelTarget labelTarget;
    public final Expression expression;

    GotoStatement(GotoExpressionKind kind, LabelTarget labelTarget, Expression expression) {
        super(ExpressionType.Goto, expression == null ? Void.TYPE : expression.getType());
        this.kind = kind;
        this.labelTarget = labelTarget;
        this.expression = expression;
        switch (kind) {
            case Break: 
            case Continue: {
                assert (expression == null);
                break;
            }
            case Goto: {
                assert (expression == null);
                assert (labelTarget != null);
                break;
            }
            case Return: 
            case Sequence: {
                assert (labelTarget == null);
                break;
            }
            default: {
                throw new RuntimeException("unexpected: " + (Object)((Object)kind));
            }
        }
    }

    public Statement accept(Visitor visitor) {
        Expression expression1 = this.expression == null ? null : this.expression.accept(visitor);
        return visitor.visit(this, expression1);
    }

    void accept0(ExpressionWriter writer) {
        writer.append(this.kind.prefix);
        if (this.labelTarget != null) {
            writer.append(' ').append(this.labelTarget.name);
        }
        if (this.expression != null) {
            if (!this.kind.prefix.isEmpty()) {
                writer.append(' ');
            }
            switch (this.kind) {
                case Sequence: {
                    this.expression.accept(writer, 0, 0);
                    break;
                }
                default: {
                    writer.begin();
                    this.expression.accept(writer, 0, 0);
                    writer.end();
                }
            }
        }
        writer.append(';').newlineAndIndent();
    }

    public Object evaluate(Evaluator evaluator) {
        switch (this.kind) {
            case Return: 
            case Sequence: {
                return this.expression.evaluate(evaluator);
            }
        }
        throw new AssertionError((Object)"evaluate not implemented");
    }
}

