/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends Statement {
    public final List<DeclarationStatement> declarations;
    public final Expression condition;
    public final Expression post;
    public final Statement body;

    public ForStatement(List<DeclarationStatement> declarations, Expression condition, Expression post, Statement body) {
        super(ExpressionType.For, Void.TYPE);
        assert (declarations != null);
        assert (body != null);
        this.declarations = declarations;
        this.condition = condition;
        this.post = post;
        this.body = body;
    }

    @Override
    public ForStatement accept(Visitor visitor) {
        List<DeclarationStatement> decls1 = Expressions.acceptDeclarations(this.declarations, visitor);
        Expression condition1 = this.condition == null ? null : this.condition.accept(visitor);
        Expression post1 = this.post == null ? null : this.post.accept(visitor);
        Statement body1 = this.body.accept(visitor);
        return visitor.visit(this, decls1, condition1, post1, body1);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        writer.append("for (");
        for (Ord<DeclarationStatement> declaration : Ord.zip(this.declarations)) {
            ((DeclarationStatement)declaration.e).accept2(writer, declaration.i == 0);
        }
        writer.append("; ");
        if (this.condition != null) {
            writer.append(this.condition);
        }
        writer.append("; ");
        if (this.post != null) {
            writer.append(this.post);
        }
        writer.append(") ").append(Blocks.toBlock(this.body));
    }
}

