/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalStatement
extends Statement {
    private final List<Node> expressionList;

    public ConditionalStatement(List<Node> expressionList) {
        super(ExpressionType.Conditional, Void.TYPE);
        this.expressionList = expressionList;
    }

    @Override
    public ConditionalStatement accept(Visitor visitor) {
        List<Node> list = Expressions.acceptNodes(this.expressionList, visitor);
        if (!list.equals(this.expressionList)) {
            return new ConditionalStatement(list);
        }
        return this;
    }

    @Override
    void accept0(ExpressionWriter writer) {
        for (int i = 0; i < this.expressionList.size(); i += 2) {
            writer.append(i > 0 ? " else if (" : "if (").append(this.expressionList.get(i)).append(") ").append(Blocks.toBlock(this.expressionList.get(i + 1)));
        }
        if (this.expressionList.size() % 2 == 1) {
            writer.append(" else ").append(Blocks.toBlock(this.expressionList.get(this.expressionList.size() - 1)));
        }
    }
}

