/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.AbstractEnumerable2;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.EnumerableOrderedQueryable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Extensions;
import net.hydromatic.linq4j.Grouping;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.Lookup;
import net.hydromatic.linq4j.LookupImpl;
import net.hydromatic.linq4j.OrderedEnumerable;
import net.hydromatic.linq4j.OrderedQueryable;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.function.BigDecimalFunction1;
import net.hydromatic.linq4j.function.DoubleFunction1;
import net.hydromatic.linq4j.function.EqualityComparer;
import net.hydromatic.linq4j.function.FloatFunction1;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.IntegerFunction1;
import net.hydromatic.linq4j.function.LongFunction1;
import net.hydromatic.linq4j.function.NullableBigDecimalFunction1;
import net.hydromatic.linq4j.function.NullableDoubleFunction1;
import net.hydromatic.linq4j.function.NullableFloatFunction1;
import net.hydromatic.linq4j.function.NullableIntegerFunction1;
import net.hydromatic.linq4j.function.NullableLongFunction1;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.linq4j.function.Predicate2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumerableDefaults {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> TSource aggregate(Enumerable<TSource> source, Function2<TSource, TSource, TSource> func) {
        Object result = null;
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                result = func.apply(result, o);
            }
            Object T1 = result;
            return (TSource)T1;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource, TAccumulate> TAccumulate aggregate(Enumerable<TSource> source, TAccumulate seed, Function2<TAccumulate, TSource, TAccumulate> func) {
        TAccumulate result = seed;
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                result = func.apply(result, o);
            }
            TAccumulate TAccumulate = result;
            return TAccumulate;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource, TAccumulate, TResult> TResult aggregate(Enumerable<TSource> source, TAccumulate seed, Function2<TAccumulate, TSource, TAccumulate> func, Function1<TAccumulate, TResult> selector) {
        TAccumulate accumulate = seed;
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                accumulate = func.apply(accumulate, o);
            }
            TResult TResult = selector.apply(accumulate);
            return TResult;
        }
        finally {
            os.close();
        }
    }

    public static <TSource> boolean all(Enumerable<?> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static boolean any(Enumerable enumerable) {
        return enumerable.enumerator().moveNext();
    }

    public static <TSource> boolean any(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> Enumerable<TSource> asEnumerable(Enumerable<TSource> enumerable) {
        return enumerable;
    }

    public static <TSource> Queryable<TSource> asQueryable(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> BigDecimal average(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector).divide(BigDecimal.valueOf(EnumerableDefaults.longCount(source)));
    }

    public static <TSource> BigDecimal average(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector).divide(BigDecimal.valueOf(EnumerableDefaults.longCount(source)));
    }

    public static <TSource> double average(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (double)EnumerableDefaults.longCount(source);
    }

    public static <TSource> Double average(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (double)EnumerableDefaults.longCount(source);
    }

    public static <TSource> int average(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.count(source);
    }

    public static <TSource> Integer average(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.count(source);
    }

    public static <TSource> long average(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.longCount(source);
    }

    public static <TSource> Long average(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / EnumerableDefaults.longCount(source);
    }

    public static <TSource> float average(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.sum(source, selector) / (float)EnumerableDefaults.longCount(source);
    }

    public static <TSource> Float average(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return Float.valueOf(EnumerableDefaults.sum(source, selector).floatValue() / (float)EnumerableDefaults.longCount(source));
    }

    public static <TSource, T2> Enumerable<T2> cast(final Enumerable<TSource> source, final Class<T2> clazz) {
        return new AbstractEnumerable<T2>(){

            @Override
            public Enumerator<T2> enumerator() {
                return new CastingEnumerator(source.enumerator(), clazz);
            }
        };
    }

    public static <TSource> Enumerable<TSource> concat(Enumerable<TSource> enumerable0, Enumerable<TSource> enumerable1) {
        return Linq4j.concat(Arrays.asList(enumerable0, enumerable1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> boolean contains(Enumerable<TSource> enumerable, TSource element) {
        Enumerator os = enumerable.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                if (!o.equals(element)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            os.close();
        }
    }

    public static <TSource> boolean contains(Enumerable<TSource> enumerable, TSource element, EqualityComparer comparer) {
        throw Extensions.todo();
    }

    public static <TSource> int count(Enumerable<TSource> enumerable) {
        return (int)EnumerableDefaults.longCount(enumerable, Functions.truePredicate1());
    }

    public static <TSource> int count(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        return (int)EnumerableDefaults.longCount(enumerable, predicate);
    }

    public static <TSource> Enumerable<TSource> defaultIfEmpty(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> TSource defaultIfEmpty(Enumerable<TSource> enumerable, TSource value) {
        throw Extensions.todo();
    }

    public static <TSource> Enumerable<TSource> distinct(Enumerable<TSource> enumerable) {
        Enumerator os = enumerable.enumerator();
        HashSet set = new HashSet();
        while (os.moveNext()) {
            set.add(os.current());
        }
        os.close();
        return Linq4j.asEnumerable(set);
    }

    public static <TSource> Enumerable<TSource> distinct(Enumerable<TSource> enumerable, EqualityComparer<TSource> comparer) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.distinct(enumerable);
        }
        HashSet set = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        enumerable.select(wrapper).into(set);
        return Linq4j.asEnumerable(set).select(unwrapper);
    }

    public static <TSource> TSource elementAt(Enumerable<TSource> enumerable, int index) {
        throw Extensions.todo();
    }

    public static <TSource> TSource elementAtOrDefault(Enumerable<TSource> enumerable, int index) {
        throw Extensions.todo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        HashSet set = new HashSet();
        source0.into(set);
        Enumerator os = source1.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                set.remove(o);
            }
            Enumerable enumerable = Linq4j.asEnumerable(set);
            return enumerable;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> Enumerable<TSource> except(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        HashSet set = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        source0.select(wrapper).into(set);
        Enumerator os = source1.select(wrapper).enumerator();
        try {
            while (os.moveNext()) {
                Wrapped o = (Wrapped)os.current();
                set.remove(o);
            }
        }
        finally {
            os.close();
        }
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        return Linq4j.asEnumerable(set).select(unwrapper);
    }

    public static <TSource> TSource first(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> TSource first(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> TSource firstOrDefault(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> TSource firstOrDefault(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource, TKey> Enumerable<Grouping<TKey, TSource>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector) {
        return enumerable.toLookup(keySelector);
    }

    public static <TSource, TKey> Enumerable<Grouping<TKey, TSource>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        return enumerable.toLookup(keySelector, comparer);
    }

    public static <TSource, TKey, TElement> Enumerable<Grouping<TKey, TElement>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TResult> Enumerable<Grouping<TKey, TResult>> groupBy(Enumerable<TSource> queryable, Function1<TSource, TKey> keySelector, Function2<TKey, Enumerable<TSource>, TResult> elementSelector) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TElement> Enumerable<Grouping<TKey, TElement>> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function2<TKey, Enumerable<TSource>, TResult> elementSelector, EqualityComparer comparer) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TElement, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, Function2<TKey, Enumerable<TElement>, TResult> resultSelector) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TElement, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, Function2<TKey, Enumerable<TElement>, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        throw Extensions.todo();
    }

    public static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector) {
        return EnumerableDefaults.groupBy_(new HashMap(), enumerable, keySelector, accumulatorInitializer, accumulatorAdder, resultSelector);
    }

    public static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy(Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function2<TKey, TAccumulate, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.groupBy_(new WrapMap(comparer), enumerable, keySelector, accumulatorInitializer, accumulatorAdder, resultSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <TSource, TKey, TAccumulate, TResult> Enumerable<TResult> groupBy_(final Map<TKey, TAccumulate> map, Enumerable<TSource> enumerable, Function1<TSource, TKey> keySelector, Function0<TAccumulate> accumulatorInitializer, Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, final Function2<TKey, TAccumulate, TResult> resultSelector) {
        Enumerator os = enumerable.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                TKey key = keySelector.apply(o);
                TAccumulate accumulator = map.get(key);
                if (accumulator == null) {
                    accumulator = accumulatorInitializer.apply();
                    accumulator = accumulatorAdder.apply(accumulator, o);
                    map.put(key, accumulator);
                    continue;
                }
                TAccumulate accumulator0 = accumulator;
                if ((accumulator = accumulatorAdder.apply(accumulator, o)) == accumulator0) continue;
                map.put(key, accumulator);
            }
        }
        finally {
            os.close();
        }
        return new AbstractEnumerable2<TResult>(){

            @Override
            public Iterator<TResult> iterator() {
                final Iterator iterator = map.entrySet().iterator();
                return new Iterator<TResult>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public TResult next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return resultSelector.apply(entry.getKey(), entry.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> groupJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, Enumerable<TInner>, TResult> resultSelector) {
        return new AbstractEnumerable<TResult>(){
            final Map<TKey, TSource> outerMap;
            final Lookup<TKey, TInner> innerLookup;
            final Enumerator<Map.Entry<TKey, TSource>> entries;
            {
                this.outerMap = outer.toMap(outerKeySelector);
                this.innerLookup = inner.toLookup(innerKeySelector);
                this.entries = Linq4j.enumerator(this.outerMap.entrySet());
            }

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){

                    @Override
                    public TResult current() {
                        Map.Entry entry = entries.current();
                        Enumerable inners = (Enumerable)innerLookup.get(entry.getKey());
                        return resultSelector.apply(entry.getValue(), inners == null ? Linq4j.emptyEnumerable() : inners);
                    }

                    @Override
                    public boolean moveNext() {
                        return entries.moveNext();
                    }

                    @Override
                    public void reset() {
                        entries.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> groupJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, Enumerable<TInner>, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        throw Extensions.todo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        HashSet set0 = new HashSet();
        source0.into(set0);
        HashSet set1 = new HashSet();
        Enumerator os = source1.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                if (!set0.contains(o)) continue;
                set1.add(o);
            }
        }
        finally {
            os.close();
        }
        return Linq4j.asEnumerable(set1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> Enumerable<TSource> intersect(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        HashSet set0 = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        source0.select(wrapper).into(set0);
        HashSet<Wrapped> set1 = new HashSet<Wrapped>();
        Enumerator os = source1.select(wrapper).enumerator();
        try {
            while (os.moveNext()) {
                Wrapped o = (Wrapped)os.current();
                if (!set0.contains(o)) continue;
                set1.add(o);
            }
        }
        finally {
            os.close();
        }
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        return Linq4j.asEnumerable(set1).select(unwrapper);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> join(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector) {
        return EnumerableDefaults.join_(outer, inner, outerKeySelector, innerKeySelector, resultSelector, null);
    }

    public static <TSource, TInner, TKey, TResult> Enumerable<TResult> join(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector, Function2<TSource, TInner, TResult> resultSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.join_(outer, inner, outerKeySelector, innerKeySelector, resultSelector, comparer);
    }

    private static <TSource, TInner, TKey, TResult> Enumerable<TResult> joinSymmetric_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, final EqualityComparer<TKey> comparer) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                Lookup outerMap = comparer == null ? outer.toLookup(outerKeySelector) : outer.toLookup(outerKeySelector, comparer);
                final Lookup innerLookup = comparer == null ? inner.toLookup(innerKeySelector) : inner.toLookup(innerKeySelector, comparer);
                final Enumerator entries = Linq4j.enumerator(outerMap.entrySet());
                return new Enumerator<TResult>(){
                    Enumerator<List<Object>> productEnumerator = Linq4j.emptyEnumerator();

                    @Override
                    public TResult current() {
                        List<Object> objects = this.productEnumerator.current();
                        return resultSelector.apply(objects.get(0), objects.get(1));
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.productEnumerator.moveNext()) {
                            if (!entries.moveNext()) {
                                return false;
                            }
                            Map.Entry outer = (Map.Entry)entries.current();
                            Enumerable outerEnumerable = (Enumerable)outer.getValue();
                            Enumerable innerEnumerable = (Enumerable)innerLookup.get(outer.getKey());
                            if (innerEnumerable == null || !innerEnumerable.any() || !outerEnumerable.any()) {
                                this.productEnumerator = Linq4j.emptyEnumerator();
                                continue;
                            }
                            this.productEnumerator = Linq4j.product(Arrays.asList(outerEnumerable.enumerator(), innerEnumerable.enumerator()));
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        entries.reset();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    private static <TSource, TInner, TKey, TResult> Enumerable<TResult> join_(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final Function2<TSource, TInner, TResult> resultSelector, final EqualityComparer<TKey> comparer) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                final Lookup innerLookup = comparer == null ? inner.toLookup(innerKeySelector) : inner.toLookup(innerKeySelector, comparer);
                final Enumerator outers = outer.enumerator();
                return new Enumerator<TResult>(){
                    Enumerator<TInner> inners = Linq4j.emptyEnumerator();

                    @Override
                    public TResult current() {
                        return resultSelector.apply(outers.current(), this.inners.current());
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.inners.moveNext()) {
                            if (!outers.moveNext()) {
                                return false;
                            }
                            Object outer = outers.current();
                            Object outerKey = outerKeySelector.apply(outer);
                            Enumerable innerEnumerable = (Enumerable)innerLookup.get(outerKey);
                            if (innerEnumerable == null || !innerEnumerable.any()) {
                                this.inners = Linq4j.emptyEnumerator();
                                continue;
                            }
                            this.inners = innerEnumerable.enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        outers.reset();
                    }

                    @Override
                    public void close() {
                        outers.close();
                    }
                };
            }
        };
    }

    public static <TSource> TSource last(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> TSource last(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> TSource lastOrDefault(Enumerable<TSource> enumerable) {
        throw Extensions.todo();
    }

    public static <TSource> TSource lastOrDefault(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> long longCount(Enumerable<TSource> source) {
        return EnumerableDefaults.longCount(source, Functions.truePredicate1());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource> long longCount(Enumerable<TSource> enumerable, Predicate1<TSource> predicate) {
        if (predicate == Predicate1.TRUE && enumerable instanceof Collection) {
            return ((Collection)((Object)enumerable)).size();
        }
        int n = 0;
        Enumerator os = enumerable.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                if (!predicate.apply(o)) continue;
                ++n;
            }
        }
        finally {
            os.close();
        }
        return n;
    }

    public static <TSource extends Comparable<TSource>> TSource max(Enumerable<TSource> source) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return (TSource)((Comparable)EnumerableDefaults.aggregate(source, null, max));
    }

    public static <TSource> BigDecimal max(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, max);
    }

    public static <TSource> BigDecimal max(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, max);
    }

    public static <TSource> double max(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.DOUBLE_MAX);
    }

    public static <TSource> Double max(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.DOUBLE_MAX);
    }

    public static <TSource> int max(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.INTEGER_MAX);
    }

    public static <TSource> Integer max(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.INTEGER_MAX);
    }

    public static <TSource> long max(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.LONG_MAX);
    }

    public static <TSource> Long max(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.LONG_MAX);
    }

    public static <TSource> float max(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.FLOAT_MAX).floatValue();
    }

    public static <TSource> Float max(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.FLOAT_MAX);
    }

    public static <TSource, TResult extends Comparable<TResult>> TResult max(Enumerable<TSource> source, Function1<TSource, TResult> selector) {
        Function2<TSource, TSource, TSource> max = EnumerableDefaults.maxFunction();
        return (TResult)((Comparable)EnumerableDefaults.aggregate(source.select(selector), null, max));
    }

    public static <TSource extends Comparable<TSource>> TSource min(Enumerable<TSource> source) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return (TSource)((Comparable)EnumerableDefaults.aggregate(source, null, min));
    }

    private static <TSource extends Comparable<TSource>> Function2<TSource, TSource, TSource> minFunction() {
        return Extensions.COMPARABLE_MIN;
    }

    private static <TSource extends Comparable<TSource>> Function2<TSource, TSource, TSource> maxFunction() {
        return Extensions.COMPARABLE_MAX;
    }

    public static <TSource> BigDecimal min(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, min);
    }

    public static <TSource> BigDecimal min(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return EnumerableDefaults.aggregate(source.select(selector), null, min);
    }

    public static <TSource> double min(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.DOUBLE_MIN);
    }

    public static <TSource> Double min(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.DOUBLE_MIN);
    }

    public static <TSource> int min(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.INTEGER_MIN);
    }

    public static <TSource> Integer min(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.INTEGER_MIN);
    }

    public static <TSource> long min(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.LONG_MIN);
    }

    public static <TSource> Long min(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.LONG_MIN);
    }

    public static <TSource> float min(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), null, Extensions.FLOAT_MIN).floatValue();
    }

    public static <TSource> Float min(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), null, Extensions.FLOAT_MIN);
    }

    public static <TSource, TResult extends Comparable<TResult>> TResult min(Enumerable<TSource> source, Function1<TSource, TResult> selector) {
        Function2<TSource, TSource, TSource> min = EnumerableDefaults.minFunction();
        return (TResult)((Comparable)EnumerableDefaults.aggregate(source.select(selector), null, min));
    }

    public static <TSource, TResult> Enumerable<TResult> ofType(Enumerable<TSource> enumerable, Class<TResult> clazz) {
        return EnumerableDefaults.where(enumerable, Functions.ofTypePredicate(clazz));
    }

    public static <TSource, TKey extends Comparable> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.orderBy(source, keySelector, null);
    }

    public static <TSource, TKey> Enumerable<TSource> orderBy(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        TreeMap map = new TreeMap(comparator);
        LookupImpl lookup = EnumerableDefaults.toLookup_(map, source, keySelector, Functions.identitySelector());
        return lookup.valuesEnumerable();
    }

    public static <TSource, TKey extends Comparable> Enumerable<TSource> orderByDescending(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.orderBy(source, keySelector, Collections.reverseOrder());
    }

    public static <TSource, TKey> Enumerable<TSource> orderByDescending(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.orderBy(source, keySelector, Collections.reverseOrder(comparator));
    }

    public static <TSource> Enumerable<TSource> reverse(Enumerable<TSource> source) {
        final List<TSource> list = EnumerableDefaults.toList(source);
        final int n = list.size();
        return Linq4j.asEnumerable(new AbstractList<TSource>(){

            @Override
            public TSource get(int index) {
                return list.get(n - 1 - index);
            }

            @Override
            public int size() {
                return n;
            }
        });
    }

    public static <TSource, TResult> Enumerable<TResult> select(final Enumerable<TSource> source, final Function1<TSource, TResult> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> enumerator;
                    {
                        this.enumerator = source.enumerator();
                    }

                    @Override
                    public TResult current() {
                        return selector.apply(this.enumerator.current());
                    }

                    @Override
                    public boolean moveNext() {
                        return this.enumerator.moveNext();
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> select(final Enumerable<TSource> source, final Function2<TSource, Integer, TResult> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    final Enumerator<TSource> enumerator;
                    int n;
                    {
                        this.enumerator = source.enumerator();
                        this.n = -1;
                    }

                    @Override
                    public TResult current() {
                        return selector.apply(this.enumerator.current(), this.n);
                    }

                    @Override
                    public boolean moveNext() {
                        if (this.enumerator.moveNext()) {
                            ++this.n;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> selectMany(final Enumerable<TSource> source, final Function1<TSource, Enumerable<TResult>> selector) {
        return new AbstractEnumerable<TResult>(){

            @Override
            public Enumerator<TResult> enumerator() {
                return new Enumerator<TResult>(){
                    Enumerator<TSource> sourceEnumerator;
                    Enumerator<TResult> resultEnumerator;
                    {
                        this.sourceEnumerator = source.enumerator();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public TResult current() {
                        return this.resultEnumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (!this.resultEnumerator.moveNext()) {
                            if (!this.sourceEnumerator.moveNext()) {
                                return false;
                            }
                            this.resultEnumerator = ((Enumerable)selector.apply(this.sourceEnumerator.current())).enumerator();
                        }
                        return true;
                    }

                    @Override
                    public void reset() {
                        this.sourceEnumerator.reset();
                        this.resultEnumerator = Linq4j.emptyEnumerator();
                    }

                    @Override
                    public void close() {
                        this.sourceEnumerator.close();
                        this.resultEnumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource, TResult> Enumerable<TResult> selectMany(Enumerable<TSource> source, Function2<TSource, Integer, Enumerable<TResult>> selector) {
        throw Extensions.todo();
    }

    public static <TSource, TCollection, TResult> Enumerable<TResult> selectMany(Enumerable<TSource> source, Function2<TSource, Integer, Enumerable<TCollection>> collectionSelector, Function2<TSource, TCollection, TResult> resultSelector) {
        throw Extensions.todo();
    }

    public static <TSource, TCollection, TResult> Enumerable<TResult> selectMany(Enumerable<TSource> source, Function1<TSource, Enumerable<TCollection>> collectionSelector, Function2<TSource, TCollection, TResult> resultSelector) {
        throw Extensions.todo();
    }

    public static <TSource> boolean sequenceEqual(Enumerable<TSource> enumerable0, Enumerable<TSource> enumerable1) {
        throw Extensions.todo();
    }

    public static <TSource> boolean sequenceEqual(Enumerable<TSource> enumerable0, Enumerable<TSource> enumerable1, EqualityComparer<TSource> comparer) {
        throw Extensions.todo();
    }

    public static <TSource> TSource single(Enumerable<TSource> source) {
        throw Extensions.todo();
    }

    public static <TSource> TSource single(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> TSource singleOrDefault(Enumerable<TSource> source) {
        throw Extensions.todo();
    }

    public static <TSource> TSource singleOrDefault(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        throw Extensions.todo();
    }

    public static <TSource> Enumerable<TSource> skip(Enumerable<TSource> source, final int count) {
        return EnumerableDefaults.skipWhile(source, new Predicate2<TSource, Integer>(){

            @Override
            public boolean apply(TSource v1, Integer v2) {
                return v2 < count;
            }
        });
    }

    public static <TSource> Enumerable<TSource> skipWhile(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        return EnumerableDefaults.skipWhile(source, Functions.toPredicate2(predicate));
    }

    public static <TSource> Enumerable<TSource> skipWhile(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new SkipWhileEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource> BigDecimal sum(Enumerable<TSource> source, BigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), BigDecimal.ZERO, Extensions.BIG_DECIMAL_SUM);
    }

    public static <TSource> BigDecimal sum(Enumerable<TSource> source, NullableBigDecimalFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), BigDecimal.ZERO, Extensions.BIG_DECIMAL_SUM);
    }

    public static <TSource> double sum(Enumerable<TSource> source, DoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0.0, Extensions.DOUBLE_SUM);
    }

    public static <TSource> Double sum(Enumerable<TSource> source, NullableDoubleFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0.0, Extensions.DOUBLE_SUM);
    }

    public static <TSource> int sum(Enumerable<TSource> source, IntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0, Extensions.INTEGER_SUM);
    }

    public static <TSource> Integer sum(Enumerable<TSource> source, NullableIntegerFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0, Extensions.INTEGER_SUM);
    }

    public static <TSource> long sum(Enumerable<TSource> source, LongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), 0L, Extensions.LONG_SUM);
    }

    public static <TSource> Long sum(Enumerable<TSource> source, NullableLongFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), 0L, Extensions.LONG_SUM);
    }

    public static <TSource> float sum(Enumerable<TSource> source, FloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(Functions.adapt(selector)), Float.valueOf(0.0f), Extensions.FLOAT_SUM).floatValue();
    }

    public static <TSource> Float sum(Enumerable<TSource> source, NullableFloatFunction1<TSource> selector) {
        return EnumerableDefaults.aggregate(source.select(selector), Float.valueOf(0.0f), Extensions.FLOAT_SUM);
    }

    public static <TSource> Enumerable<TSource> take(Enumerable<TSource> source, final int count) {
        return EnumerableDefaults.takeWhile(source, new Predicate2<TSource, Integer>(){

            @Override
            public boolean apply(TSource v1, Integer v2) {
                return v2 < count;
            }
        });
    }

    public static <TSource> Enumerable<TSource> takeWhile(Enumerable<TSource> source, Predicate1<TSource> predicate) {
        return EnumerableDefaults.takeWhile(source, Functions.toPredicate2(predicate));
    }

    public static <TSource> Enumerable<TSource> takeWhile(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new TakeWhileEnumerator(source.enumerator(), predicate);
            }
        };
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> createOrderedEnumerable(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator, boolean descending) {
        throw Extensions.todo();
    }

    public static <TSource, TKey extends Comparable<TKey>> OrderedEnumerable<TSource> thenBy(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, Extensions.comparableComparator(), false);
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> thenBy(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, comparator, false);
    }

    public static <TSource, TKey extends Comparable<TKey>> OrderedEnumerable<TSource> thenByDescending(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, Extensions.comparableComparator(), true);
    }

    public static <TSource, TKey> OrderedEnumerable<TSource> thenByDescending(OrderedEnumerable<TSource> source, Function1<TSource, TKey> keySelector, Comparator<TKey> comparator) {
        return EnumerableDefaults.createOrderedEnumerable(source, keySelector, comparator, true);
    }

    public static <TSource, TKey> Map<TKey, TSource> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.toMap(source, keySelector, Functions.identitySelector());
    }

    public static <TSource, TKey> Map<TKey, TSource> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        throw Extensions.todo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TSource, TKey, TElement> Map<TKey, TElement> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        LinkedHashMap<TKey, TElement> map = new LinkedHashMap<TKey, TElement>();
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                map.put(keySelector.apply(o), elementSelector.apply(o));
            }
        }
        finally {
            os.close();
        }
        return map;
    }

    public static <TSource, TKey, TElement> Map<TKey, TElement> toMap(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        throw Extensions.todo();
    }

    public static <TSource> List<TSource> toList(Enumerable<TSource> source) {
        if (source instanceof List && source instanceof RandomAccess) {
            return (List)((Object)source);
        }
        return source.into(source instanceof Collection ? new ArrayList(((Collection)((Object)source)).size()) : new ArrayList());
    }

    public static <TSource, TKey> Lookup<TKey, TSource> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector) {
        return EnumerableDefaults.toLookup(source, keySelector, Functions.identitySelector());
    }

    public static <TSource, TKey> Lookup<TKey, TSource> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.toLookup(source, keySelector, Functions.identitySelector(), comparer);
    }

    public static <TSource, TKey, TElement> Lookup<TKey, TElement> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        HashMap map = new HashMap();
        return EnumerableDefaults.toLookup_(map, source, keySelector, elementSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <TSource, TKey, TElement> LookupImpl<TKey, TElement> toLookup_(Map<TKey, List<TElement>> map, Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector) {
        Enumerator os = source.enumerator();
        try {
            while (os.moveNext()) {
                Object o = os.current();
                TKey key = keySelector.apply(o);
                List<TElement> list = map.get(key);
                if (list == null) {
                    list = Collections.singletonList(elementSelector.apply(o));
                } else {
                    if (list.size() == 1) {
                        TElement element = list.get(0);
                        list = new ArrayList<TElement>();
                        list.add(element);
                    }
                    list.add(elementSelector.apply(o));
                }
                map.put(key, list);
            }
        }
        finally {
            os.close();
        }
        return new LookupImpl<TKey, TElement>(map);
    }

    public static <TSource, TKey, TElement> Lookup<TKey, TElement> toLookup(Enumerable<TSource> source, Function1<TSource, TKey> keySelector, Function1<TSource, TElement> elementSelector, EqualityComparer<TKey> comparer) {
        return EnumerableDefaults.toLookup_(new WrapMap(comparer), source, keySelector, elementSelector);
    }

    public static <TSource> Enumerable<TSource> union(Enumerable<TSource> source0, Enumerable<TSource> source1) {
        HashSet set = new HashSet();
        source0.into(set);
        source1.into(set);
        return Linq4j.asEnumerable(set);
    }

    public static <TSource> Enumerable<TSource> union(Enumerable<TSource> source0, Enumerable<TSource> source1, EqualityComparer<TSource> comparer) {
        if (comparer == Functions.identityComparer()) {
            return EnumerableDefaults.union(source0, source1);
        }
        HashSet set = new HashSet();
        Function1<TSource, Wrapped<TSource>> wrapper = EnumerableDefaults.wrapperFor(comparer);
        Function1<Wrapped<TSource>, TSource> unwrapper = EnumerableDefaults.unwrapper();
        source0.select(wrapper).into(set);
        source1.select(wrapper).into(set);
        return Linq4j.asEnumerable(set).select(unwrapper);
    }

    private static <TSource> Function1<Wrapped<TSource>, TSource> unwrapper() {
        return new Function1<Wrapped<TSource>, TSource>(){

            @Override
            public TSource apply(Wrapped<TSource> a0) {
                return a0.element;
            }
        };
    }

    private static <TSource> Function1<TSource, Wrapped<TSource>> wrapperFor(final EqualityComparer<TSource> comparer) {
        return new Function1<TSource, Wrapped<TSource>>(){

            @Override
            public Wrapped<TSource> apply(TSource a0) {
                return Wrapped.upAs(comparer, a0);
            }
        };
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate1<TSource> predicate) {
        assert (predicate != null);
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                final Enumerator enumerator = source.enumerator();
                return new Enumerator<TSource>(){

                    @Override
                    public TSource current() {
                        return enumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (enumerator.moveNext()) {
                            if (!predicate.apply(enumerator.current())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void reset() {
                        enumerator.reset();
                    }

                    @Override
                    public void close() {
                        enumerator.close();
                    }
                };
            }
        };
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate2<TSource, Integer> predicate) {
        return new AbstractEnumerable<TSource>(){

            @Override
            public Enumerator<TSource> enumerator() {
                return new Enumerator<TSource>(){
                    final Enumerator<TSource> enumerator;
                    int n;
                    {
                        this.enumerator = source.enumerator();
                        this.n = -1;
                    }

                    @Override
                    public TSource current() {
                        return this.enumerator.current();
                    }

                    @Override
                    public boolean moveNext() {
                        while (this.enumerator.moveNext()) {
                            ++this.n;
                            if (!predicate.apply(this.enumerator.current(), this.n)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void reset() {
                        this.enumerator.reset();
                        this.n = -1;
                    }

                    @Override
                    public void close() {
                        this.enumerator.close();
                    }
                };
            }
        };
    }

    public static <T0, T1, TResult> Enumerable<TResult> zip(Enumerable<T0> source0, Enumerable<T1> source1, Function2<T0, T1, TResult> resultSelector) {
        throw Extensions.todo();
    }

    public static <T> OrderedQueryable<T> asOrderedQueryable(Enumerable<T> source) {
        return source instanceof OrderedQueryable ? (OrderedQueryable<Object>)source : new EnumerableOrderedQueryable<Object>(source, Object.class, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, C extends Collection<? super T>> C into(Enumerable<T> source, C sink) {
        Enumerator enumerator = source.enumerator();
        try {
            while (enumerator.moveNext()) {
                Object t = enumerator.current();
                sink.add(t);
            }
        }
        finally {
            enumerator.close();
        }
        return sink;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<Wrapped<K>, V> map = new HashMap<Wrapped<K>, V>();
        private final EqualityComparer<K> comparer;

        protected WrapMap(EqualityComparer<K> comparer) {
            this.comparer = comparer;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator iterator = WrapMap.this.map.entrySet().iterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry next = (Map.Entry)iterator.next();
                            return new AbstractMap.SimpleEntry(((Wrapped)next.getKey()).element, next.getValue());
                        }

                        @Override
                        public void remove() {
                            iterator.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return WrapMap.this.map.size();
                }
            };
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.wrap(key));
        }

        private Wrapped<K> wrap(K key) {
            return Wrapped.upAs(this.comparer, key);
        }

        @Override
        public V get(Object key) {
            return this.map.get(this.wrap(key));
        }

        @Override
        public V put(K key, V value) {
            return this.map.put(this.wrap(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(this.wrap(key));
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wrapped<T> {
        private final EqualityComparer<T> comparer;
        private final T element;

        private Wrapped(EqualityComparer<T> comparer, T element) {
            this.comparer = comparer;
            this.element = element;
        }

        static <T> Wrapped<T> upAs(EqualityComparer<T> comparer, T element) {
            return new Wrapped<T>(comparer, element);
        }

        public int hashCode() {
            return this.comparer.hashCode(this.element);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Wrapped && this.comparer.equal(this.element, ((Wrapped)obj).element);
        }

        public T unwrap() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CastingEnumerator<T>
    implements Enumerator<T> {
        private final Enumerator<?> enumerator;
        private final Class<T> clazz;

        public CastingEnumerator(Enumerator<?> enumerator, Class<T> clazz) {
            this.enumerator = enumerator;
            this.clazz = clazz;
        }

        @Override
        public T current() {
            return this.clazz.cast(this.enumerator.current());
        }

        @Override
        public boolean moveNext() {
            return this.enumerator.moveNext();
        }

        @Override
        public void reset() {
            this.enumerator.reset();
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SkipWhileEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Integer> predicate;
        boolean started = false;
        int n = -1;

        public SkipWhileEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Integer> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public TSource current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            do {
                if (!this.enumerator.moveNext()) {
                    return false;
                }
                if (!this.started) continue;
                return true;
            } while (this.predicate.apply(this.enumerator.current(), ++this.n));
            this.started = true;
            return true;
        }

        @Override
        public void reset() {
            this.enumerator.reset();
            this.started = false;
            this.n = -1;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TakeWhileEnumerator<TSource>
    implements Enumerator<TSource> {
        private final Enumerator<TSource> enumerator;
        private final Predicate2<TSource, Integer> predicate;
        boolean done = false;
        int n = -1;

        public TakeWhileEnumerator(Enumerator<TSource> enumerator, Predicate2<TSource, Integer> predicate) {
            this.enumerator = enumerator;
            this.predicate = predicate;
        }

        @Override
        public TSource current() {
            return this.enumerator.current();
        }

        @Override
        public boolean moveNext() {
            if (!this.done) {
                if (this.enumerator.moveNext() && this.predicate.apply(this.enumerator.current(), ++this.n)) {
                    return true;
                }
                this.done = true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.enumerator.reset();
            this.done = false;
            this.n = -1;
        }

        @Override
        public void close() {
            this.enumerator.close();
        }
    }
}

