/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.lambda.functions;

import java.util.Map;
import net.hydromatic.lambda.functions.Mapper;
import net.hydromatic.lambda.functions.Predicate;
import net.hydromatic.linq4j.Linq4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mappers {
    private static final Mapper<Object, Object> IDENTITY = new Mapper<Object, Object>(){

        @Override
        public Object map(Object o) {
            return o;
        }

        @Override
        public <V> Mapper<Object, V> compose(Mapper<? super Object, ? extends V> after) {
            return Mappers.chain(this, after);
        }
    };
    private static final Mapper<Object, String> STRING = new Mapper<Object, String>(){

        @Override
        public String map(Object o) {
            return String.valueOf(o);
        }

        @Override
        public <V> Mapper<Object, V> compose(Mapper<? super String, ? extends V> after) {
            return Mappers.chain(this, after);
        }
    };

    private Mappers() {
        throw new AssertionError();
    }

    public static <T> Mapper<T, T> identity() {
        return IDENTITY;
    }

    public static <T> Mapper<T, String> string() {
        return STRING;
    }

    public static <T, U, V> Mapper<T, V> chain(final Mapper<? super T, ? extends U> first, final Mapper<? super U, ? extends V> second) {
        return new Mapper<T, V>(){

            @Override
            public V map(T t) {
                return second.map(first.map(t));
            }

            @Override
            public <W> Mapper<T, W> compose(Mapper<? super V, ? extends W> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    public static <T, U> Mapper<T, U> constant(final U constant) {
        return new Mapper<T, U>(){

            @Override
            public U map(T t) {
                return constant;
            }

            @Override
            public <V> Mapper<T, V> compose(Mapper<? super U, ? extends V> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    public static <T> Mapper<T, T> substitute(final T subOut, final T subIn) {
        return new Mapper<T, T>(){

            @Override
            public T map(T t) {
                return Linq4j.equals(subOut, t) ? subIn : t;
            }

            @Override
            public <V> Mapper<T, V> compose(Mapper<? super T, ? extends V> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    public static <T, U> Mapper<T, U> instantiate(Class<? extends T> clazzT, Class<? extends U> clazzU) {
        throw new UnsupportedOperationException();
    }

    public static <T, U> Mapper<T, U> forMap(final Map<? super T, ? extends U> map) {
        return new Mapper<T, U>(){

            @Override
            public U map(T t) {
                if (map.containsKey(t)) {
                    return map.get(t);
                }
                throw new IllegalArgumentException("unmappable <T> : " + t);
            }

            @Override
            public <V> Mapper<T, V> compose(Mapper<? super U, ? extends V> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    public static <T, U> Mapper<T, U> forMap(final Map<? super T, ? extends U> map, final U defaultValue) {
        return new Mapper<T, U>(){

            @Override
            public U map(T t) {
                return map.containsKey(t) ? map.get(t) : defaultValue;
            }

            @Override
            public <V> Mapper<T, V> compose(Mapper<? super U, ? extends V> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    public static <T, U> Mapper<T, U> forPredicate(final Predicate<? super T> predicate, final U forTrue, final U forFalse) {
        return new Mapper<T, U>(){

            @Override
            public U map(T t) {
                return predicate.test(t) ? forTrue : forFalse;
            }

            @Override
            public <V> Mapper<T, V> compose(Mapper<? super U, ? extends V> after) {
                return Mappers.chain(this, after);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractMapper<T, R>
    implements Mapper<T, R> {
        @Override
        public <V> Mapper<T, V> compose(Mapper<? super R, ? extends V> after) {
            return Mappers.chain(this, after);
        }
    }
}

