/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.lambda.functions;

import net.hydromatic.lambda.functions.Block;
import net.hydromatic.linq4j.Linq4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Blocks {
    private static final Block<Object> NOP = new Block<Object>(){

        @Override
        public void apply(Object o) {
        }

        @Override
        public Block<Object> chain(Block<? super Object> second) {
            return Blocks.chain(this, second);
        }
    };
    private static final Block<Object> REQUIRE_NON_NULL = new Block<Object>(){

        @Override
        public void apply(Object o) {
            Linq4j.requireNonNull(o);
        }

        @Override
        public Block<Object> chain(Block<? super Object> second) {
            return Blocks.chain(this, second);
        }
    };

    private Blocks() {
        throw new AssertionError();
    }

    public static <T> Block<T> nop() {
        return NOP;
    }

    public static <T> Block<T> requireNonNull() {
        return REQUIRE_NON_NULL;
    }

    public static <T> Block<T> chain(final Block<? super T> first, final Block<? super T> second) {
        return new Block<T>(){

            @Override
            public void apply(T t) {
                first.apply(t);
                second.apply(t);
            }

            @Override
            public Block<T> chain(Block<? super T> second2) {
                return Blocks.chain(this, second2);
            }
        };
    }

    public static <T> Block<T> chain(final Block<? super T> ... sequence) {
        return new Block<T>(){

            @Override
            public void apply(T t) {
                for (Block block : sequence) {
                    block.apply(t);
                }
            }

            @Override
            public Block<T> chain(Block<? super T> second) {
                return Blocks.chain(this, second);
            }
        };
    }

    public static <T> Block<T> chain(final Iterable<? extends Block<? super T>> sequence) {
        return new Block<T>(){

            @Override
            public void apply(T t) {
                for (Block block : sequence) {
                    block.apply(t);
                }
            }

            @Override
            public Block<T> chain(Block<? super T> second) {
                return Blocks.chain(this, second);
            }
        };
    }
}

