/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.http.ICommonParameterProvider;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.IPluginUtils;

public class PluginUtils
implements IPluginUtils {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String pluginName;
    private File pluginDirectory;

    public File getPluginDirectory() {
        return this.pluginDirectory;
    }

    public void setPluginDirectory(File pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public PluginUtils() {
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.logger.error((Object)("Can't initialize PluginUtils: " + Util.getExceptionDescription((Exception)e)));
        }
    }

    public void initialize() throws IOException, DocumentException {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        List pluginResource = resLoader.findResources(this.getClass(), "plugin.xml");
        if (pluginResource.isEmpty()) {
            throw new IOException("plugin.xml required but not found");
        }
        URL pluginUrl = (URL)pluginResource.get(0);
        File pluginDir = new File(pluginUrl.getFile()).getParentFile();
        this.setPluginName(pluginDir.getName());
        this.setPluginDirectory(pluginDir);
        this.logger.debug((Object)("Found resource? " + pluginResource.size()));
    }

    public Collection<File> getPluginResources(String elementPath, Boolean recursive, String pattern) {
        IOFileFilter fileFilter = TrueFileFilter.TRUE;
        if (pattern != null && !pattern.equals("")) {
            fileFilter = new RegexFileFilter(pattern);
        }
        IOFileFilter dirFilter = recursive.equals(Boolean.TRUE) ? TrueFileFilter.TRUE : null;
        String basePath = null;
        String elementFullPath = null;
        try {
            basePath = URLDecoder.decode(FilenameUtils.normalize((String)this.getPluginDirectory().getAbsolutePath()), CharsetHelper.getEncoding());
            elementFullPath = URLDecoder.decode(FilenameUtils.normalize((String)(basePath + File.separator + elementPath)), CharsetHelper.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (!elementFullPath.startsWith(basePath)) {
            this.logger.warn((Object)("PluginUtils.getPluginResources is trying to access a parent path - denied : " + elementFullPath));
            return null;
        }
        File dir = new File(elementFullPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public String getPluginRelativeDirectory(String fullPath, boolean includePluginDir) throws FileNotFoundException {
        File pluginDir = this.getPluginDirectory();
        if (includePluginDir) {
            pluginDir = pluginDir.getParentFile();
        }
        String basePath = null;
        String elementFullPath = null;
        try {
            basePath = URLDecoder.decode(FilenameUtils.normalize((String)pluginDir.getAbsolutePath()), CharsetHelper.getEncoding());
            elementFullPath = URLDecoder.decode(FilenameUtils.getFullPath((String)FilenameUtils.normalize((String)fullPath)), CharsetHelper.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (elementFullPath.indexOf(basePath) < 0) {
            throw new FileNotFoundException("Can't extract relative path from file " + fullPath);
        }
        return elementFullPath.substring(basePath.length());
    }

    public Collection<File> getPluginResources(String elementPath, Boolean recursive) {
        return this.getPluginResources(elementPath, recursive, null);
    }

    public Collection<File> getPluginResources(String elementPath, String pattern) {
        return this.getPluginResources(elementPath, false, pattern);
    }

    public void setResponseHeaders(Map<String, ICommonParameterProvider> parameterProviders, String mimeType) {
        this.setResponseHeaders(parameterProviders, mimeType, 0, null, 0L);
    }

    public void setResponseHeaders(Map<String, ICommonParameterProvider> parameterProviders, String mimeType, String attachmentName) {
        this.setResponseHeaders(parameterProviders, mimeType, 0, attachmentName, 0L);
    }

    public void setResponseHeaders(Map<String, ICommonParameterProvider> parameterProviders, String mimeType, String attachmentName, long attachmentSize) {
        this.setResponseHeaders(parameterProviders, mimeType, 0, attachmentName, attachmentSize);
    }

    public void setResponseHeaders(Map<String, ICommonParameterProvider> parameterProviders, String mimeType, int cacheDuration, String attachmentName, long attachmentSize) {
        HttpServletResponse response = this.getResponse(parameterProviders);
        if (response == null) {
            this.logger.warn((Object)"Parameter 'httpresponse' not found!");
            return;
        }
        if (mimeType != null) {
            response.setHeader("Content-Type", mimeType);
        }
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
        if (attachmentSize > 0L) {
            response.setHeader("Content-Length", String.valueOf(attachmentSize));
        }
        if (cacheDuration > 0) {
            response.setHeader("Cache-Control", "max-age=" + cacheDuration);
        } else {
            response.setHeader("Cache-Control", "max-age=0, no-store");
        }
    }

    public static void copyParametersFromProvider(Map<String, Object> params, ICommonParameterProvider provider) {
        Iterator paramNames = provider.getParameterNames();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            params.put(paramName, provider.getParameter(paramName));
        }
    }

    public void redirect(Map<String, ICommonParameterProvider> parameterProviders, String url) {
        HttpServletResponse response = this.getResponse(parameterProviders);
        if (response == null) {
            this.logger.error((Object)"response not found");
            return;
        }
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            this.logger.error((Object)"could not redirect", (Throwable)e);
        }
    }

    public HttpServletRequest getRequest(Map<String, ICommonParameterProvider> parameterProviders) {
        return (HttpServletRequest)parameterProviders.get("path").getParameter("httprequest");
    }

    public HttpServletResponse getResponse(Map<String, ICommonParameterProvider> parameterProviders) {
        return (HttpServletResponse)parameterProviders.get("path").getParameter("httpresponse");
    }

    public ICommonParameterProvider getRequestParameters(Map<String, ICommonParameterProvider> parameterProviders) {
        return parameterProviders.get("request");
    }

    public ICommonParameterProvider getPathParameters(Map<String, ICommonParameterProvider> parameterProviders) {
        return parameterProviders.get("path");
    }

    public OutputStream getResponseOutputStream(Map<String, ICommonParameterProvider> parameterProviders) throws IOException {
        return this.getResponse(parameterProviders).getOutputStream();
    }

    public OutputStream getOutputStream(Map<String, ICommonParameterProvider> map) throws IOException {
        return this.getResponseOutputStream(map);
    }
}

