/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.messaging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.JAXRSPluginServlet;
import org.springframework.beans.factory.ListableBeanFactory;
import pt.webdetails.cpf.ClassLoaderAwareCaller;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.messaging.MockHttpServletRequest;
import pt.webdetails.cpf.messaging.MockHttpServletResponse;
import pt.webdetails.cpf.plugincall.api.IPluginCall;

public class BeanyPluginCall
implements IPluginCall {
    private static final Log logger = LogFactory.getLog(BeanyPluginCall.class);
    protected String pluginId;
    protected String servicePath;
    protected String methodPath;
    protected String method = "GET";
    protected byte[] contents;

    public BeanyPluginCall(String pluginId, String servicePath, String methodPath) {
        this.pluginId = pluginId;
        this.servicePath = servicePath;
        this.methodPath = methodPath;
    }

    private static JAXRSPluginServlet getApiBean(String pluginId) {
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        ListableBeanFactory beanFactory = pluginManager.getBeanFactory(pluginId);
        if (beanFactory == null) {
            if (pluginManager.getClassLoader(pluginId) == null) {
                logger.error((Object)("No such plugin: " + pluginId));
            } else {
                logger.error((Object)("No bean factory for plugin: " + pluginId));
            }
            return null;
        }
        if (!beanFactory.containsBean("api")) {
            logger.error((Object)("'api' bean not found in " + pluginId));
            return null;
        }
        return (JAXRSPluginServlet)beanFactory.getBean("api", JAXRSPluginServlet.class);
    }

    private IPluginManager getPluginManager() {
        return (IPluginManager)PentahoSystem.get(IPluginManager.class);
    }

    private void runThroughService(Map<String, String[]> params) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String path = Util.joinPath((String[])new String[]{"/", this.pluginId, "api", this.servicePath, this.methodPath});
        final JAXRSPluginServlet pluginServlet = BeanyPluginCall.getApiBean(this.pluginId);
        final MockHttpServletRequest request = new MockHttpServletRequest(path, params);
        final MockHttpServletResponse response = new MockHttpServletResponse((OutputStream)outputStream);
        ClassLoaderAwareCaller caller = new ClassLoaderAwareCaller(this.getPluginManager().getClassLoader(this.pluginId));
        caller.callInClassLoader(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                pluginServlet.service((HttpServletRequest)request, (HttpServletResponse)response);
                return null;
            }
        });
        this.contents = outputStream.toByteArray();
    }

    Callable<String> asCallable(final Map<String, String[]> parameters) {
        return new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BeanyPluginCall.this.call(parameters);
            }
        };
    }

    Runnable asRunnable(final Map<String, String[]> parameters) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BeanyPluginCall.this.run(parameters);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        };
    }

    public String call(Map<String, String[]> params) throws Exception {
        this.runThroughService(params);
        return Util.toString((InputStream)this.getResult());
    }

    public void run(Map<String, String[]> params) throws Exception {
        this.runThroughService(params);
    }

    public InputStream getResult() {
        if (this.contents == null) {
            return null;
        }
        return new ByteArrayInputStream(this.contents);
    }

    public boolean exists() {
        return BeanyPluginCall.getApiBean(this.pluginId) != null;
    }
}

