/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import pt.webdetails.cpf.packager.dependencies.Selector;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CSSMin {
    protected static boolean bDebug = false;

    public static void formatFile(InputStream input, OutputStream out) {
        CSSMin.formatFile(input, new PrintStream(out));
    }

    public static void formatFile(InputStream input, PrintStream out) {
        try {
            int k;
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(input, CharsetHelper.getEncoding()));
            StringBuffer sb = new StringBuffer();
            if (bDebug) {
                System.err.println("Removing extraneous whitespace...");
            }
            while ((s = br.readLine()) != null) {
                if (s.trim().equals("")) continue;
                sb.append(s.replaceAll("[\t\n\r]", "").replaceAll("  ", " "));
            }
            if (bDebug) {
                System.err.println("Removing comments...");
            }
            int n = 0;
            while ((n = sb.indexOf("/*", n)) != -1) {
                if (sb.charAt(n + 2) == '*') {
                    n += 2;
                    continue;
                }
                k = sb.indexOf("*/", n + 2);
                if (k == -1) {
                    throw new Exception("Unterminated comment. Aborting.");
                }
                sb.delete(n, k + 2);
            }
            if (bDebug) {
                System.err.println("Parsing and processing selectors...");
            }
            Vector<Selector> selectors = new Vector<Selector>();
            n = 0;
            while ((k = sb.indexOf("}", n)) != -1) {
                try {
                    selectors.addElement(new Selector(sb.substring(n, k + 1)));
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                n = k + 1;
            }
            for (Selector selector : selectors) {
                out.print(selector.toString());
            }
            out.print("\r\n");
            out.close();
            if (bDebug) {
                System.err.println("Process completed successfully.");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

