/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hcatalog.mapreduce.HCatSplit;

public class SqoopHCatInputSplit
extends InputSplit
implements Writable {
    private List<HCatSplit> hCatSplits;
    private String[] hCatLocations;
    private long inputLength;

    public SqoopHCatInputSplit() {
    }

    public SqoopHCatInputSplit(List<InputSplit> splits) {
        this.hCatSplits = new ArrayList<HCatSplit>();
        HashSet<String> locations = new HashSet<String>();
        for (int i = 0; i < splits.size(); ++i) {
            HCatSplit hsSplit = (HCatSplit)splits.get(i);
            this.hCatSplits.add(hsSplit);
            this.inputLength += hsSplit.getLength();
            locations.addAll(Arrays.asList(hsSplit.getLocations()));
        }
        this.hCatLocations = locations.toArray(new String[0]);
    }

    public int length() {
        return this.hCatSplits.size();
    }

    public HCatSplit get(int index) {
        return this.hCatSplits.get(index);
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.inputLength == 0L) {
            for (HCatSplit split : this.hCatSplits) {
                this.inputLength += split.getLength();
            }
        }
        return this.inputLength;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.hCatLocations == null) {
            HashSet<String> locations = new HashSet<String>();
            for (HCatSplit split : this.hCatSplits) {
                locations.addAll(Arrays.asList(split.getLocations()));
            }
            this.hCatLocations = locations.toArray(new String[0]);
        }
        return this.hCatLocations;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.inputLength);
        out.writeInt(this.hCatSplits.size());
        for (HCatSplit split : this.hCatSplits) {
            split.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.inputLength = in.readLong();
        int size = in.readInt();
        this.hCatSplits = new ArrayList<HCatSplit>(size);
        for (int i = 0; i < size; ++i) {
            HCatSplit hs = new HCatSplit();
            hs.readFields(in);
            this.hCatSplits.add(hs);
        }
    }
}

