/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.db;

import com.cloudera.sqoop.mapreduce.db.DBInputFormat;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sqoop.mapreduce.DBWritable;

public class DBConfiguration {
    public static final Log LOG = LogFactory.getLog((String)DBConfiguration.class.getName());
    public static final String DRIVER_CLASS_PROPERTY = "mapreduce.jdbc.driver.class";
    public static final String URL_PROPERTY = "mapreduce.jdbc.url";
    public static final String USERNAME_PROPERTY = "mapreduce.jdbc.username";
    public static final String PASSWORD_PROPERTY = "mapreduce.jdbc.password";
    private static final Text PASSWORD_SECRET_KEY = new Text("mapreduce.jdbc.password");
    public static final String CONNECTION_PARAMS_PROPERTY = "mapreduce.jdbc.params";
    public static final String FETCH_SIZE = "mapreduce.jdbc.fetchsize";
    public static final String INPUT_TABLE_NAME_PROPERTY = "mapreduce.jdbc.input.table.name";
    public static final String INPUT_FIELD_NAMES_PROPERTY = "mapreduce.jdbc.input.field.names";
    public static final String INPUT_CONDITIONS_PROPERTY = "mapreduce.jdbc.input.conditions";
    public static final String INPUT_ORDER_BY_PROPERTY = "mapreduce.jdbc.input.orderby";
    public static final String INPUT_QUERY = "mapreduce.jdbc.input.query";
    public static final String INPUT_COUNT_QUERY = "mapreduce.jdbc.input.count.query";
    public static final String INPUT_BOUNDING_QUERY = "mapred.jdbc.input.bounding.query";
    public static final String INPUT_CLASS_PROPERTY = "mapreduce.jdbc.input.class";
    public static final String OUTPUT_TABLE_NAME_PROPERTY = "mapreduce.jdbc.output.table.name";
    public static final String OUTPUT_FIELD_NAMES_PROPERTY = "mapreduce.jdbc.output.field.names";
    public static final String OUTPUT_FIELD_COUNT_PROPERTY = "mapreduce.jdbc.output.field.count";
    private Configuration conf;

    public static void configureDB(Configuration conf, String driverClass, String dbUrl, String userName, String passwd, Integer fetchSize, Properties connectionParams) {
        conf.set(DRIVER_CLASS_PROPERTY, driverClass);
        conf.set(URL_PROPERTY, dbUrl);
        if (userName != null) {
            conf.set(USERNAME_PROPERTY, userName);
        }
        if (passwd != null) {
            DBConfiguration.setPassword((JobConf)conf, passwd);
        }
        if (fetchSize != null) {
            conf.setInt(FETCH_SIZE, fetchSize.intValue());
        }
        if (connectionParams != null) {
            conf.set(CONNECTION_PARAMS_PROPERTY, DBConfiguration.propertiesToString(connectionParams));
        }
    }

    private static void setPassword(JobConf configuration, String password) {
        LOG.debug((Object)"Securing password into job credentials store");
        configuration.getCredentials().addSecretKey(PASSWORD_SECRET_KEY, password.getBytes());
    }

    public static void configureDB(Configuration job, String driverClass, String dbUrl, Integer fetchSize, Properties connectionParams) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, null, null, fetchSize, connectionParams);
    }

    public static void configureDB(Configuration conf, String driverClass, String dbUrl, String userName, String passwd, Properties connectionParams) {
        DBConfiguration.configureDB(conf, driverClass, dbUrl, userName, passwd, null, connectionParams);
    }

    public static void configureDB(Configuration job, String driverClass, String dbUrl, Properties connectionParams) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, null, connectionParams);
    }

    public static void configureDB(Configuration conf, String driverClass, String dbUrl, String userName, String passwd, Integer fetchSize) {
        DBConfiguration.configureDB(conf, driverClass, dbUrl, userName, passwd, fetchSize, null);
    }

    public static void configureDB(Configuration job, String driverClass, String dbUrl, Integer fetchSize) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, fetchSize, (Properties)null);
    }

    public static void configureDB(Configuration conf, String driverClass, String dbUrl, String userName, String passwd) {
        DBConfiguration.configureDB(conf, driverClass, dbUrl, userName, passwd, (Properties)null);
    }

    public static void configureDB(Configuration job, String driverClass, String dbUrl) {
        DBConfiguration.configureDB(job, driverClass, dbUrl, (Properties)null);
    }

    public DBConfiguration(Configuration job) {
        this.conf = job;
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        Connection connection;
        Class.forName(this.conf.get(DRIVER_CLASS_PROPERTY));
        String username = this.conf.get(USERNAME_PROPERTY);
        String password = DBConfiguration.getPassword((JobConf)this.conf);
        String connectString = this.conf.get(URL_PROPERTY);
        String connectionParamsStr = this.conf.get(CONNECTION_PARAMS_PROPERTY);
        Properties connectionParams = DBConfiguration.propertiesFromString(connectionParamsStr);
        if (connectionParams != null && connectionParams.size() > 0) {
            Properties props = new Properties();
            if (username != null) {
                props.put("user", username);
            }
            if (password != null) {
                props.put("password", password);
            }
            props.putAll((Map<?, ?>)connectionParams);
            connection = DriverManager.getConnection(connectString, props);
        } else {
            connection = username == null ? DriverManager.getConnection(connectString) : DriverManager.getConnection(connectString, username, password);
        }
        return connection;
    }

    public static String getPassword(JobConf configuration) {
        LOG.debug((Object)"Fetching password from job credentials store");
        byte[] secret = configuration.getCredentials().getSecretKey(PASSWORD_SECRET_KEY);
        return secret != null ? new String(secret) : null;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public Integer getFetchSize() {
        if (this.conf.get(FETCH_SIZE) == null) {
            return null;
        }
        return this.conf.getInt(FETCH_SIZE, 0);
    }

    public void setFetchSize(Integer fetchSize) {
        if (fetchSize != null) {
            this.conf.setInt(FETCH_SIZE, fetchSize.intValue());
        } else {
            this.conf.set(FETCH_SIZE, null);
        }
    }

    public String getInputTableName() {
        return this.conf.get(INPUT_TABLE_NAME_PROPERTY);
    }

    public void setInputTableName(String tableName) {
        this.conf.set(INPUT_TABLE_NAME_PROPERTY, tableName);
    }

    public String[] getInputFieldNames() {
        return this.conf.getStrings(INPUT_FIELD_NAMES_PROPERTY);
    }

    public void setInputFieldNames(String ... fieldNames) {
        this.conf.setStrings(INPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }

    public String getInputConditions() {
        return this.conf.get(INPUT_CONDITIONS_PROPERTY);
    }

    public void setInputConditions(String conditions) {
        if (conditions != null && conditions.length() > 0) {
            this.conf.set(INPUT_CONDITIONS_PROPERTY, conditions);
        }
    }

    public String getInputOrderBy() {
        return this.conf.get(INPUT_ORDER_BY_PROPERTY);
    }

    public void setInputOrderBy(String orderby) {
        if (orderby != null && orderby.length() > 0) {
            this.conf.set(INPUT_ORDER_BY_PROPERTY, orderby);
        }
    }

    public String getInputQuery() {
        return this.conf.get(INPUT_QUERY);
    }

    public void setInputQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_QUERY, query);
        }
    }

    public String getInputCountQuery() {
        return this.conf.get(INPUT_COUNT_QUERY);
    }

    public void setInputCountQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_COUNT_QUERY, query);
        }
    }

    public void setInputBoundingQuery(String query) {
        if (query != null && query.length() > 0) {
            this.conf.set(INPUT_BOUNDING_QUERY, query);
        }
    }

    public String getInputBoundingQuery() {
        return this.conf.get(INPUT_BOUNDING_QUERY);
    }

    public Class<?> getInputClass() {
        return this.conf.getClass(INPUT_CLASS_PROPERTY, DBInputFormat.NullDBWritable.class);
    }

    public void setInputClass(Class<? extends DBWritable> inputClass) {
        this.conf.setClass(INPUT_CLASS_PROPERTY, inputClass, DBWritable.class);
    }

    public String getOutputTableName() {
        return this.conf.get(OUTPUT_TABLE_NAME_PROPERTY);
    }

    public void setOutputTableName(String tableName) {
        this.conf.set(OUTPUT_TABLE_NAME_PROPERTY, tableName);
    }

    public String[] getOutputFieldNames() {
        return this.conf.getStrings(OUTPUT_FIELD_NAMES_PROPERTY);
    }

    public void setOutputFieldNames(String ... fieldNames) {
        this.conf.setStrings(OUTPUT_FIELD_NAMES_PROPERTY, fieldNames);
    }

    public void setOutputFieldCount(int fieldCount) {
        this.conf.setInt(OUTPUT_FIELD_COUNT_PROPERTY, fieldCount);
    }

    public int getOutputFieldCount() {
        return this.conf.getInt(OUTPUT_FIELD_COUNT_PROPERTY, 0);
    }

    protected static String propertiesToString(Properties properties) {
        ArrayList<String> propertiesList = new ArrayList<String>(properties.size());
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String val;
            String key = StringEscapeUtils.escapeCsv((String)property.getKey().toString());
            if (key.equals(property.getKey().toString()) && key.contains("=")) {
                key = "\"" + key + "\"";
            }
            if ((val = StringEscapeUtils.escapeCsv((String)property.getValue().toString())).equals(property.getValue().toString()) && val.contains("=")) {
                val = "\"" + val + "\"";
            }
            propertiesList.add(StringEscapeUtils.escapeCsv((String)(key + "=" + val)));
        }
        return StringUtils.join(propertiesList, (char)',');
    }

    protected static Properties propertiesFromString(String input) {
        if (input != null && !input.isEmpty()) {
            Properties result = new Properties();
            StrTokenizer propertyTokenizer = StrTokenizer.getCSVInstance((String)input);
            StrTokenizer valueTokenizer = StrTokenizer.getCSVInstance();
            valueTokenizer.setDelimiterChar('=');
            while (propertyTokenizer.hasNext()) {
                valueTokenizer.reset(propertyTokenizer.nextToken());
                String[] values = valueTokenizer.getTokenArray();
                if (values.length != 2) continue;
                result.put(values[0], values[1]);
            }
            return result;
        }
        return null;
    }
}

