/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.InformationSchemaManager;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerExportBatchOutputFormat;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerInputFormat;

public class SQLServerManager
extends InformationSchemaManager {
    public static final String SCHEMA = "schema";
    public static final String TABLE_HINTS = "table-hints";
    public static final String TABLE_HINTS_PROP = "org.apache.sqoop.manager.sqlserver.table.hints";
    public static final Log LOG = LogFactory.getLog((String)SQLServerManager.class.getName());
    private static final String DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final int DATETIMEOFFSET = -155;
    private String schema;
    private String tableHints;

    public SQLServerManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
        try {
            this.parseExtraArgs(opts.getExtraArgs());
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't parse extra arguments", e);
        }
    }

    @Override
    public String toJavaType(int sqlType) {
        String javaType = sqlType == -155 ? "String" : super.toJavaType(sqlType);
        return javaType;
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        context.setInputFormat(SqlServerInputFormat.class);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, SqlServerExportBatchOutputFormat.class);
        exportJob.runExport();
    }

    @Override
    public String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT NAME FROM SYS.DATABASES";
    }

    @Override
    protected String getSchemaQuery() {
        if (this.schema == null) {
            return "SELECT SCHEMA_NAME()";
        }
        return "'" + this.schema + "'";
    }

    @Override
    protected String getListColumnsQuery(String tableName) {
        return super.getListColumnsQuery(tableName) + "  ORDER BY ORDINAL_POSITION";
    }

    @Override
    public String escapeColName(String colName) {
        return this.escapeObjectName(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        if (this.schema != null && !this.schema.isEmpty()) {
            return this.escapeObjectName(this.schema) + "." + this.escapeObjectName(tableName);
        }
        return this.escapeObjectName(tableName);
    }

    @Override
    public boolean escapeTableNameOnExport() {
        return true;
    }

    public String escapeObjectName(String objectName) {
        if (null == objectName) {
            return null;
        }
        return "[" + objectName + "]";
    }

    void parseExtraArgs(String[] args) throws ParseException {
        if (args == null || args.length == 0) {
            return;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = parser.parse((Options)this.getExtraOptions(), args, true);
        if (cmdLine.hasOption(SCHEMA)) {
            String schemaName = cmdLine.getOptionValue(SCHEMA);
            LOG.info((Object)("We will use schema " + schemaName));
            this.schema = schemaName;
        }
        if (cmdLine.hasOption(TABLE_HINTS)) {
            String hints = cmdLine.getOptionValue(TABLE_HINTS);
            LOG.info((Object)("Sqoop will use following table hints for data transfer: " + hints));
            this.tableHints = hints;
        }
    }

    private RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = new RelatedOptions("SQL Server extra options:");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional schema name");
        OptionBuilder.withLongOpt((String)SCHEMA);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional table hints to use");
        OptionBuilder.withLongOpt((String)TABLE_HINTS);
        extraOptions.addOption(OptionBuilder.create());
        return extraOptions;
    }
}

