/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.hcat;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.util.ExitSecurityException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.DefaultStringifier;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hcatalog.common.HCatConstants;
import org.apache.hcatalog.data.DefaultHCatRecord;
import org.apache.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hcatalog.data.schema.HCatSchema;
import org.apache.hcatalog.mapreduce.HCatInputFormat;
import org.apache.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hcatalog.mapreduce.OutputJobInfo;
import org.apache.sqoop.hive.HiveTypes;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatExportFormat;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatExportMapper;
import org.apache.sqoop.mapreduce.hcat.SqoopHCatImportMapper;
import org.apache.sqoop.util.Executor;
import org.apache.sqoop.util.LoggingAsyncSink;
import org.apache.sqoop.util.SubprocessSecurityManager;

public final class SqoopHCatUtilities {
    public static final String DEFHCATDB = "default";
    public static final String HIVESITEXMLPATH = "/conf/hive-site.xml";
    public static final String HCATSHAREDIR = "share/hcatalog";
    public static final String DEFLIBDIR = "lib";
    public static final String TEXT_FORMAT_IF_CLASS = "org.apache.hadoop.mapred.TextInputFormat";
    public static final String TEXT_FORMAT_OF_CLASS = "org.apache.hadoop.mapred.TextOutputFormat";
    public static final String TEXT_FORMAT_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    public static final String HCAT_DB_OUTPUT_COLTYPES_JAVA = "sqoop.hcat.db.output.coltypes.java";
    public static final String HCAT_DB_OUTPUT_COLTYPES_SQL = "sqoop.hcat.db.output.coltypes.sql";
    public static final String HCAT_CLI_MAIN_CLASS = "org.apache.hcatalog.cli.HCatCli";
    public static final String HCAT_DEF_STORAGE_STANZA = "stored as rcfile";
    public static final String HIVE_DELIMITERS_TO_REPLACE_PROP = "sqoop.hive.delims.to.replace";
    public static final String HIVE_DELIMITERS_REPLACEMENT_PROP = "sqoop.hive.delims.replacement";
    public static final String HIVE_DELIMITERS_REPLACEMENT_ENABLED_PROP = "sqoop.hive.delims.replacement.enabled";
    public static final String HCAT_STATIC_PARTITION_KEY_PROP = "sqoop.hcat.partition.key";
    public static final String HCAT_FIELD_POSITIONS_PROP = "sqoop.hcat.field.positions";
    public static final String DEBUG_HCAT_IMPORT_MAPPER_PROP = "sqoop.hcat.debug.import.mapper";
    public static final String DEBUG_HCAT_EXPORT_MAPPER_PROP = "sqoop.hcat.debug.export.mapper";
    private static final String HCATCMD = Shell.WINDOWS ? "hcat.py" : "hcat";
    private SqoopOptions options;
    private ConnManager connManager;
    private String hCatTableName;
    private String hCatDatabaseName;
    private Configuration configuration;
    private Job hCatJob;
    private HCatSchema hCatOutputSchema;
    private HCatSchema hCatPartitionSchema;
    private HCatSchema projectedSchema;
    private boolean configured = false;
    private String hCatQualifiedTableName;
    private String hCatStaticPartitionKey;
    private List<String> hCatDynamicPartitionKeys;
    private String[] dbColumnNames;
    private String dbTableName;
    private LCKeyMap<Integer> dbColumnTypes;
    private Map<String, Integer> externalColTypes;
    private int[] hCatFieldPositions;
    private HCatSchema hCatFullTableSchema;
    private List<String> hCatFullTableSchemaFieldNames;
    private LCKeyMap<String> userHiveMapping;
    private static Class<? extends InputFormat> inputFormatClass = SqoopHCatExportFormat.class;
    private static Class<? extends OutputFormat> outputFormatClass = HCatOutputFormat.class;
    private static Class<? extends Mapper> exportMapperClass = SqoopHCatExportMapper.class;
    private static Class<? extends Mapper> importMapperClass = SqoopHCatImportMapper.class;
    private static Class<? extends Writable> importValueClass = DefaultHCatRecord.class;
    private static boolean testMode = false;
    public static final Log LOG = LogFactory.getLog((String)SqoopHCatUtilities.class.getName());

    public static SqoopHCatUtilities instance() {
        return Holder.INSTANCE;
    }

    private SqoopHCatUtilities() {
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public void configureHCat(SqoopOptions opts, Job job, ConnManager connMgr, String dbTable, Configuration config) throws IOException {
        if (this.configured) {
            LOG.info((Object)"Ignoring configuration request for HCatalog info");
            return;
        }
        this.options = opts;
        LOG.info((Object)"Configuring HCatalog specific details for job");
        String home = opts.getHiveHome();
        if (home == null || home.length() == 0) {
            LOG.warn((Object)("Hive home is not set. job may fail if needed jar files are not found correctly.  Please set HIVE_HOME in sqoop-env.sh or provide --hive-home option.  Setting HIVE_HOME  to " + SqoopOptions.getHiveHomeDefault()));
        }
        if ((home = opts.getHCatHome()) == null || home.length() == 0) {
            LOG.warn((Object)("HCatalog home is not set. job may fail if needed jar files are not found correctly.  Please set HCAT_HOME in sqoop-env.sh or provide --hcatalog-home option.   Setting HCAT_HOME to " + SqoopOptions.getHCatHomeDefault()));
        }
        this.connManager = connMgr;
        this.dbTableName = dbTable;
        this.configuration = config;
        this.hCatJob = job;
        this.hCatDatabaseName = this.options.getHCatDatabaseName() != null ? this.options.getHCatDatabaseName() : DEFHCATDB;
        this.hCatDatabaseName = this.hCatDatabaseName.toLowerCase();
        String optHCTabName = this.options.getHCatTableName();
        this.hCatTableName = optHCTabName.toLowerCase();
        if (!this.hCatTableName.equals(optHCTabName)) {
            LOG.warn((Object)("Provided HCatalog table name " + optHCTabName + " will be mapped to  " + this.hCatTableName));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.hCatDatabaseName);
        sb.append('.').append(this.hCatTableName);
        this.hCatQualifiedTableName = sb.toString();
        String principalID = System.getProperty(HCatConstants.HCAT_METASTORE_PRINCIPAL);
        if (principalID != null) {
            this.configuration.set(HCatConstants.HCAT_METASTORE_PRINCIPAL, principalID);
        }
        this.hCatStaticPartitionKey = this.options.getHivePartitionKey();
        Properties userMapping = this.options.getMapColumnHive();
        this.userHiveMapping = new LCKeyMap();
        for (Object o : userMapping.keySet()) {
            String v = (String)userMapping.get(o);
            this.userHiveMapping.put((String)o, v);
        }
        Map<String, String> filterMap = this.getHCatSPFilterMap();
        String filterStr = this.getHCatSPFilterStr();
        this.initDBColumnNamesAndTypes();
        if (this.options.doCreateHCatalogTable()) {
            LOG.info((Object)("Creating HCatalog table " + this.hCatQualifiedTableName + " for import"));
            this.createHCatTable();
        }
        HCatInputFormat hif = HCatInputFormat.setInput((Job)this.hCatJob, (String)this.hCatDatabaseName, (String)this.hCatTableName);
        if (filterStr != null) {
            LOG.info((Object)("Setting hCatInputFormat filter to " + filterStr));
            hif.setFilter(filterStr);
        }
        this.hCatFullTableSchema = HCatInputFormat.getTableSchema((Configuration)this.configuration);
        this.hCatFullTableSchemaFieldNames = this.hCatFullTableSchema.getFieldNames();
        LOG.info((Object)("HCatalog full table schema fields = " + Arrays.toString(this.hCatFullTableSchema.getFieldNames().toArray())));
        if (filterMap != null) {
            LOG.info((Object)("Setting hCatOutputFormat filter to " + filterStr));
        }
        HCatOutputFormat.setOutput((Job)this.hCatJob, (OutputJobInfo)OutputJobInfo.create((String)this.hCatDatabaseName, (String)this.hCatTableName, filterMap));
        this.hCatOutputSchema = HCatOutputFormat.getTableSchema((Configuration)this.configuration);
        ArrayList<HCatFieldSchema> hCatPartitionSchemaFields = new ArrayList<HCatFieldSchema>();
        int totalFieldsCount = this.hCatFullTableSchema.size();
        int dataFieldsCount = this.hCatOutputSchema.size();
        if (totalFieldsCount > dataFieldsCount) {
            for (int i = dataFieldsCount; i < totalFieldsCount; ++i) {
                hCatPartitionSchemaFields.add(this.hCatFullTableSchema.get(i));
            }
        }
        this.hCatPartitionSchema = new HCatSchema(hCatPartitionSchemaFields);
        for (HCatFieldSchema hfs : hCatPartitionSchemaFields) {
            if (hfs.getType() == HCatFieldSchema.Type.STRING) continue;
            throw new IOException("The table provided " + this.getQualifiedHCatTableName() + " uses unsupported  partitioning key type  for column " + hfs.getName() + " : " + hfs.getTypeString() + ".  Only string " + "fields are allowed in partition columns in HCatalog");
        }
        LOG.info((Object)("HCatalog table partitioning key fields = " + Arrays.toString(this.hCatPartitionSchema.getFieldNames().toArray())));
        ArrayList<HCatFieldSchema> outputFieldList = new ArrayList<HCatFieldSchema>();
        for (String col : this.dbColumnNames) {
            HCatFieldSchema hfs = this.hCatFullTableSchema.get(col);
            if (hfs == null) {
                throw new IOException("Database column " + col + " not found in " + " hcatalog table.");
            }
            if (this.hCatStaticPartitionKey != null && this.hCatStaticPartitionKey.equals(col)) continue;
            outputFieldList.add(this.hCatFullTableSchema.get(col));
        }
        this.projectedSchema = new HCatSchema(outputFieldList);
        LOG.info((Object)("HCatalog projected schema fields = " + Arrays.toString(this.projectedSchema.getFieldNames().toArray())));
        this.validateStaticPartitionKey();
        this.validateHCatTableFieldTypes();
        HCatOutputFormat.setSchema((Configuration)this.configuration, (HCatSchema)this.hCatFullTableSchema);
        SqoopHCatUtilities.addJars(this.hCatJob, this.options);
        config.setBoolean(DEBUG_HCAT_IMPORT_MAPPER_PROP, Boolean.getBoolean(DEBUG_HCAT_IMPORT_MAPPER_PROP));
        config.setBoolean(DEBUG_HCAT_EXPORT_MAPPER_PROP, Boolean.getBoolean(DEBUG_HCAT_EXPORT_MAPPER_PROP));
        this.configured = true;
    }

    public void validateDynamicPartitionKeysMapping() throws IOException {
        StringBuilder missingKeys = new StringBuilder();
        for (String s : this.hCatDynamicPartitionKeys) {
            boolean found = false;
            for (String c : this.dbColumnNames) {
                if (!s.equals(c)) continue;
                found = true;
                break;
            }
            if (found) continue;
            missingKeys.append(',').append(s);
        }
        if (missingKeys.length() > 0) {
            throw new IOException("Dynamic partition keys are not present in the database columns.   Missing keys = " + missingKeys.substring(1));
        }
    }

    public void validateHCatTableFieldTypes() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean hasComplexFields = false;
        for (HCatFieldSchema hfs : this.projectedSchema.getFields()) {
            if (!hfs.isComplex()) continue;
            sb.append('.').append(hfs.getName());
            hasComplexFields = true;
        }
        if (hasComplexFields) {
            String unsupportedFields = sb.substring(1);
            throw new IOException("The HCatalog table provided " + this.getQualifiedHCatTableName() + " has complex field types (" + unsupportedFields + ").  They are currently not supported");
        }
    }

    private void initDBColumnNamesAndTypes() throws IOException {
        String[] colNames = this.options.getColumns();
        if (null == colNames) {
            if (null != this.externalColTypes) {
                ArrayList<String> keyList = new ArrayList<String>();
                for (String key : this.externalColTypes.keySet()) {
                    keyList.add(key);
                }
                colNames = keyList.toArray(new String[keyList.size()]);
            } else {
                colNames = null != this.dbTableName ? this.connManager.getColumnNames(this.dbTableName) : (this.options.getCall() != null ? this.connManager.getColumnNamesForProcedure(this.options.getCall()) : this.connManager.getColumnNamesForQuery(this.options.getSqlQuery()));
            }
        }
        this.dbColumnNames = new String[colNames.length];
        for (int i = 0; i < colNames.length; ++i) {
            this.dbColumnNames[i] = colNames[i].toLowerCase();
        }
        LCKeyMap<Integer> colTypes = new LCKeyMap<Integer>();
        if (this.externalColTypes != null) {
            colTypes.putAll(this.externalColTypes);
        } else if (this.dbTableName != null) {
            colTypes.putAll(this.connManager.getColumnTypes(this.dbTableName));
        } else if (this.options.getCall() != null) {
            colTypes.putAll(this.connManager.getColumnTypesForProcedure(this.options.getCall()));
        } else {
            colTypes.putAll(this.connManager.getColumnTypesForQuery(this.options.getSqlQuery()));
        }
        if (this.options.getColumns() == null) {
            this.dbColumnTypes = colTypes;
        } else {
            this.dbColumnTypes = new LCKeyMap();
            for (String col : this.dbColumnNames) {
                Integer type = (Integer)colTypes.get(col);
                if (type == null) {
                    throw new IOException("Projected column " + col + " not in list of columns from database");
                }
                this.dbColumnTypes.put(col, type);
            }
        }
        LOG.info((Object)("Database column names projected : " + Arrays.toString(this.dbColumnNames)));
        LOG.info((Object)("Database column name - type map :\n\tNames: " + Arrays.toString(this.dbColumnTypes.keySet().toArray()) + "\n\tTypes : " + Arrays.toString(this.dbColumnTypes.values().toArray())));
    }

    private void createHCatTable() throws IOException {
        String storageStanza;
        StringBuilder sb = new StringBuilder();
        sb.append("create table ").append(this.hCatDatabaseName).append('.');
        sb.append(this.hCatTableName).append(" (\n\t");
        boolean first = true;
        for (String col : this.dbColumnNames) {
            String type = this.userHiveMapping.get(col);
            if (type == null) {
                type = this.connManager.toHCatType(this.dbColumnTypes.get(col));
            }
            if (this.hCatStaticPartitionKey != null && col.equals(this.hCatStaticPartitionKey)) continue;
            if (first) {
                first = false;
            } else {
                sb.append(",\n\t");
            }
            sb.append(col).append(' ').append(type);
        }
        sb.append(")\n");
        if (this.hCatStaticPartitionKey != null) {
            sb.append("partitioned by (\n\t");
            sb.append(this.hCatStaticPartitionKey).append(" string)\n");
        }
        if ((storageStanza = this.options.getHCatStorageStanza()) == null) {
            sb.append(HCAT_DEF_STORAGE_STANZA);
        } else {
            sb.append(storageStanza);
        }
        String createStatement = sb.toString();
        LOG.info((Object)("HCatalog Create table statement: \n\n" + createStatement));
        this.launchHCatCli(createStatement);
    }

    private void validateFieldAndColumnMappings() throws IOException {
        for (String column : this.userHiveMapping.keySet()) {
            boolean found = false;
            for (String c : this.dbColumnNames) {
                if (!c.equalsIgnoreCase(column)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Column " + column + " not found while mapping database columns to hcatalog columns");
        }
        this.hCatFieldPositions = new int[this.dbColumnNames.length];
        Arrays.fill(this.hCatFieldPositions, -1);
        for (int indx = 0; indx < this.dbColumnNames.length; ++indx) {
            HCatFieldSchema hCatFS;
            boolean userMapped = false;
            String col = this.dbColumnNames[indx];
            Integer colType = this.dbColumnTypes.get(col);
            String hCatColType = this.userHiveMapping.get(col);
            if (hCatColType == null) {
                LOG.debug((Object)("No user defined type mapping for HCatalog field " + col));
                hCatColType = this.connManager.toHCatType(colType);
            } else {
                LOG.debug((Object)("Found type mapping for HCatalog filed " + col));
                userMapped = true;
            }
            if (null == hCatColType) {
                throw new IOException("HCat does not support the SQL type for column " + col);
            }
            boolean found = false;
            for (String tf : this.hCatFullTableSchemaFieldNames) {
                if (!tf.equals(col)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("Database column " + col + " not found in " + "hcatalog table schema or partition schema");
            }
            if (!userMapped && !(hCatFS = this.hCatFullTableSchema.get(col)).getTypeString().equals(hCatColType)) {
                LOG.warn((Object)("The HCatalog field " + col + " has type " + hCatFS.getTypeString() + ".  Expected = " + hCatColType + " based on database column type : " + SqoopHCatUtilities.sqlTypeString(colType)));
                LOG.warn((Object)"The Sqoop job can fail if types are not  assignment compatible");
            }
            if (HiveTypes.isHiveTypeImprovised(colType)) {
                LOG.warn((Object)("Column " + col + " had to be cast to a less precise type " + hCatColType + " in hcatalog"));
            }
            this.hCatFieldPositions[indx] = this.hCatFullTableSchemaFieldNames.indexOf(col);
            if (this.hCatFieldPositions[indx] >= 0) continue;
            throw new IOException("The HCatalog field " + col + " could not be found");
        }
        Object[] positions = new IntWritable[this.hCatFieldPositions.length];
        for (int i : this.hCatFieldPositions) {
            positions[i] = new IntWritable(this.hCatFieldPositions[i]);
        }
        DefaultStringifier.storeArray((Configuration)this.configuration, (Object[])positions, (String)HCAT_FIELD_POSITIONS_PROP);
    }

    private String getHCatSPFilterStr() {
        if (this.hCatStaticPartitionKey != null) {
            StringBuilder filter = new StringBuilder();
            filter.append(this.options.getHivePartitionKey()).append('=').append('\'').append(this.options.getHivePartitionValue()).append('\'');
            return filter.toString();
        }
        return null;
    }

    private Map<String, String> getHCatSPFilterMap() {
        if (this.hCatStaticPartitionKey != null) {
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put(this.options.getHivePartitionKey(), this.options.getHivePartitionValue());
            return filter;
        }
        return null;
    }

    private void validateStaticPartitionKey() throws IOException {
        List partFields = this.hCatPartitionSchema.getFields();
        if (this.hCatStaticPartitionKey != null) {
            boolean found = false;
            for (HCatFieldSchema hfs : partFields) {
                if (!hfs.getName().equals(this.hCatStaticPartitionKey)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("The provided hive partition key " + this.hCatStaticPartitionKey + " is not part of the partition " + " keys for table " + this.getQualifiedHCatTableName());
            }
        }
        this.hCatDynamicPartitionKeys = new ArrayList<String>();
        this.hCatDynamicPartitionKeys.addAll(this.hCatPartitionSchema.getFieldNames());
        if (this.hCatStaticPartitionKey != null) {
            this.hCatDynamicPartitionKeys.remove(this.hCatStaticPartitionKey);
        }
        this.configuration.set(HCAT_STATIC_PARTITION_KEY_PROP, this.hCatStaticPartitionKey == null ? "" : this.hCatStaticPartitionKey);
    }

    public static void configureImportOutputFormat(SqoopOptions opts, Job job, ConnManager connMgr, String dbTable, Configuration config) throws IOException {
        LOG.info((Object)"Configuring HCatalog for import job");
        SqoopHCatUtilities.instance().configureHCat(opts, job, connMgr, dbTable, job.getConfiguration());
        LOG.info((Object)"Validating dynamic partition keys");
        SqoopHCatUtilities.instance().validateFieldAndColumnMappings();
        SqoopHCatUtilities.instance().validateDynamicPartitionKeysMapping();
        job.setOutputFormatClass(SqoopHCatUtilities.getOutputFormatClass());
        Object[] delimChars = new IntWritable[5];
        String hiveReplacement = "";
        LOG.debug((Object)"Hive delimiters will be fixed during import");
        DelimiterSet delims = opts.getOutputDelimiters();
        if (!opts.explicitOutputDelims()) {
            delims = DelimiterSet.HIVE_DELIMITERS;
        }
        delimChars = new IntWritable[]{new IntWritable((int)delims.getFieldsTerminatedBy()), new IntWritable((int)delims.getLinesTerminatedBy()), new IntWritable((int)delims.getEnclosedBy()), new IntWritable((int)delims.getEscapedBy()), new IntWritable(delims.isEncloseRequired() ? 1 : 0)};
        hiveReplacement = opts.getHiveDelimsReplacement();
        if (hiveReplacement == null) {
            hiveReplacement = "";
        }
        LOG.debug((Object)"Setting hive delimiters information");
        DefaultStringifier.storeArray((Configuration)config, (Object[])delimChars, (String)HIVE_DELIMITERS_TO_REPLACE_PROP);
        config.set(HIVE_DELIMITERS_REPLACEMENT_PROP, hiveReplacement);
        if (opts.doHiveDropDelims() || opts.getHiveDelimsReplacement() != null) {
            LOG.debug((Object)"Enabling hive delimter replacement");
            config.set(HIVE_DELIMITERS_REPLACEMENT_ENABLED_PROP, "true");
        } else {
            LOG.debug((Object)"Disabling hive delimter replacement");
            config.set(HIVE_DELIMITERS_REPLACEMENT_ENABLED_PROP, "false");
        }
    }

    public static void configureExportInputFormat(SqoopOptions opts, Job job, ConnManager connMgr, String dbTable, Configuration config) throws IOException {
        LOG.info((Object)"Configuring HCatalog for export job");
        SqoopHCatUtilities hCatUtils = SqoopHCatUtilities.instance();
        hCatUtils.configureHCat(opts, job, connMgr, dbTable, job.getConfiguration());
        job.setInputFormatClass(SqoopHCatUtilities.getInputFormatClass());
        Map<String, Integer> dbColTypes = hCatUtils.getDbColumnTypes();
        MapWritable columnTypesJava = new MapWritable();
        for (Map.Entry<String, Integer> e : dbColTypes.entrySet()) {
            Text columnName = new Text(e.getKey());
            Text columnText = new Text(connMgr.toJavaType(dbTable, e.getKey(), e.getValue()));
            columnTypesJava.put((Writable)columnName, (Writable)columnText);
        }
        MapWritable columnTypesSql = new MapWritable();
        for (Map.Entry<String, Integer> e : dbColTypes.entrySet()) {
            Text columnName = new Text(e.getKey());
            IntWritable sqlType = new IntWritable(e.getValue().intValue());
            columnTypesSql.put((Writable)columnName, (Writable)sqlType);
        }
        DefaultStringifier.store((Configuration)config, (Object)columnTypesJava, (String)HCAT_DB_OUTPUT_COLTYPES_JAVA);
        DefaultStringifier.store((Configuration)config, (Object)columnTypesSql, (String)HCAT_DB_OUTPUT_COLTYPES_SQL);
    }

    public static void addJars(Job job, SqoopOptions options) throws IOException {
        if (SqoopHCatUtilities.isLocalJobTracker(job)) {
            LOG.info((Object)"Not adding hcatalog jars to distributed cache in local mode");
            return;
        }
        if (options.isSkipDistCache()) {
            LOG.info((Object)"Not adding hcatalog jars to distributed cache as requested");
            return;
        }
        Configuration conf = job.getConfiguration();
        String hiveHome = null;
        String hCatHome = null;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (options != null) {
            hiveHome = options.getHiveHome();
        }
        if (hiveHome == null) {
            hiveHome = SqoopOptions.getHiveHomeDefault();
        }
        if (options != null) {
            hCatHome = options.getHCatHome();
        }
        if (hCatHome == null) {
            hCatHome = SqoopOptions.getHCatHomeDefault();
        }
        LOG.info((Object)("HCatalog job : Hive Home = " + hiveHome));
        LOG.info((Object)("HCatalog job:  HCatalog Home = " + hCatHome));
        conf.addResource(hiveHome + HIVESITEXMLPATH);
        ArrayList<String> libDirs = new ArrayList<String>();
        libDirs.add(hCatHome + File.separator + HCATSHAREDIR);
        libDirs.add(hCatHome + File.separator + DEFLIBDIR);
        libDirs.add(hiveHome + File.separator + DEFLIBDIR);
        HashSet<String> localUrls = new HashSet<String>();
        localUrls.addAll(conf.getStringCollection("tmpjars"));
        for (String dir : libDirs) {
            LOG.info((Object)("Adding jar files under " + dir + " to distributed cache"));
            SqoopHCatUtilities.addDirToCache(new File(dir), (FileSystem)fs, localUrls, false);
        }
        String hCatStorageHandlerDir = hCatHome + File.separator + "share/hcatalog/storage-handlers";
        LOG.info((Object)("Adding jar files under " + hCatStorageHandlerDir + " to distributed cache (recursively)"));
        SqoopHCatUtilities.addDirToCache(new File(hCatStorageHandlerDir), (FileSystem)fs, localUrls, true);
        String tmpjars = conf.get("tmpjars");
        StringBuilder sb = new StringBuilder(1024);
        if (null != tmpjars) {
            sb.append(tmpjars);
            sb.append(",");
        }
        sb.append(StringUtils.arrayToString((String[])localUrls.toArray(new String[0])));
        conf.set("tmpjars", sb.toString());
    }

    private static void addDirToCache(File dir, FileSystem fs, Set<String> localUrls, boolean recursive) {
        if (dir == null) {
            return;
        }
        File[] fileList = dir.listFiles();
        if (fileList == null) {
            LOG.warn((Object)("No files under " + dir + " to add to distributed cache for hcatalog job"));
            return;
        }
        for (File libFile : dir.listFiles()) {
            if (libFile.exists() && !libFile.isDirectory() && libFile.getName().endsWith("jar")) {
                Path p = new Path(libFile.toString());
                if (libFile.canRead()) {
                    String qualified = p.makeQualified(fs).toString();
                    LOG.info((Object)("Adding to job classpath: " + qualified));
                    localUrls.add(qualified);
                } else {
                    LOG.warn((Object)("Ignoring unreadable file " + libFile));
                }
            }
            if (!recursive || !libFile.isDirectory()) continue;
            SqoopHCatUtilities.addDirToCache(libFile, fs, localUrls, recursive);
        }
    }

    public static boolean isHadoop1() {
        String version = VersionInfo.getVersion();
        return version.matches("\\b0\\.20\\..+\\b") || version.matches("\\b1\\.\\d\\.\\d");
    }

    public static boolean isLocalJobTracker(Job job) {
        Configuration conf = job.getConfiguration();
        if ("yarn".equalsIgnoreCase(conf.get("mapreduce.framework.name"))) {
            return false;
        }
        String jtAddr = conf.get("mapred.job.tracker");
        String jtAddr2 = conf.get("mapreduce.jobtracker.address");
        return jtAddr != null && jtAddr.equals("local") || jtAddr2 != null && jtAddr2.equals("local");
    }

    public void invokeOutputCommitterForLocalMode(Job job) throws IOException {
        if (SqoopHCatUtilities.isLocalJobTracker(job) && SqoopHCatUtilities.isHadoop1()) {
            Object shimLayer = null;
            Class<?> shimClass = null;
            try {
                shimClass = Class.forName("org.apache.hcatalog.shims.HCatHadoopShims");
                Class<?> shimInstanceClass = Class.forName("org.apache.hcatalog.shims.HCatHadoopShims$Instance");
                Method getMethod = shimInstanceClass.getMethod("get", new Class[0]);
                shimLayer = getMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.debug((Object)"Not found HCatalog 0.11- implementation of the Shim layer", (Throwable)e);
            }
            if (shimClass == null || shimLayer == null) {
                try {
                    shimClass = Class.forName("org.apache.hadoop.hive.shims.HadoopShims$HCatHadoopShims");
                    Class<?> shimLoader = Class.forName("org.apache.hadoop.hive.shims.ShimLoader");
                    Method getHadoopShims = shimLoader.getMethod("getHadoopShims", new Class[0]);
                    Object hadoopShims = getHadoopShims.invoke(null, new Object[0]);
                    Class<?> hadoopShimClass = Class.forName("org.apache.hadoop.hive.shims.HadoopShims");
                    Method getHCatShim = hadoopShimClass.getMethod("getHCatShim", new Class[0]);
                    shimLayer = getHCatShim.invoke(hadoopShims, new Object[0]);
                }
                catch (Exception e) {
                    LOG.debug((Object)"Not found HCatalog 0.12+ implementation of the Shim layer", (Throwable)e);
                }
            }
            if (shimClass == null || shimLayer == null) {
                throw new IOException("Did not found HCatalog shim layer to commit the job");
            }
            try {
                Method commitJobMethod = shimClass.getMethod("commitJob", OutputFormat.class, Job.class);
                LOG.info((Object)"Explicitly committing job in local mode");
                commitJobMethod.invoke(shimLayer, new HCatOutputFormat(), job);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't explicitly commit job", e);
            }
        }
    }

    public void launchHCatCli(String cmdLine) throws IOException {
        String tmpFileName = null;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (this.options != null) {
            tmpDir = this.options.getTempDir();
        }
        tmpFileName = new File(tmpDir, "hcat-script-" + System.currentTimeMillis()).getAbsolutePath();
        this.writeHCatScriptFile(tmpFileName, cmdLine);
        String[] argArray = new String[]{"-f", tmpFileName};
        String argLine = StringUtils.join((CharSequence)",", Arrays.asList(argArray));
        if (testMode) {
            LOG.debug((Object)("Executing HCatalog CLI in-process with " + argLine));
            this.executeHCatProgramInProcess(argArray);
        } else {
            LOG.info((Object)("Executing external HCatalog CLI process with args :" + argLine));
            this.executeExternalHCatProgram(Executor.getCurEnvpStrings(), argArray);
        }
    }

    public void writeHCatScriptFile(String fileName, String contents) throws IOException {
        BufferedWriter w = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            w = new BufferedWriter(new OutputStreamWriter(fos));
            w.write(contents, 0, contents.length());
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error writing HCatalog load-in script", (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (null != w) {
                try {
                    w.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"IOException closing stream to HCatalog script", (Throwable)ioe);
                }
            }
        }
    }

    public void executeExternalHCatProgram(List<String> env, String[] cmdLine) throws IOException {
        String hCatProgram = this.getHCatPath();
        ArrayList<String> args = new ArrayList<String>();
        if (Shell.WINDOWS) {
            args.add("python");
        }
        args.add(hCatProgram);
        if (cmdLine != null && cmdLine.length > 0) {
            for (String s : cmdLine) {
                args.add(s);
            }
        }
        LoggingAsyncSink logSink = new LoggingAsyncSink(LOG);
        int ret = Executor.exec(args.toArray(new String[0]), env.toArray(new String[0]), logSink, logSink);
        if (0 != ret) {
            throw new IOException("HCat exited with status " + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeHCatProgramInProcess(String[] argv) throws IOException {
        block11: {
            SubprocessSecurityManager subprocessSM = null;
            try {
                Class<?> cliDriverClass = Class.forName(HCAT_CLI_MAIN_CLASS);
                subprocessSM = new SubprocessSecurityManager();
                subprocessSM.install();
                Method mainMethod = cliDriverClass.getMethod("main", argv.getClass());
                mainMethod.invoke(null, new Object[]{argv});
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("HCatalog class not found", cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new IOException("Could not access HCatCli.main()", nsme);
            }
            catch (IllegalAccessException iae) {
                throw new IOException("Could not access HatCli.main()", iae);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof ExitSecurityException) {
                    ExitSecurityException ese = (ExitSecurityException)cause;
                    int status = ese.getExitStatus();
                    if (status != 0) {
                        throw new IOException("HCatCli  exited with status=" + status);
                    }
                    break block11;
                }
                throw new IOException("Exception thrown from HCatCli", ite);
            }
            finally {
                if (null != subprocessSM) {
                    subprocessSM.uninstall();
                }
            }
        }
    }

    public String getHCatPath() {
        String hCatHome = null;
        hCatHome = this.options == null ? SqoopOptions.getHCatHomeDefault() : this.options.getHCatHome();
        if (null == hCatHome) {
            return null;
        }
        Path p = new Path(hCatHome);
        p = new Path(p, "bin");
        String hCatBinStr = (p = new Path(p, HCATCMD)).toString();
        if (new File(hCatBinStr).canExecute()) {
            return hCatBinStr;
        }
        return null;
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public static Class<? extends InputFormat> getInputFormatClass() {
        return inputFormatClass;
    }

    public static Class<? extends OutputFormat> getOutputFormatClass() {
        return outputFormatClass;
    }

    public static void setInputFormatClass(Class<? extends InputFormat> clz) {
        inputFormatClass = clz;
    }

    public static void setOutputFormatClass(Class<? extends OutputFormat> clz) {
        outputFormatClass = clz;
    }

    public static Class<? extends Mapper> getImportMapperClass() {
        return importMapperClass;
    }

    public static Class<? extends Mapper> getExportMapperClass() {
        return exportMapperClass;
    }

    public static void setExportMapperClass(Class<? extends Mapper> clz) {
        exportMapperClass = clz;
    }

    public static void setImportMapperClass(Class<? extends Mapper> clz) {
        importMapperClass = clz;
    }

    public static Class<? extends Writable> getImportValueClass() {
        return importValueClass;
    }

    public static void setImportValueClass(Class<? extends Writable> clz) {
        importValueClass = clz;
    }

    public void setColumnTypes(Map<String, Integer> colTypes) {
        this.externalColTypes = colTypes;
        LOG.debug((Object)"Using test-controlled type map");
    }

    public String getDatabaseTable() {
        return this.dbTableName;
    }

    public String getHCatTableName() {
        return this.hCatTableName;
    }

    public String getHCatDatabaseName() {
        return this.hCatDatabaseName;
    }

    public String getQualifiedHCatTableName() {
        return this.hCatQualifiedTableName;
    }

    public List<String> getHCatDynamicPartitionKeys() {
        return this.hCatDynamicPartitionKeys;
    }

    public String getHCatStaticPartitionKey() {
        return this.hCatStaticPartitionKey;
    }

    public String[] getDBColumnNames() {
        return this.dbColumnNames;
    }

    public HCatSchema getHCatOutputSchema() {
        return this.hCatOutputSchema;
    }

    public void setHCatOutputSchema(HCatSchema schema) {
        this.hCatOutputSchema = schema;
    }

    public HCatSchema getHCatPartitionSchema() {
        return this.hCatPartitionSchema;
    }

    public void setHCatPartitionSchema(HCatSchema schema) {
        this.hCatPartitionSchema = schema;
    }

    public void setHCatStaticPartitionKey(String key) {
        this.hCatStaticPartitionKey = key;
    }

    public void setHCatDynamicPartitionKeys(List<String> keys) {
        this.hCatDynamicPartitionKeys = keys;
    }

    public String[] getDbColumnNames() {
        return this.dbColumnNames;
    }

    public void setDbColumnNames(String[] names) {
        this.dbColumnNames = names;
    }

    public Map<String, Integer> getDbColumnTypes() {
        return this.dbColumnTypes;
    }

    public void setDbColumnTypes(Map<String, Integer> types) {
        this.dbColumnTypes.putAll(types);
    }

    public String gethCatTableName() {
        return this.hCatTableName;
    }

    public String gethCatDatabaseName() {
        return this.hCatDatabaseName;
    }

    public String gethCatQualifiedTableName() {
        return this.hCatQualifiedTableName;
    }

    public void setConfigured(boolean value) {
        this.configured = value;
    }

    public static String sqlTypeString(int sqlType) {
        switch (sqlType) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 70: {
                return "DATALINK";
            }
            case 16: {
                return "BOOLEAN";
            }
            case -8: {
                return "ROWID";
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 2009: {
                return "SQLXML";
            }
        }
        return "<UNKNOWN>";
    }

    public static final class Holder {
        public static final SqoopHCatUtilities INSTANCE = new SqoopHCatUtilities();

        private Holder() {
        }
    }

    public class UCKeyMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -6751510232323094216L;

        @Override
        public V put(String key, V value) {
            return super.put(key.toUpperCase(), value);
        }

        @Override
        public V get(Object key) {
            return super.get(((String)key).toUpperCase());
        }
    }

    private static class LCKeyMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -6751510232323094216L;

        private LCKeyMap() {
        }

        @Override
        public V put(String key, V value) {
            return super.put(key.toLowerCase(), value);
        }

        @Override
        public V get(Object key) {
            return super.get(((String)key).toLowerCase());
        }
    }

    static class IntArrayWritable
    extends ArrayWritable {
        public IntArrayWritable() {
            super(IntWritable.class);
        }
    }
}

