/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xslt;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.apache.xml.utils.DefaultErrorHandler;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xslt.XsltData;
import org.pentaho.di.trans.steps.xslt.XsltMeta;

public class Xslt
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XsltMeta.class;
    private XsltMeta meta;
    private XsltData data;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public Xslt(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XsltMeta)smi;
        this.data = (XsltData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            int nrOutputProps;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (Const.isEmpty((String)this.meta.getResultfieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorResultFieldMissing", (String[])new String[0]));
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorResultFieldMissing", (String[])new String[0]));
            }
            if (Const.isEmpty((String)this.meta.getFieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXMLFieldMissing", (String[])new String[0]));
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXMLFieldMissing", (String[])new String[0]));
            }
            this.data.fieldposition = this.getInputRowMeta().indexOfValue(this.meta.getFieldname());
            if (this.data.fieldposition < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getFieldname() + "]");
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.CouldnotFindField", (String[])new String[]{this.meta.getFieldname()}));
            }
            if (this.meta.useXSLField()) {
                if (Const.isEmpty((String)this.meta.getXSLFileField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileFieldMissing", (String[])new String[0]));
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileFieldMissing", (String[])new String[0]));
                }
                this.data.fielxslfiledposition = this.getInputRowMeta().indexOfValue(this.meta.getXSLFileField());
                if (this.data.fielxslfiledposition < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileFieldFinding", (String[])new String[0]) + "[" + this.meta.getXSLFileField() + "]");
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileFieldFinding", (String[])new String[]{this.meta.getXSLFileField()}));
                }
            } else {
                if (Const.isEmpty((String)this.meta.getXslFilename())) {
                    this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFile", (String[])new String[0]));
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFile", (String[])new String[0]));
                }
                this.data.xslfilename = this.environmentSubstitute(this.meta.getXslFilename());
                FileObject file = null;
                try {
                    file = KettleVFS.getFileObject((String)this.data.xslfilename);
                    if (!file.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLFileNotExists", (String[])new String[]{this.data.xslfilename}));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLFileNotExists", (String[])new String[]{this.data.xslfilename}));
                    }
                    if (file.getType() != FileType.FILE) {
                        this.logError(BaseMessages.getString(PKG, (String)"Xslt.Log.ErrorXSLNotAFile", (String[])new String[]{this.data.xslfilename}));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ErrorXSLNotAFile", (String[])new String[]{this.data.xslfilename}));
                    }
                }
                catch (Exception e) {
                    throw new KettleStepException((Throwable)e);
                }
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            int n = nrOutputProps = this.meta.getOutputPropertyName() == null ? 0 : this.meta.getOutputPropertyName().length;
            if (nrOutputProps > 0) {
                this.data.outputProperties = new Properties();
                for (int i = 0; i < nrOutputProps; ++i) {
                    this.data.outputProperties.put(this.meta.getOutputPropertyName()[i], this.environmentSubstitute(this.meta.getOutputPropertyValue()[i]));
                }
                this.data.setOutputProperties = true;
            }
            int n2 = this.data.nrParams = this.meta.getParameterField() == null ? 0 : this.meta.getParameterField().length;
            if (this.data.nrParams > 0) {
                this.data.indexOfParams = new int[this.data.nrParams];
                this.data.nameOfParams = new String[this.data.nrParams];
                for (int i = 0; i < this.data.nrParams; ++i) {
                    String name = this.environmentSubstitute(this.meta.getParameterName()[i]);
                    String field = this.environmentSubstitute(this.meta.getParameterField()[i]);
                    if (Const.isEmpty((String)field)) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldMissing", (Object[])new Object[]{name, i}));
                    }
                    this.data.indexOfParams[i] = this.getInputRowMeta().indexOfValue(field);
                    if (this.data.indexOfParams[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.Exception.ParameterFieldNotFound", (String[])new String[]{name}));
                    }
                    this.data.nameOfParams[i] = name;
                }
                this.data.useParameters = true;
            }
            this.data.factory = TransformerFactory.newInstance();
            if (this.meta.getXSLFactory().equals("SAXON")) {
                this.data.factory = new TransformerFactoryImpl();
            }
        }
        String xmlValue = this.getInputRowMeta().getString(row, this.data.fieldposition);
        if (this.meta.useXSLField()) {
            this.data.xslfilename = this.getInputRowMeta().getString(row, this.data.fielxslfiledposition);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.XslfileNameFromFied", (String[])new String[]{this.data.xslfilename, this.meta.getXSLFileField()}));
            }
        }
        try {
            if (this.log.isDetailed()) {
                if (this.meta.isXSLFieldIsAFile()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.Filexsl", (String[])new String[0]) + this.data.xslfilename);
                } else {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.XslStream", (String[])new String[]{this.data.xslfilename}));
                }
            }
            Transformer transformer = this.data.getTemplate(this.data.xslfilename, this.data.xslIsAfile);
            if (this.data.setOutputProperties) {
                transformer.setOutputProperties(this.data.outputProperties);
            }
            if (this.data.useParameters) {
                for (int i = 0; i < this.data.nrParams; ++i) {
                    transformer.setParameter(this.data.nameOfParams[i], row[this.data.indexOfParams[i]]);
                }
            }
            StreamSource source = new StreamSource(new StringReader(xmlValue));
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Xslt.Log.FileResult", (String[])new String[0]));
                this.logDetailed(xmlString);
            }
            Object[] outputRowData = RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)xmlString);
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"Xslt.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DefaultErrorHandler.printLocation((PrintWriter)pw, (Throwable)e);
            pw.close();
            errorMessage = sw.toString() + "\n" + errorMessage;
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, this.meta.getResultfieldname(), "XSLT01");
            }
            this.logError(BaseMessages.getString(PKG, (String)("Xslt.ErrorProcesing : " + errorMessage), (String[])new String[0]));
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"Xslt.ErrorProcesing", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsltMeta)smi;
        this.data = (XsltData)sdi;
        if (super.init(smi, sdi)) {
            this.data.xslIsAfile = this.meta.useXSLField() && this.meta.isXSLFieldIsAFile() || !this.meta.useXSLField();
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsltMeta)smi;
        this.data = (XsltData)sdi;
        this.data.dispose();
        super.dispose(smi, sdi);
    }
}

