/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputsax;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSax;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxData;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxField;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxFieldPosition;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class XMLInputSaxMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fileName;
    private String[] fileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private XMLInputSaxField[] inputFields;
    private XMLInputSaxFieldPosition[] inputPosition;
    private List<String> definitionElement = new ArrayList<String>();
    private List<String> definitionAttribute = new ArrayList<String>();

    public XMLInputSaxField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(XMLInputSaxField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        XMLInputSaxMeta retval = (XMLInputSaxMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrAttributes = this.getDefinitionLength();
        int nrFields = this.inputFields.length;
        int nrPositions = this.inputPosition.length;
        retval.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrAttributes; ++i) {
            retval.setDefiningAttribute(this.getDefiningElement(i), this.getDefiningAttribute(i));
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (XMLInputSaxField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrPositions; ++i) {
            retval.inputPosition[i] = this.inputPosition[i];
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename);
        retval = retval + "    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField);
        retval = retval + "    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber);
        retval = retval + "    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField);
        retval = retval + "    <file>" + Const.CR;
        for (i = 0; i < this.fileName.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue((String)"name", (String)this.fileName[i]);
            retval = retval + "      " + XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]);
        }
        retval = retval + "      </file>" + Const.CR;
        retval = retval + "    <def_attributes>" + Const.CR;
        for (i = 0; i < this.definitionElement.size(); ++i) {
            retval = retval + "      " + XMLHandler.addTagValue((String)"def_element", (String)this.getDefiningElement(i));
            retval = retval + "      " + XMLHandler.addTagValue((String)"def_attribute", (String)this.getDefiningAttribute(i));
        }
        retval = retval + "      </def_attributes>" + Const.CR;
        retval = retval + "    <fields>" + Const.CR;
        for (i = 0; i < this.inputFields.length; ++i) {
            XMLInputSaxField field = this.inputFields[i];
            retval = retval + field.getXML();
        }
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "    <positions>" + Const.CR;
        for (i = 0; i < this.inputPosition.length; ++i) {
            retval = retval + "      " + XMLHandler.addTagValue((String)"position", (String)this.inputPosition[i].toString());
        }
        retval = retval + "      </positions>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node attributes = XMLHandler.getSubNode((Node)stepnode, (String)"def_attributes");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            Node positions = XMLHandler.getSubNode((Node)stepnode, (String)"positions");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrAttributes = XMLHandler.countNodes((Node)attributes, (String)"def_element");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrPositions = XMLHandler.countNodes((Node)positions, (String)"position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
            }
            this.clearDefinition();
            for (i = 0; i < nrAttributes; ++i) {
                Node elementnode = XMLHandler.getSubNodeByNr((Node)attributes, (String)"def_element", (int)i);
                Node attributenode = XMLHandler.getSubNodeByNr((Node)attributes, (String)"def_attribute", (int)i);
                String a = XMLHandler.getNodeValue((Node)elementnode);
                String b = XMLHandler.getNodeValue((Node)attributenode);
                this.setDefiningAttribute(a, b);
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputSaxField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new XMLInputSaxField(fnode);
            }
            for (i = 0; i < nrPositions; ++i) {
                Node positionnode = XMLHandler.getSubNodeByNr((Node)positions, (String)"position", (int)i);
                String encoded = XMLHandler.getNodeValue((Node)positionnode);
                this.inputPosition[i] = new XMLInputSaxFieldPosition(encoded);
            }
            String lim = XMLHandler.getTagValue((Node)stepnode, (String)"limit");
            this.rowLimit = Const.toLong((String)lim, (long)0L);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles, int nrfields, int nrPositions) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.inputFields = new XMLInputSaxField[nrfields];
        this.inputPosition = new XMLInputSaxFieldPosition[nrPositions];
        this.definitionElement = new ArrayList<String>();
        this.definitionAttribute = new ArrayList<String>();
    }

    @Override
    public void setDefault() {
        int i;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        int nrFiles = 0;
        int nrFields = 0;
        int nrPositions = 0;
        this.allocate(nrFiles, nrFields, nrPositions);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new XMLInputSaxField("field" + (i + 1), null);
        }
        for (i = 0; i < nrPositions; ++i) {
            try {
                this.inputPosition[i] = new XMLInputSaxFieldPosition("position" + (i + 1), 1);
                continue;
            }
            catch (KettleValueException e) {
                this.log.logError(Const.getStackTracker((Throwable)e));
            }
        }
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            XMLInputSaxField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)field.getName(), (int)type);
                v.setLength(field.getLength());
                v.setPrecision(field.getPrecision());
                v.setConversionMask(field.getFormat());
                v.setGroupingSymbol(field.getGroupSymbol());
                v.setDecimalSymbol(field.getDecimalSymbol());
                v.setCurrencySymbol(field.getCurrencySymbol());
                v.setOrigin(name);
                row.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            ValueMeta v = new ValueMeta(this.filenameField, 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(this.rowNumberField, 1);
            v.setLength(7, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrAttributes = rep.countNrStepAttributes(id_step, "def_element");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            int nrPositions = rep.countNrStepAttributes(id_step, "input_position");
            this.allocate(nrFiles, nrFields, nrPositions);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
            }
            this.clearDefinition();
            for (i = 0; i < nrAttributes; ++i) {
                String a = rep.getStepAttributeString(id_step, i, "def_element");
                String b = rep.getStepAttributeString(id_step, i, "def_attribute");
                this.setDefiningAttribute(a, b);
            }
            for (i = 0; i < nrFields; ++i) {
                XMLInputSaxField field = new XMLInputSaxField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(XMLInputSaxField.getTrimType(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                String fieldPositionCode = rep.getStepAttributeString(id_step, i, "field_position_code");
                if (fieldPositionCode != null) {
                    field.setFieldPosition(fieldPositionCode);
                }
                this.inputFields[i] = field;
            }
            for (i = 0; i < nrPositions; ++i) {
                String encoded = rep.getStepAttributeString(id_step, i, "input_position");
                this.inputPosition[i] = new XMLInputSaxFieldPosition(encoded);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
            }
            for (i = 0; i < this.getDefinitionLength(); ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "def_element", this.getDefiningElement(i));
                rep.saveStepAttribute(id_transformation, id_step, i, "def_attribute", this.getDefiningAttribute(i));
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                XMLInputSaxField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_position_code", field.getFieldPositionsCode());
            }
            for (i = 0; i < this.inputPosition.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "input_position", this.inputPosition[i].toString());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public String[] getFilePaths(VariableSpace space) {
        String[] fileRequired = new String[this.fileName.length];
        for (int i = 0; i < fileRequired.length; ++i) {
            fileRequired[i] = "N";
        }
        return FileInputList.createFilePathList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])new String[]{null}, (String[])fileRequired);
    }

    public FileInputList getTextFileList(VariableSpace space) {
        String[] fileRequired = new String[this.fileName.length];
        for (int i = 0; i < fileRequired.length; ++i) {
            fileRequired[i] = "N";
        }
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])new String[]{null}, (String[])fileRequired);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, "This step is not expecting nor reading any input", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Not receiving any input from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        String[] files = this.getFilePaths(transMeta);
        if (files == null || files.length == 0) {
            cr = new CheckResult(4, "No files can be found to read.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "This step is reading " + files.length + " files.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getInputPosition().length == 0) {
            cr = new CheckResult(4, "No location elements given. Please specify the location of the repeating node in the XML document.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "At least one location element specified.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getInputFields().length == 0) {
            cr = new CheckResult(4, "No field elements given. Please specify the fields you wish to extract from the XML document.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "At least one field element specified.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new XMLInputSax(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new XMLInputSaxData();
    }

    public XMLInputSaxFieldPosition[] getInputPosition() {
        return this.inputPosition;
    }

    public void setInputPosition(XMLInputSaxFieldPosition[] inputPosition) {
        this.inputPosition = inputPosition;
    }

    public void clearDefinition() {
        this.definitionElement.clear();
        this.definitionAttribute.clear();
    }

    public String getDefiningAttribute(String elementName) {
        int i;
        for (i = 0; i < this.definitionElement.size(); ++i) {
            if (!this.definitionElement.get(i).equals(elementName)) continue;
            return this.definitionAttribute.get(i);
        }
        for (i = 0; i < this.inputFields.length; ++i) {
            XMLInputSaxField field = this.inputFields[i];
            XMLInputSaxFieldPosition[] positions = field.getFieldPosition();
            for (int p = 0; p < positions.length; ++p) {
                XMLInputSaxFieldPosition position = positions[p];
                if (position.getType() != 3) continue;
                return position.getName();
            }
        }
        return null;
    }

    public int getDefiningAttributeNormalID(String attributeName) {
        for (int i = 0; i < this.inputFields.length; ++i) {
            XMLInputSaxField field = this.inputFields[i];
            XMLInputSaxFieldPosition[] positions = field.getFieldPosition();
            for (int p = 0; p < positions.length; ++p) {
                XMLInputSaxFieldPosition position = positions[p];
                if (position.getType() != 3 || !position.getName().equals(attributeName)) continue;
                return i;
            }
        }
        return -1;
    }

    public void setDefiningAttribute(String elementName, String attributeName) {
        int index = this.definitionElement.indexOf(elementName);
        if (index >= 0) {
            this.definitionAttribute.set(index, attributeName);
        } else {
            this.definitionAttribute.add(attributeName);
            this.definitionElement.add(elementName);
        }
    }

    public String getDefiningAttribute(int i) {
        return this.definitionAttribute.get(i);
    }

    public String getDefiningElement(int i) {
        return this.definitionElement.get(i);
    }

    public int getDefinitionLength() {
        return this.definitionElement.size();
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] textFiles = this.getFilePaths(transMeta);
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            for (int i = 0; i < this.fileName.length; ++i) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

