/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinputsax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxField;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxFieldPosition;
import org.pentaho.di.trans.steps.xmlinputsax.XMLInputSaxMeta;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLInputSaxFieldRetriever
extends DefaultHandler {
    List<XMLInputSaxField> fields;
    int[] position = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private List<XMLInputSaxFieldPosition> pathToRootElement = new ArrayList<XMLInputSaxFieldPosition>();
    private List<XMLInputSaxFieldPosition> _pathToRootElement = new ArrayList<XMLInputSaxFieldPosition>();
    private int counter = 0;
    private int _counter = -1;
    private boolean rootFound = false;
    private String sourceFile;
    private XMLInputSaxMeta meta;
    private LogChannelInterface log;

    public XMLInputSaxFieldRetriever(LogChannelInterface log, String sourceFile, XMLInputSaxMeta meta) {
        this.log = log;
        for (int i = 0; i < meta.getInputPosition().length; ++i) {
            this.pathToRootElement.add(meta.getInputPosition()[i]);
        }
        this.meta = meta;
        this.sourceFile = sourceFile;
        this.fields = new ArrayList<XMLInputSaxField>();
    }

    public List<XMLInputSaxField> getFields() {
        this.parseDocument();
        return this.fields;
    }

    private void parseDocument() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(this.sourceFile, (DefaultHandler)this);
        }
        catch (SAXException se) {
            this.log.logError(Const.getStackTracker((Throwable)se));
        }
        catch (ParserConfigurationException pce) {
            this.log.logError(Const.getStackTracker((Throwable)pce));
        }
        catch (IOException ie) {
            this.log.logError(Const.getStackTracker((Throwable)ie));
        }
    }

    private void counterUp() {
        if (this.counter == this.pathToRootElement.size() - 1) {
            this.rootFound = true;
            ++this.counter;
        } else {
            ++this.counter;
        }
    }

    private boolean comparePaths(int count) {
        for (int i = 0; i <= count; ++i) {
            if (this.pathToRootElement.get(i).equals(this.pathToRootElement.get(i))) continue;
            return false;
        }
        return true;
    }

    private void counterDown() {
        if (this.counter - 1 == this._counter && this.comparePaths(this._counter)) {
            this._pathToRootElement.remove(this._counter);
            --this.counter;
            --this._counter;
            this.rootFound = false;
        } else {
            this._pathToRootElement.remove(this._counter);
            --this._counter;
        }
    }

    private String naming(XMLInputSaxFieldPosition[] path) {
        String ret = "";
        for (int i = this.pathToRootElement.size(); i < path.length; ++i) {
            String name = path[i].getType() == 2 ? path[i].getAttributeValue() : path[i].getName() + path[i].getElementNr();
            ret = i > this.pathToRootElement.size() ? ret + "_" + name : ret + name;
        }
        return ret;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block16: {
            int n = this._counter + 1;
            this.position[n] = this.position[n] + 1;
            ++this._counter;
            try {
                if (!this.rootFound) {
                    XMLInputSaxFieldPosition el = null;
                    try {
                        el = this.pathToRootElement.get(this.counter);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new SAXException(e);
                    }
                    if (this.counter == this._counter && qName.equalsIgnoreCase(el.getName())) {
                        if (el.getType() == 2) {
                            String att2;
                            String att1 = attributes.getValue(el.getAttribute());
                            if (att1.equals(att2 = el.getAttributeValue())) {
                                this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, el.getAttribute(), el.getAttributeValue()));
                                if (this.counter == this.pathToRootElement.size() - 1) {
                                    for (int i = 0; i < attributes.getLength(); ++i) {
                                        XMLInputSaxFieldPosition tempP = new XMLInputSaxFieldPosition(attributes.getQName(i), 3, i + 1);
                                        this._pathToRootElement.add(tempP);
                                        XMLInputSaxFieldPosition[] path = new XMLInputSaxFieldPosition[this._pathToRootElement.size()];
                                        this._pathToRootElement.toArray(path);
                                        this._pathToRootElement.remove(this._pathToRootElement.size() - 1);
                                        XMLInputSaxField tempF = new XMLInputSaxField(tempP.getName(), path);
                                        if (this.fields.contains(tempF)) continue;
                                        this.fields.add(tempF);
                                    }
                                }
                                this.counterUp();
                            } else {
                                this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                            }
                        } else {
                            this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                            this.counterUp();
                        }
                    } else {
                        this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                    }
                    break block16;
                }
                XMLInputSaxField temp = null;
                if (attributes.getValue(this.meta.getDefiningAttribute(qName)) == null) {
                    this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, 1, this.position[this._counter] + 1));
                    XMLInputSaxFieldPosition[] path = new XMLInputSaxFieldPosition[this._pathToRootElement.size()];
                    this._pathToRootElement.toArray(path);
                    temp = new XMLInputSaxField(this.naming(path), path);
                } else {
                    String attribute = this.meta.getDefiningAttribute(qName);
                    this._pathToRootElement.add(new XMLInputSaxFieldPosition(qName, attribute, attributes.getValue(attribute)));
                    XMLInputSaxFieldPosition[] path = new XMLInputSaxFieldPosition[this._pathToRootElement.size()];
                    this._pathToRootElement.toArray(path);
                    temp = new XMLInputSaxField(this.naming(path), path);
                }
                if (!this.fields.contains(temp)) {
                    this.fields.add(temp);
                }
            }
            catch (KettleValueException e) {
                this.log.logError(Const.getStackTracker((Throwable)e));
                throw new SAXException(this._counter + "," + this.counter + this._pathToRootElement.get(this._pathToRootElement.size() - 1).toString(), (Exception)((Object)e));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.position[this._counter + 1] = -1;
        this.counterDown();
    }
}

