/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.univariatestats.FieldIndex;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsData;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMeta;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;

public class UnivariateStats
extends BaseStep
implements StepInterface {
    private UnivariateStatsMeta m_meta;
    private UnivariateStatsData m_data;
    private ArrayList<Number>[] m_dataCache;

    public UnivariateStats(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.m_meta = (UnivariateStatsMeta)smi;
        this.m_data = (UnivariateStatsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            Object[] outputRow = this.generateOutputRow();
            this.putRow(this.m_data.getOutputRowMeta(), outputRow);
            this.setOutputDone();
            this.m_dataCache = null;
            return false;
        }
        if (this.first) {
            this.first = false;
            RowMeta outputMeta = new RowMeta();
            this.m_data.setInputRowMeta(this.getInputRowMeta());
            this.m_data.setOutputRowMeta((RowMetaInterface)outputMeta);
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.m_dataCache = new ArrayList[this.m_meta.getNumFieldsToProcess()];
            FieldIndex[] fi = new FieldIndex[this.m_meta.getNumFieldsToProcess()];
            this.m_data.setFieldIndexes(fi);
            for (int i = 0; i < this.m_meta.getNumFieldsToProcess(); ++i) {
                UnivariateStatsMetaFunction usmf = this.m_meta.getInputFieldMetaFunctions()[i];
                this.m_data.getFieldIndexes()[i] = new FieldIndex();
                if (!Const.isEmpty((String)usmf.getSourceFieldName())) {
                    int fieldIndex = this.m_data.getInputRowMeta().indexOfValue(usmf.getSourceFieldName());
                    if (fieldIndex < 0) {
                        throw new KettleStepException("Unable to find the specified fieldname '" + usmf.getSourceFieldName() + "' for stats calc #" + (i + 1));
                    }
                    FieldIndex tempData = this.m_data.getFieldIndexes()[i];
                    tempData.m_columnIndex = fieldIndex;
                    ValueMetaInterface inputFieldMeta = this.m_data.getInputRowMeta().getValueMeta(fieldIndex);
                    if (!inputFieldMeta.isNumeric()) {
                        throw new KettleException("The input field for stats calc #" + (i + 1) + "is not numeric.");
                    }
                    tempData.m_min = Double.MAX_VALUE;
                    tempData.m_max = Double.MIN_VALUE;
                    if (!usmf.getCalcMedian() && !(usmf.getCalcPercentile() >= 0.0)) continue;
                    this.m_dataCache[i] = new ArrayList();
                    continue;
                }
                throw new KettleException("There is no input field specified for stats calc #" + (i + 1));
            }
        }
        for (int i = 0; i < this.m_meta.getNumFieldsToProcess(); ++i) {
            UnivariateStatsMetaFunction usmf = this.m_meta.getInputFieldMetaFunctions()[i];
            if (Const.isEmpty((String)usmf.getSourceFieldName())) continue;
            FieldIndex tempData = this.m_data.getFieldIndexes()[i];
            ValueMetaInterface metaI = this.getInputRowMeta().getValueMeta(tempData.m_columnIndex);
            Double input = null;
            try {
                input = metaI.getNumber(r[tempData.m_columnIndex]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (input == null) continue;
            if (usmf.getCalcMedian() || usmf.getCalcPercentile() >= 0.0) {
                this.m_dataCache[i].add(input);
            }
            double val = input;
            tempData.m_count += 1.0;
            tempData.m_sum += val;
            tempData.m_sumSq += val * val;
            if (val < tempData.m_min) {
                tempData.m_min = val;
            }
            if (!(val > tempData.m_max)) continue;
            tempData.m_max = val;
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + r);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] generateOutputRow() {
        int totalNumOutputFields = 0;
        for (int i = 0; i < this.m_meta.getNumFieldsToProcess(); ++i) {
            UnivariateStatsMetaFunction usmf = this.m_meta.getInputFieldMetaFunctions()[i];
            if (Const.isEmpty((String)usmf.getSourceFieldName())) continue;
            totalNumOutputFields += usmf.numberOfMetricsRequested();
        }
        Object[] result = new Object[totalNumOutputFields];
        int index = 0;
        for (int i = 0; i < this.m_meta.getNumFieldsToProcess(); ++i) {
            UnivariateStatsMetaFunction usmf = this.m_meta.getInputFieldMetaFunctions()[i];
            if (Const.isEmpty((String)usmf.getSourceFieldName())) continue;
            Object[] tempOut = this.m_data.getFieldIndexes()[i].generateOutputValues(usmf, this.m_dataCache[i]);
            for (int j = 0; j < tempOut.length; ++j) {
                result[index++] = tempOut[j];
            }
        }
        return result;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.m_meta = (UnivariateStatsMeta)smi;
        this.m_data = (UnivariateStatsData)sdi;
        return super.init(smi, sdi);
    }
}

